/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.lootgen.PlayerRangeWrapper;
import github.nighter.smartspawner.spawner.lootgen.RangeMath;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpawnerRangeChecker {
    private static final long CHECK_INTERVAL = 20L;
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final ExecutorService executor;

    public SpawnerRangeChecker(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "SmartSpawner-RangeCheck"));
        this.initializeRangeCheckTask();
    }

    private void initializeRangeCheckTask() {
        Scheduler.runTaskTimer(this::scheduleRegionSpecificCheck, 20L, 20L);
    }

    private void scheduleRegionSpecificCheck() {
        PlayerRangeWrapper[] rangePlayers = this.getRangePlayers();
        this.executor.execute(() -> {
            List<SpawnerData> allSpawners = this.spawnerManager.getAllSpawners();
            RangeMath rangeCheck = new RangeMath(rangePlayers, allSpawners);
            boolean[] spawnersPlayerFound = rangeCheck.getActiveSpawners();
            for (int i = 0; i < spawnersPlayerFound.length; ++i) {
                boolean expectedStop = !spawnersPlayerFound[i];
                SpawnerData sd = allSpawners.get(i);
                String spawnerId = sd.getSpawnerId();
                if (sd.getSpawnerStop().compareAndSet(!expectedStop, expectedStop)) {
                    Scheduler.runLocationTask(sd.getSpawnerLocation(), () -> {
                        if (!this.isSpawnerValid(sd)) {
                            this.cleanupRemovedSpawner(spawnerId);
                            return;
                        }
                        if (sd.getSpawnerStop().get() == expectedStop) {
                            this.handleSpawnerStateChange(sd, expectedStop);
                        }
                    });
                    continue;
                }
                if (!sd.getSpawnerActive().booleanValue() || sd.getSpawnerStop().get()) continue;
                this.checkAndSpawnLoot(sd);
            }
        });
    }

    private PlayerRangeWrapper[] getRangePlayers() {
        Player[] onlinePlayers = Bukkit.getOnlinePlayers().toArray(new Player[0]);
        PlayerRangeWrapper[] rangePlayers = new PlayerRangeWrapper[onlinePlayers.length];
        int i = 0;
        for (Player p : onlinePlayers) {
            boolean conditions = p.isConnected() && !p.isDead() && p.getGameMode() != GameMode.SPECTATOR;
            rangePlayers[i++] = new PlayerRangeWrapper(p.getWorld().getUID(), p.getX(), p.getY(), p.getZ(), conditions);
        }
        return rangePlayers;
    }

    private boolean isSpawnerValid(SpawnerData spawner) {
        SpawnerData current = this.spawnerManager.getSpawnerById(spawner.getSpawnerId());
        if (current == null) {
            return false;
        }
        if (current != spawner) {
            return false;
        }
        Location loc = spawner.getSpawnerLocation();
        return loc != null && loc.getWorld() != null;
    }

    private void cleanupRemovedSpawner(String spawnerId) {
        SpawnerData spawner = this.spawnerManager.getSpawnerById(spawnerId);
        if (spawner != null) {
            spawner.clearPreGeneratedLoot();
        }
    }

    private void handleSpawnerStateChange(SpawnerData spawner, boolean shouldStop) {
        if (!shouldStop) {
            this.activateSpawner(spawner);
        } else {
            this.deactivateSpawner(spawner);
        }
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().forceStateChangeUpdate(spawner);
        }
    }

    public void activateSpawner(SpawnerData spawner) {
        this.deactivateSpawner(spawner);
        if (!spawner.getSpawnerActive().booleanValue()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        spawner.setLastSpawnTime(currentTime);
        if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
            this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
        }
    }

    public void deactivateSpawner(SpawnerData spawner) {
        spawner.clearPreGeneratedLoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSpawnLoot(SpawnerData spawner) {
        block8: {
            long lastSpawnTime;
            long cachedDelay = spawner.getCachedSpawnDelay();
            if (cachedDelay == 0L) {
                cachedDelay = (spawner.getSpawnDelay() + 20L) * 50L;
                spawner.setCachedSpawnDelay(cachedDelay);
            }
            long finalCachedDelay = cachedDelay;
            long currentTime = System.currentTimeMillis();
            long timeElapsed = currentTime - (lastSpawnTime = spawner.getLastSpawnTime().longValue());
            if (timeElapsed >= cachedDelay) {
                try {
                    if (!spawner.getDataLock().tryLock(50L, TimeUnit.MILLISECONDS)) break block8;
                    try {
                        Location spawnerLocation;
                        currentTime = System.currentTimeMillis();
                        lastSpawnTime = spawner.getLastSpawnTime();
                        timeElapsed = currentTime - lastSpawnTime;
                        if (timeElapsed >= cachedDelay && spawner.getSpawnerActive().booleanValue() && !spawner.getSpawnerStop().get() && (spawnerLocation = spawner.getSpawnerLocation()) != null) {
                            Scheduler.runLocationTask(spawnerLocation, () -> {
                                if (!spawner.getSpawnerActive().booleanValue() || spawner.getSpawnerStop().get()) {
                                    spawner.clearPreGeneratedLoot();
                                    return;
                                }
                                long timeSinceLastSpawn = System.currentTimeMillis() - spawner.getLastSpawnTime();
                                if (timeSinceLastSpawn < finalCachedDelay - 100L) {
                                    if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
                                        this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
                                    }
                                    return;
                                }
                                if (spawner.hasPreGeneratedLoot()) {
                                    List<ItemStack> items = spawner.getAndClearPreGeneratedItems();
                                    int exp = spawner.getAndClearPreGeneratedExperience();
                                    this.plugin.getSpawnerLootGenerator().addPreGeneratedLoot(spawner, items, exp);
                                } else {
                                    this.plugin.getSpawnerLootGenerator().spawnLootToSpawner(spawner);
                                }
                                if (this.plugin.getSpawnerGuiViewManager().hasViewers(spawner)) {
                                    this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
                                }
                            });
                        }
                    }
                    finally {
                        spawner.getDataLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public void cleanup() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

