/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen.loot;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public record LootItem(Material material, int minAmount, int maxAmount, double chance, Integer minDurability, Integer maxDurability, PotionType potionType, double sellPrice) {
    public ItemStack createItemStack(Random random) {
        ItemMeta meta;
        if (this.material == null) {
            return null;
        }
        ItemStack item = new ItemStack(this.material, 1);
        if (this.minDurability != null && this.maxDurability != null && (meta = item.getItemMeta()) instanceof Damageable) {
            int durability = random.nextInt(this.maxDurability - this.minDurability + 1) + this.minDurability;
            ((Damageable)meta).setDamage(durability);
            item.setItemMeta(meta);
        }
        if (this.material == Material.TIPPED_ARROW && this.potionType != null && (meta = (PotionMeta)item.getItemMeta()) != null) {
            meta.setBasePotionType(this.potionType);
            item.setItemMeta(meta);
        }
        return item;
    }

    public int generateAmount(Random random) {
        return random.nextInt(this.maxAmount - this.minAmount + 1) + this.minAmount;
    }

    public boolean isAvailable() {
        return this.material != null;
    }
}

