/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.utils;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;

public class SpawnerLocationLockManager {
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final ConcurrentHashMap<Location, ReentrantLock> locationLocks = new ConcurrentHashMap(128, 0.75f, 4);

    public SpawnerLocationLockManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.startCleanupTask();
    }

    public ReentrantLock getLock(Location location) {
        return this.locationLocks.computeIfAbsent(location, k -> new ReentrantLock());
    }

    public boolean tryLock(Location location) {
        ReentrantLock lock = this.getLock(location);
        return lock.tryLock();
    }

    public void unlock(Location location) {
        ReentrantLock lock = this.locationLocks.get(location);
        if (lock != null && lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    public void removeLock(Location location) {
        this.locationLocks.remove(location);
    }

    public boolean isLocked(Location location) {
        ReentrantLock lock = this.locationLocks.get(location);
        return lock != null && lock.isLocked();
    }

    public int getActiveLockCount() {
        return this.locationLocks.size();
    }

    private void startCleanupTask() {
        Scheduler.runTaskTimerAsync(() -> {
            Iterator<Map.Entry<Location, ReentrantLock>> iterator = this.locationLocks.entrySet().iterator();
            int removed = 0;
            while (iterator.hasNext()) {
                Map.Entry<Location, ReentrantLock> entry = iterator.next();
                ReentrantLock lock = entry.getValue();
                Location location = entry.getKey();
                if (lock.isLocked() || !lock.tryLock()) continue;
                try {
                    if (this.spawnerManager.getSpawnerByLocation(location) != null) continue;
                    iterator.remove();
                    ++removed;
                }
                finally {
                    lock.unlock();
                }
            }
            if (removed > 0) {
                this.plugin.debug("SpawnerLocationLockManager: Cleaned up " + removed + " unused locks. Active locks: " + this.locationLocks.size());
            }
        }, 6000L, 6000L);
    }

    public void shutdown() {
        this.locationLocks.clear();
    }
}

