/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.prices;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.prices.holders.PricesHolder;
import github.nighter.smartspawner.hooks.economy.ItemPriceManager;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.LootItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PricesGUI
implements Listener {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final ItemPriceManager priceManager;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int GUI_SIZE = 54;

    public PricesGUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.priceManager = plugin.getItemPriceManager();
    }

    public void openPricesGUI(Player player, int page) {
        if (!player.hasPermission("smartspawner.command.prices")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        Map<Material, PriceInfo> allItems = this.collectAllPriceableItems();
        if (allItems.isEmpty()) {
            this.messageService.sendMessage(player, "no_priceable_items");
            return;
        }
        List sortedItems = allItems.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(Enum::name))).toList();
        int totalPages = (int)Math.ceil((double)sortedItems.size() / 45.0);
        if (page > totalPages) {
            page = totalPages;
        }
        if (page < 1) {
            page = 1;
        }
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new PricesHolder(page, totalPages), (int)54, (String)this.languageManager.getGuiTitle("prices_gui_title", Map.of("current_page", String.valueOf(page), "total_pages", String.valueOf(totalPages))));
        int startIndex = (page - 1) * 45;
        int endIndex = Math.min(startIndex + 45, sortedItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry entry = sortedItems.get(i);
            ItemStack itemStack = this.createPriceDisplayItem(entry.getKey(), (PriceInfo)entry.getValue());
            inventory.setItem(i - startIndex, itemStack);
        }
        this.addNavigationButtons(inventory, page, totalPages);
        player.openInventory(inventory);
    }

    private Map<Material, PriceInfo> collectAllPriceableItems() {
        HashMap<Material, PriceInfo> allItems = new HashMap<Material, PriceInfo>();
        for (EntityType entityType : EntityType.values()) {
            EntityLootConfig lootConfig = this.plugin.getSpawnerSettingsConfig().getLootConfig(entityType);
            if (lootConfig == null) continue;
            for (LootItem lootItem : lootConfig.getAllItems()) {
                Material material;
                double finalPrice;
                if (!lootItem.isAvailable() || !((finalPrice = this.priceManager.getPrice(material = lootItem.getMaterial())) > 0.0)) continue;
                double customPrice = this.getCustomPrice(material);
                double shopPrice = this.getShopPrice(material);
                String priceSource = this.determinePriceSource(material, finalPrice, customPrice, shopPrice);
                allItems.put(material, new PriceInfo(finalPrice, priceSource, customPrice, shopPrice));
            }
        }
        return allItems;
    }

    private double getCustomPrice(Material material) {
        Map<String, Double> allPrices = this.priceManager.getAllPrices();
        return allPrices.getOrDefault(material.name(), 0.0);
    }

    private double getShopPrice(Material material) {
        if (this.priceManager.getShopIntegrationManager() == null) {
            return 0.0;
        }
        return this.priceManager.getShopIntegrationManager().getPrice(material);
    }

    private String determinePriceSource(Material material, double finalPrice, double customPrice, double shopPrice) {
        if (Math.abs(finalPrice - customPrice) < 0.001 && customPrice > 0.0) {
            return "Custom";
        }
        if (Math.abs(finalPrice - shopPrice) < 0.001 && shopPrice > 0.0) {
            return "Shop";
        }
        if (finalPrice > 0.0) {
            return "Default";
        }
        return "Unknown";
    }

    private ItemStack createPriceDisplayItem(Material material, PriceInfo priceInfo) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        String materialName = this.languageManager.getVanillaItemName(material);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("item_name", materialName);
        placeholders.put("\u026a\u1d1b\u1d07\u1d0d_\u0274\u1d00\u1d0d\u1d07", this.languageManager.getSmallCaps(materialName));
        placeholders.put("price", this.languageManager.formatNumber(priceInfo.finalPrice));
        placeholders.put("price_source", priceInfo.source);
        meta.setDisplayName(this.languageManager.getGuiItemName("price_item.name", placeholders));
        ArrayList<String> lore = new ArrayList<String>();
        placeholders.put("custom_price", this.languageManager.formatNumber(priceInfo.customPrice));
        placeholders.put("shop_price", this.languageManager.formatNumber(priceInfo.shopPrice));
        lore.addAll(this.languageManager.getGuiItemLoreAsList("price_item.lore", placeholders));
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE});
        item.setItemMeta(meta);
        return item;
    }

    private void addNavigationButtons(Inventory inventory, int currentPage, int totalPages) {
        ItemStack closeButton;
        ItemMeta closeMeta;
        if (currentPage > 1) {
            ItemStack prevButton = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevButton.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(this.languageManager.getGuiItemName("navigation.previous_page"));
                prevButton.setItemMeta(prevMeta);
            }
            inventory.setItem(45, prevButton);
        }
        if ((closeMeta = (closeButton = new ItemStack(Material.BARRIER)).getItemMeta()) != null) {
            closeMeta.setDisplayName(this.languageManager.getGuiItemName("navigation.close"));
            closeButton.setItemMeta(closeMeta);
        }
        inventory.setItem(49, closeButton);
        if (currentPage < totalPages) {
            ItemStack nextButton = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextButton.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(this.languageManager.getGuiItemName("navigation.next_page"));
                nextButton.setItemMeta(nextMeta);
            }
            inventory.setItem(53, nextButton);
        }
    }

    @EventHandler
    public void onPricesGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof PricesHolder)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        event.setCancelled(true);
        PricesHolder holder = (PricesHolder)event.getInventory().getHolder(false);
        if (holder == null) {
            return;
        }
        int slot = event.getSlot();
        int currentPage = holder.getCurrentPage();
        int totalPages = holder.getTotalPages();
        if (slot == 45 && currentPage > 1) {
            this.openPricesGUI(player, currentPage - 1);
        } else if (slot == 53 && currentPage < totalPages) {
            this.openPricesGUI(player, currentPage + 1);
        } else if (slot == 49) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private static class PriceInfo {
        final double finalPrice;
        final String source;
        final double customPrice;
        final double shopPrice;

        PriceInfo(double finalPrice, String source, double customPrice, double shopPrice) {
            this.finalPrice = finalPrice;
            this.source = source;
            this.customPrice = customPrice;
            this.shopPrice = shopPrice;
        }
    }
}

