/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.bedrock;

import github.nighter.smartspawner.SmartSpawner;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;

public class FloodgateHook {
    private final SmartSpawner plugin;
    private FloodgateApi floodgateApi;
    private boolean enabled = false;

    public FloodgateHook(SmartSpawner plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    private void initialize() {
        try {
            if (this.plugin.getServer().getPluginManager().getPlugin("floodgate") == null) {
                this.plugin.debug("Floodgate plugin not found");
                return;
            }
            this.floodgateApi = FloodgateApi.getInstance();
            if (this.floodgateApi == null) {
                this.plugin.getLogger().warning("Failed to get FloodgateApi instance");
                return;
            }
            this.enabled = true;
            this.plugin.getLogger().info("Floodgate integration initialized successfully!");
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            this.plugin.debug("Floodgate API not available: " + e.getMessage());
            this.enabled = false;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error initializing Floodgate integration: " + e.getMessage());
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled && this.floodgateApi != null;
    }

    public boolean isBedrockPlayer(Player player) {
        if (!this.isEnabled() || player == null) {
            return false;
        }
        try {
            return this.floodgateApi.isFloodgatePlayer(player.getUniqueId());
        }
        catch (Exception e) {
            this.plugin.debug("Error checking if player is Bedrock: " + e.getMessage());
            return false;
        }
    }

    public boolean isBedrockPlayer(UUID uuid) {
        if (!this.isEnabled() || uuid == null) {
            return false;
        }
        try {
            return this.floodgateApi.isFloodgatePlayer(uuid);
        }
        catch (Exception e) {
            this.plugin.debug("Error checking if UUID is Bedrock: " + e.getMessage());
            return false;
        }
    }

    public FloodgateApi getApi() {
        return this.floodgateApi;
    }
}

