/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.protections.api;

import com.bgsoftware.superiorskyblock.api.SuperiorSkyblockAPI;
import com.bgsoftware.superiorskyblock.api.events.IslandDisbandEvent;
import com.bgsoftware.superiorskyblock.api.island.Island;
import com.bgsoftware.superiorskyblock.api.island.IslandPrivilege;
import com.bgsoftware.superiorskyblock.api.world.Dimension;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class SuperiorSkyblock2
implements Listener {
    private static final String SPAWNER_STACK_PERM = "spawner_stack";
    private static final String SPAWNER_OPEN_MENU_PERM = "spawner_open_menu";
    private static IslandPrivilege SPAWNER_STACK;
    private static IslandPrivilege SPAWNER_OPEN_MENU;
    private static boolean registered;

    public SuperiorSkyblock2() {
        SuperiorSkyblock2.register();
    }

    public static void register() {
        if (registered) {
            return;
        }
        try {
            SPAWNER_STACK = IslandPrivilege.getByName((String)SPAWNER_STACK_PERM);
            SPAWNER_OPEN_MENU = IslandPrivilege.getByName((String)SPAWNER_OPEN_MENU_PERM);
        }
        catch (NullPointerException e) {
            IslandPrivilege.register((String)SPAWNER_STACK_PERM);
            IslandPrivilege.register((String)SPAWNER_OPEN_MENU_PERM);
            try {
                SPAWNER_STACK = IslandPrivilege.getByName((String)SPAWNER_STACK_PERM);
                SPAWNER_OPEN_MENU = IslandPrivilege.getByName((String)SPAWNER_OPEN_MENU_PERM);
            }
            catch (Exception ex) {
                SmartSpawner.getInstance().getLogger().severe("Failed to register SuperiorSkyblock Hook - please open a issue on Github or on Discord");
                e.printStackTrace();
                return;
            }
        }
        registered = true;
    }

    public static boolean canPlayerStackBlock(@NotNull Player player, @NotNull Location location) {
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        if (island != null) {
            return !island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), SPAWNER_STACK);
        }
        return false;
    }

    public static boolean canPlayerOpenMenu(@NotNull Player player, @NotNull Location location) {
        Island island = SuperiorSkyblockAPI.getIslandAt((Location)location);
        if (island != null) {
            return !island.hasPermission(SuperiorSkyblockAPI.getPlayer((UUID)player.getUniqueId()), SPAWNER_OPEN_MENU);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onIslandDisband(IslandDisbandEvent event) {
        if (event.isCancelled() || event.getIsland() == null) {
            return;
        }
        Island island = event.getIsland();
        for (Dimension dimension : Dimension.values()) {
            try {
                island.getAllChunksAsync(dimension, 3, chunk -> {
                    for (BlockState state : chunk.getTileEntities(block -> block.getType() == Material.SPAWNER, false)) {
                        SpawnerData spawner = SmartSpawner.getInstance().getSpawnerManager().getSpawnerByLocation(state.getBlock().getLocation());
                        if (spawner == null) continue;
                        SmartSpawner.getInstance().getSpawnerManager().removeGhostSpawner(spawner.getSpawnerId());
                    }
                });
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    static {
        registered = false;
    }
}

