/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.config;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.config.ItemSpawnerSettingsConfig;
import github.nighter.smartspawner.spawner.config.SpawnerSettingsConfig;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class SpawnerMobHeadTexture {
    private static final Map<EntityType, ItemStack> HEAD_CACHE = new EnumMap<EntityType, ItemStack>(EntityType.class);
    private static final Map<EntityType, SkullMeta> BASE_META_CACHE = new EnumMap<EntityType, SkullMeta>(EntityType.class);
    private static final Map<Material, ItemStack> ITEM_HEAD_CACHE = new EnumMap<Material, ItemStack>(Material.class);
    private static final ItemStack DEFAULT_SPAWNER_BLOCK = new ItemStack(Material.SPAWNER);

    private static boolean isBedrockPlayer(Player player) {
        SmartSpawner plugin = SmartSpawner.getInstance();
        if (plugin == null || plugin.getIntegrationManager() == null || plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }

    public static ItemStack getCustomHead(EntityType entityType, Player player, Consumer<ItemMeta> metaModifier) {
        if (entityType == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        if (SpawnerMobHeadTexture.isBedrockPlayer(player)) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        return SpawnerMobHeadTexture.getCustomHead(entityType, metaModifier);
    }

    public static ItemStack getCustomHead(EntityType entityType) {
        return SpawnerMobHeadTexture.getCustomHead(entityType, null);
    }

    public static ItemStack getCustomHead(EntityType entityType, Consumer<ItemMeta> metaModifier) {
        if (entityType == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        SmartSpawner plugin = SmartSpawner.getInstance();
        if (plugin == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        SpawnerSettingsConfig settingsConfig = plugin.getSpawnerSettingsConfig();
        if (settingsConfig == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        Material material = settingsConfig.getMaterial(entityType);
        if (material != Material.PLAYER_HEAD) {
            ItemStack item = new ItemStack(material);
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        if (!settingsConfig.hasCustomTexture(entityType)) {
            ItemStack item = new ItemStack(material);
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        SkullMeta baseMeta = BASE_META_CACHE.get(entityType);
        if (baseMeta == null) {
            try {
                String texture = settingsConfig.getCustomTexture(entityType);
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
                PlayerTextures textures = profile.getTextures();
                URL url = new URL("http://textures.minecraft.net/texture/" + texture);
                textures.setSkin(url);
                profile.setTextures(textures);
                ItemStack tempHead = new ItemStack(Material.PLAYER_HEAD);
                SkullMeta tempMeta = (SkullMeta)tempHead.getItemMeta();
                tempMeta.setOwnerProfile(profile);
                baseMeta = tempMeta.clone();
                BASE_META_CACHE.put(entityType, baseMeta);
            }
            catch (Exception e) {
                e.printStackTrace();
                ItemStack item = new ItemStack(material);
                if (metaModifier != null) {
                    item.editMeta(metaModifier);
                }
                return item;
            }
        }
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = baseMeta.clone();
        if (metaModifier != null) {
            metaModifier.accept((ItemMeta)meta);
        }
        head.setItemMeta((ItemMeta)meta);
        if (metaModifier == null && !HEAD_CACHE.containsKey(entityType)) {
            HEAD_CACHE.put(entityType, head.clone());
        }
        return head;
    }

    public static ItemStack getItemSpawnerHead(Material itemMaterial, Player player, Consumer<ItemMeta> metaModifier) {
        if (itemMaterial == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        if (SpawnerMobHeadTexture.isBedrockPlayer(player)) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        return SpawnerMobHeadTexture.getItemSpawnerHead(itemMaterial, metaModifier);
    }

    public static ItemStack getItemSpawnerHead(Material itemMaterial, Consumer<ItemMeta> metaModifier) {
        if (itemMaterial == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        SmartSpawner plugin = SmartSpawner.getInstance();
        if (plugin == null || plugin.getItemSpawnerSettingsConfig() == null) {
            ItemStack item = DEFAULT_SPAWNER_BLOCK.clone();
            if (metaModifier != null) {
                item.editMeta(metaModifier);
            }
            return item;
        }
        ItemSpawnerSettingsConfig.ItemHeadData headData = plugin.getItemSpawnerSettingsConfig().getHeadData(itemMaterial);
        Material headMaterial = headData.getMaterial();
        ItemStack item = new ItemStack(headMaterial);
        if (metaModifier != null) {
            item.editMeta(metaModifier);
        }
        if (metaModifier == null && !ITEM_HEAD_CACHE.containsKey(itemMaterial)) {
            ITEM_HEAD_CACHE.put(itemMaterial, item.clone());
        }
        return item;
    }

    public static void clearCache() {
        HEAD_CACHE.clear();
        BASE_META_CACHE.clear();
        ITEM_HEAD_CACHE.clear();
    }

    public static void prewarmCache() {
        SmartSpawner plugin = SmartSpawner.getInstance();
        if (plugin == null) {
            return;
        }
        Scheduler.runTaskAsync(() -> {
            EntityType[] commonTypes;
            SpawnerSettingsConfig settingsConfig = plugin.getSpawnerSettingsConfig();
            if (settingsConfig == null) {
                return;
            }
            for (EntityType type : commonTypes = new EntityType[]{EntityType.ZOMBIE, EntityType.SKELETON, EntityType.CREEPER, EntityType.SPIDER, EntityType.ENDERMAN, EntityType.BLAZE, EntityType.SLIME, EntityType.MAGMA_CUBE, EntityType.GHAST, EntityType.PIG, EntityType.COW, EntityType.CHICKEN, EntityType.SHEEP, EntityType.IRON_GOLEM, EntityType.WITHER_SKELETON, EntityType.ZOGLIN, EntityType.HOGLIN, EntityType.CAVE_SPIDER}) {
                try {
                    if (settingsConfig.getMaterial(type) != Material.PLAYER_HEAD || !settingsConfig.hasCustomTexture(type)) continue;
                    SpawnerMobHeadTexture.getCustomHead(type, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

