/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.layout;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.updates.GuiLayoutUpdater;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuiLayoutConfig {
    private static final String GUI_LAYOUTS_DIR = "gui_layouts";
    private static final String STORAGE_GUI_FILE = "storage_gui.yml";
    private static final String MAIN_GUI_FILE = "main_gui.yml";
    private static final String DEFAULT_LAYOUT = "default";
    private static final int MIN_SLOT = 1;
    private static final int MAX_SLOT = 9;
    private static final int SLOT_OFFSET = 44;
    private static final int MAIN_GUI_SIZE = 27;
    private final SmartSpawner plugin;
    private final File layoutsDir;
    private final GuiLayoutUpdater layoutUpdater;
    private String currentLayout;
    private GuiLayout currentStorageLayout;
    private GuiLayout currentMainLayout;

    public GuiLayoutConfig(SmartSpawner plugin) {
        this.plugin = plugin;
        this.layoutsDir = new File(plugin.getDataFolder(), GUI_LAYOUTS_DIR);
        this.layoutUpdater = new GuiLayoutUpdater(plugin);
        this.loadLayout();
    }

    public void loadLayout() {
        this.currentLayout = this.plugin.getConfig().getString("gui_layout", DEFAULT_LAYOUT);
        this.initializeLayoutsDirectory();
        this.layoutUpdater.checkAndUpdateLayouts();
        this.currentStorageLayout = this.loadCurrentStorageLayout();
        this.currentMainLayout = this.loadCurrentMainLayout();
    }

    private void initializeLayoutsDirectory() {
        if (!this.layoutsDir.exists()) {
            this.layoutsDir.mkdirs();
        }
        this.autoSaveLayoutFiles();
    }

    private void autoSaveLayoutFiles() {
        try {
            String[] layoutNames;
            for (String layoutName : layoutNames = new String[]{DEFAULT_LAYOUT, "DonutSMP"}) {
                File layoutDir = new File(this.layoutsDir, layoutName);
                if (!layoutDir.exists()) {
                    layoutDir.mkdirs();
                }
                File storageFile = new File(layoutDir, STORAGE_GUI_FILE);
                String storageResourcePath = "gui_layouts/" + layoutName + "/storage_gui.yml";
                if (!storageFile.exists()) {
                    try {
                        this.plugin.saveResource(storageResourcePath, false);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.WARNING, "Failed to auto-save storage layout resource for " + layoutName + ": " + e.getMessage(), e);
                    }
                }
                File mainFile = new File(layoutDir, MAIN_GUI_FILE);
                String mainResourcePath = "gui_layouts/" + layoutName + "/main_gui.yml";
                if (mainFile.exists()) continue;
                try {
                    this.plugin.saveResource(mainResourcePath, false);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to auto-save main layout resource for " + layoutName + ": " + e.getMessage(), e);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to auto-save layout files", e);
        }
    }

    private GuiLayout loadCurrentStorageLayout() {
        return this.loadLayoutFromFile(STORAGE_GUI_FILE, "storage");
    }

    private GuiLayout loadCurrentMainLayout() {
        return this.loadLayoutFromFile(MAIN_GUI_FILE, "main");
    }

    private GuiLayout loadLayoutFromFile(String fileName, String layoutType) {
        GuiLayout layout;
        File layoutDir = new File(this.layoutsDir, this.currentLayout);
        File layoutFile = new File(layoutDir, fileName);
        if (layoutFile.exists() && (layout = this.loadLayout(layoutFile, layoutType)) != null) {
            this.plugin.getLogger().info("Loaded " + layoutType + " GUI layout: " + this.currentLayout);
            return layout;
        }
        if (!this.currentLayout.equals(DEFAULT_LAYOUT)) {
            GuiLayout defaultLayout;
            this.plugin.getLogger().warning("Layout '" + this.currentLayout + "' not found. Attempting to use default layout.");
            File defaultLayoutDir = new File(this.layoutsDir, DEFAULT_LAYOUT);
            File defaultLayoutFile = new File(defaultLayoutDir, fileName);
            if (defaultLayoutFile.exists() && (defaultLayout = this.loadLayout(defaultLayoutFile, layoutType)) != null) {
                this.plugin.getLogger().info("Loaded default " + layoutType + " layout as fallback");
                return defaultLayout;
            }
        }
        this.plugin.getLogger().severe("No valid " + layoutType + " layout found! Creating empty layout as fallback.");
        return new GuiLayout();
    }

    private GuiLayout loadLayout(File file, String layoutType) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            GuiLayout layout = new GuiLayout();
            if (!config.contains("buttons")) {
                this.plugin.getLogger().warning("No buttons section found in GUI layout: " + file.getName());
                return layout;
            }
            for (String buttonKey : config.getConfigurationSection("buttons").getKeys(false)) {
                if (this.loadButton((FileConfiguration)config, layout, buttonKey, layoutType)) continue;
            }
            return layout;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load " + layoutType + " layout from " + file.getName() + ": " + e.getMessage(), e);
            return null;
        }
    }

    private boolean loadButton(FileConfiguration config, GuiLayout layout, String buttonKey, String layoutType) {
        String path = "buttons." + buttonKey;
        if (!config.getBoolean(path + ".enabled", true)) {
            return false;
        }
        int slot = config.getInt(path + ".slot", -1);
        String materialName = config.getString(path + ".material", "STONE");
        String condition = config.getString(path + ".condition", null);
        if (!this.isValidSlot(slot, layoutType)) {
            this.plugin.getLogger().warning(String.format("Invalid slot %d for button %s in %s layout. Must be between %d and %d.", slot, buttonKey, layoutType, this.getMinSlot(layoutType), this.getMaxSlot(layoutType)));
            return false;
        }
        if (condition != null && !this.evaluateCondition(condition)) {
            return false;
        }
        Material material = this.parseMaterial(materialName, buttonKey);
        int actualSlot = this.calculateActualSlot(slot, layoutType);
        HashMap<String, String> actions = new HashMap<String, String>();
        ConfigurationSection actionsSection = config.getConfigurationSection(path + ".actions");
        if (actionsSection != null && !actionsSection.getKeys(false).isEmpty()) {
            for (String actionKey : actionsSection.getKeys(false)) {
                String actionValue = actionsSection.getString(actionKey);
                if (actionValue == null || actionValue.equals("none")) continue;
                actions.put(actionKey, actionValue);
            }
        }
        GuiButton button = new GuiButton(buttonKey, actualSlot, material, true, condition, actions);
        layout.addButton(buttonKey, button);
        return true;
    }

    private boolean isValidSlot(int slot, String layoutType) {
        return slot >= this.getMinSlot(layoutType) && slot <= this.getMaxSlot(layoutType);
    }

    private int getMinSlot(String layoutType) {
        return "storage".equals(layoutType) ? 1 : 1;
    }

    private int getMaxSlot(String layoutType) {
        return "storage".equals(layoutType) ? 9 : 27;
    }

    private int calculateActualSlot(int slot, String layoutType) {
        if ("storage".equals(layoutType)) {
            return 44 + slot;
        }
        return slot - 1;
    }

    private boolean evaluateCondition(String condition) {
        switch (condition) {
            case "shop_integration": {
                return this.plugin.hasSellIntegration();
            }
            case "no_shop_integration": {
                return !this.plugin.hasSellIntegration();
            }
        }
        this.plugin.getLogger().warning("Unknown condition: " + condition);
        return true;
    }

    private Material parseMaterial(String materialName, String buttonKey) {
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning(String.format("Invalid material %s for button %s. Using STONE instead.", materialName, buttonKey));
            return Material.STONE;
        }
    }

    public GuiLayout getCurrentLayout() {
        return this.getCurrentStorageLayout();
    }

    public void reloadLayouts() {
        this.loadLayout();
    }

    @Generated
    public GuiLayout getCurrentStorageLayout() {
        return this.currentStorageLayout;
    }

    @Generated
    public GuiLayout getCurrentMainLayout() {
        return this.currentMainLayout;
    }
}

