/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerExpClaimEvent;
import github.nighter.smartspawner.hooks.rpg.AuraSkillsIntegration;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayoutConfig;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuHolder;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.sell.SpawnerSellManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerMenuAction
implements Listener {
    private static final Set<Material> SPAWNER_INFO_MATERIALS = Set.of(Material.PLAYER_HEAD, Material.SPAWNER, Material.ZOMBIE_HEAD, Material.SKELETON_SKULL, Material.WITHER_SKELETON_SKULL, Material.CREEPER_HEAD, Material.PIGLIN_HEAD, Material.DRAGON_HEAD);
    private final SmartSpawner plugin;
    private final SpawnerMenuUI spawnerMenuUI;
    private final SpawnerStackerUI spawnerStackerUI;
    private final SpawnerStorageUI spawnerStorageUI;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final SpawnerSellManager spawnerSellManager;
    private AuraSkillsIntegration auraSkills;
    private final Map<UUID, Long> lastInfoClickTime = new ConcurrentHashMap<UUID, Long>();

    public SpawnerMenuAction(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.spawnerStackerUI = plugin.getSpawnerStackerUI();
        this.spawnerStorageUI = plugin.getSpawnerStorageUI();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.spawnerSellManager = plugin.getSpawnerSellManager();
        this.auraSkills = plugin.getIntegrationManager().getAuraSkillsIntegration();
    }

    public void reload() {
        this.auraSkills = this.plugin.getIntegrationManager().getAuraSkillsIntegration();
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent event) {
        String clickType;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerMenuHolder)) {
            return;
        }
        SpawnerMenuHolder holder = (SpawnerMenuHolder)inventoryHolder;
        event.setCancelled(true);
        SpawnerData spawner = holder.getSpawnerData();
        if (!this.isSpawnerValid(spawner)) {
            player.closeInventory();
            return;
        }
        if (event.getClickedInventory() == null || !(event.getClickedInventory().getHolder(false) instanceof SpawnerMenuHolder)) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getRawSlot();
        if (this.handleLayoutAction(player, spawner, slot, clickType = this.getClickTypeString(event.getClick()))) {
            return;
        }
        Material itemType = clickedItem.getType();
        if (itemType == Material.CHEST) {
            this.handleStorageClick(player, spawner);
        } else if (SPAWNER_INFO_MATERIALS.contains(itemType)) {
            this.handleSpawnerInfoClick(player, spawner, event.getClick());
        } else if (itemType == Material.EXPERIENCE_BOTTLE) {
            this.handleExpBottleClick(player, spawner, false);
        }
    }

    private boolean handleLayoutAction(Player player, SpawnerData spawner, int slot, String clickType) {
        GuiLayoutConfig layoutConfig = this.plugin.getGuiLayoutConfig();
        GuiLayout layout = layoutConfig.getCurrentMainLayout();
        if (layout == null) {
            return false;
        }
        Optional<GuiButton> buttonOpt = layout.getButtonAtSlot(slot);
        if (buttonOpt.isEmpty()) {
            return false;
        }
        GuiButton button = buttonOpt.get();
        String action = button.getAction(clickType);
        if (action == null) {
            return false;
        }
        switch (action) {
            case "open_storage": {
                this.handleStorageClick(player, spawner);
                return true;
            }
            case "open_stacker": {
                if (this.isClickTooFrequent(player)) {
                    return true;
                }
                if (!player.hasPermission("smartspawner.stack")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return true;
                }
                this.spawnerStackerUI.openStackerGui(player, spawner);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                return true;
            }
            case "sell_and_exp": {
                if (this.isClickTooFrequent(player)) {
                    return true;
                }
                if (!this.plugin.hasSellIntegration() || !player.hasPermission("smartspawner.sellall")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return true;
                }
                this.handleExpBottleClick(player, spawner, true);
                this.handleSellAllItems(player, spawner);
                return true;
            }
            case "sell_all": {
                if (this.isClickTooFrequent(player)) {
                    return true;
                }
                if (!this.plugin.hasSellIntegration() || !player.hasPermission("smartspawner.sellall")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return true;
                }
                this.handleSellAllItems(player, spawner);
                return true;
            }
            case "collect_exp": {
                this.handleExpBottleClick(player, spawner, false);
                return true;
            }
        }
        return false;
    }

    private String getClickTypeString(ClickType clickType) {
        return switch (clickType) {
            case ClickType.LEFT -> "left_click";
            case ClickType.RIGHT -> "right_click";
            case ClickType.SHIFT_LEFT -> "shift_left_click";
            case ClickType.SHIFT_RIGHT -> "shift_right_click";
            default -> "left_click";
        };
    }

    public void handleStorageClick(Player player, SpawnerData spawner) {
        if (!this.plugin.getSpawnerStorageAction().canAccessStorageGUI(player.getUniqueId())) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        Inventory pageInventory = this.spawnerStorageUI.createInventory(spawner, title, 1, -1);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
        player.closeInventory();
        player.openInventory(pageInventory);
    }

    public void handleStorageClickBedrock(Player player, SpawnerData spawner) {
        if (!this.plugin.getSpawnerStorageAction().canAccessStorageGUI(player.getUniqueId())) {
            this.messageService.sendMessage(player, "action_in_progress");
            return;
        }
        String title = this.languageManager.getGuiTitle("gui_title_storage");
        Inventory pageInventory = this.spawnerStorageUI.createInventory(spawner, title, 1, -1);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
        player.openInventory(pageInventory);
    }

    private void handleSpawnerInfoClick(Player player, SpawnerData spawner, ClickType clickType) {
        boolean hasShopIntegration;
        if (this.isClickTooFrequent(player)) {
            return;
        }
        boolean bl = hasShopIntegration = this.plugin.hasSellIntegration() && player.hasPermission("smartspawner.sellall");
        if (hasShopIntegration) {
            if (clickType == ClickType.LEFT) {
                this.handleExpBottleClick(player, spawner, true);
                this.handleSellAllItems(player, spawner);
            } else if (clickType == ClickType.RIGHT) {
                if (!player.hasPermission("smartspawner.stack")) {
                    this.messageService.sendMessage(player, "no_permission");
                    return;
                }
                this.spawnerStackerUI.openStackerGui(player, spawner);
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        } else {
            if (!player.hasPermission("smartspawner.stack")) {
                this.messageService.sendMessage(player, "no_permission");
                return;
            }
            this.spawnerStackerUI.openStackerGui(player, spawner);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    private boolean isClickTooFrequent(Player player) {
        long now = System.currentTimeMillis();
        long last = this.lastInfoClickTime.getOrDefault(player.getUniqueId(), 0L);
        this.lastInfoClickTime.put(player.getUniqueId(), now);
        return now - last < 300L;
    }

    private boolean isSpawnerValid(SpawnerData spawner) {
        if (spawner == null) {
            return false;
        }
        SpawnerManager spawnerManager = this.plugin.getSpawnerManager();
        SpawnerData current = spawnerManager.getSpawnerById(spawner.getSpawnerId());
        return current != null && current == spawner;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.lastInfoClickTime.remove(event.getPlayer().getUniqueId());
    }

    private void handleSellAllItems(Player player, SpawnerData spawner) {
        if (!this.plugin.hasSellIntegration()) {
            return;
        }
        if (!player.hasPermission("smartspawner.sellall")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        this.spawnerSellManager.sellAllItems(player, spawner);
    }

    public void handleExpBottleClick(Player player, SpawnerData spawner, boolean isSell) {
        if (this.isClickTooFrequent(player) && !isSell) {
            return;
        }
        int exp = spawner.getSpawnerExp();
        if (exp <= 0 && !isSell) {
            this.messageService.sendMessage(player, "no_exp");
            return;
        }
        int initialExp = exp;
        int expUsedForMending = 0;
        if (this.plugin.getConfig().getBoolean("spawner_properties.default.allow_exp_mending")) {
            expUsedForMending = this.applyMendingFromExp(player, exp);
            exp -= expUsedForMending;
        }
        if (this.auraSkills != null) {
            this.giveAuraSkillsXp(player, spawner, initialExp);
        }
        if (exp > 0) {
            if (SpawnerExpClaimEvent.getHandlerList().getRegisteredListeners().length != 0) {
                SpawnerExpClaimEvent expClaimEvent = new SpawnerExpClaimEvent(player, spawner.getSpawnerLocation(), exp);
                Bukkit.getPluginManager().callEvent((Event)expClaimEvent);
                if (expClaimEvent.isCancelled()) {
                    return;
                }
                if (exp != expClaimEvent.getExpQuantity()) {
                    exp = expClaimEvent.getExpQuantity();
                }
            }
            player.giveExp(exp);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
        spawner.setSpawnerExp(0);
        this.plugin.getSpawnerManager().markSpawnerModified(spawner.getSpawnerId());
        if (this.isBedrockPlayer(player)) {
            if (this.plugin.getSpawnerMenuFormUI() != null) {
                this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, true);
        }
        this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
        if (spawner.getSpawnerExp() < spawner.getMaxStoredExp() && spawner.getIsAtCapacity().booleanValue()) {
            spawner.setIsAtCapacity(false);
        }
        this.sendExpCollectionMessage(player, initialExp, expUsedForMending);
    }

    private int applyMendingFromExp(Player player, int availableExp) {
        if (availableExp <= 0) {
            return 0;
        }
        int expUsed = 0;
        PlayerInventory inventory = player.getInventory();
        List<ItemStack> itemsToCheck = Arrays.asList(inventory.getItemInMainHand(), inventory.getItemInOffHand(), inventory.getHelmet(), inventory.getChestplate(), inventory.getLeggings(), inventory.getBoots());
        for (ItemStack item : itemsToCheck) {
            int damage;
            int durabilityToRepair;
            int expNeeded;
            Damageable damageable;
            ItemMeta itemMeta;
            if (availableExp <= 0) break;
            if (item == null || item.getType() == Material.AIR || !item.getEnchantments().containsKey(Enchantment.MENDING) || !((itemMeta = item.getItemMeta()) instanceof Damageable) || (damageable = (Damageable)itemMeta).getDamage() <= 0 || (expNeeded = ((durabilityToRepair = Math.min(damage = damageable.getDamage(), availableExp * 2)) + 1) / 2) <= 0) continue;
            int actualExpUsed = Math.min(expNeeded, availableExp);
            int actualRepair = actualExpUsed * 2;
            int newDamage = Math.max(0, damage - actualRepair);
            Damageable meta = (Damageable)item.getItemMeta();
            meta.setDamage(newDamage);
            item.setItemMeta((ItemMeta)meta);
            availableExp -= actualExpUsed;
            expUsed += actualExpUsed;
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 0.5f, 1.0f);
            player.spawnParticle(Particle.HAPPY_VILLAGER, player.getLocation().add(0.0, 1.0, 0.0), 5);
        }
        return expUsed;
    }

    private void sendExpCollectionMessage(Player player, int totalExp, int mendingExp) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        if (mendingExp > 0) {
            int remainingExp = totalExp - mendingExp;
            placeholders.put("exp_mending", this.languageManager.formatNumber(mendingExp));
            placeholders.put("exp", this.languageManager.formatNumber(remainingExp));
            this.messageService.sendMessage(player, "exp_collected_with_mending", placeholders);
        } else if (totalExp > 0) {
            placeholders.put("exp", this.plugin.getLanguageManager().formatNumber(totalExp));
            this.messageService.sendMessage(player, "exp_collected", placeholders);
        }
    }

    private void giveAuraSkillsXp(Player player, SpawnerData spawner, int totalExp) {
        try {
            if (this.auraSkills == null || !this.auraSkills.isEnabled()) {
                return;
            }
            EntityType entityType = spawner.getEntityType();
            if (entityType == null) {
                this.plugin.debug("Could not determine entity type for spawner at " + String.valueOf(spawner.getSpawnerLocation()));
                return;
            }
            this.auraSkills.giveSkillXp(player, entityType, totalExp);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error giving AuraSkills XP: " + e.getMessage());
            this.plugin.debug("AuraSkills integration error: " + e.toString());
        }
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }
}

