/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;

public class SpawnerMenuFormUI {
    private static final int TICKS_PER_SECOND = 20;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final Map<String, CachedForm> formCache = new HashMap<String, CachedForm>();
    private static final long CACHE_EXPIRY_TIME_MS = 30000L;
    private static final Map<String, ActionButtonInfo> ACTION_BUTTON_CONFIG = new HashMap<String, ActionButtonInfo>();

    public SpawnerMenuFormUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
    }

    public void clearCache() {
        this.formCache.clear();
    }

    public void invalidateSpawnerCache(String spawnerId) {
        this.formCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(spawnerId + "|"));
    }

    public void openSpawnerForm(Player player, SpawnerData spawner) {
        Map<String, String> placeholders = this.createPlaceholders(spawner);
        String title = spawner.getStackSize() > 1 ? this.languageManager.getGuiTitle("bedrock.main_gui.title_stacked_spawner", placeholders) : this.languageManager.getGuiTitle("bedrock.main_gui.title_single_spawner", placeholders);
        GuiLayout layout = this.plugin.getGuiLayoutConfig().getCurrentMainLayout();
        List<ButtonInfo> availableButtons = this.collectAvailableButtons(layout, player, placeholders);
        if (availableButtons.isEmpty()) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        String cacheKey = spawner.getSpawnerId() + "|" + spawner.getStackSize() + "|" + spawner.getSpawnerExp() + "|" + spawner.getVirtualInventory().getUsedSlots();
        CachedForm cachedForm = this.formCache.get(cacheKey);
        if (cachedForm != null && !cachedForm.isExpired() && cachedForm.buttons.equals(availableButtons)) {
            FloodgateApi.getInstance().getPlayer(player.getUniqueId()).sendForm((Form)cachedForm.form);
            return;
        }
        SimpleForm.Builder formBuilder = (SimpleForm.Builder)SimpleForm.builder().title(title);
        for (ButtonInfo buttonInfo : availableButtons) {
            formBuilder.button(buttonInfo.text, FormImage.Type.URL, buttonInfo.imageUrl);
        }
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)formBuilder.closedOrInvalidResultHandler(() -> {})).validResultHandler(response -> {
            int buttonId = response.clickedButtonId();
            if (buttonId < availableButtons.size()) {
                ButtonInfo buttonInfo = (ButtonInfo)availableButtons.get(buttonId);
                Scheduler.runTask(() -> {
                    switch (buttonInfo.action) {
                        case "open_storage": {
                            this.plugin.getSpawnerMenuAction().handleStorageClickBedrock(player, spawner);
                            break;
                        }
                        case "open_stacker": {
                            this.handleSpawnerInfo(player, spawner);
                            break;
                        }
                        case "sell_and_exp": {
                            this.handleSellInventory(player, spawner);
                            break;
                        }
                        case "sell_all": {
                            this.handleSellAll(player, spawner);
                            break;
                        }
                        case "collect_exp": {
                            this.handleExpCollection(player, spawner);
                            break;
                        }
                        case "view_info": {
                            this.openViewInfoForm(player, spawner);
                            break;
                        }
                        default: {
                            this.plugin.getLogger().warning("Unknown action in FormUI: " + buttonInfo.action);
                        }
                    }
                });
            }
        })).build();
        this.formCache.put(cacheKey, new CachedForm(form, availableButtons));
        FloodgateApi.getInstance().getPlayer(player.getUniqueId()).sendForm((Form)form);
    }

    private List<ButtonInfo> collectAvailableButtons(GuiLayout layout, Player player, Map<String, String> placeholders) {
        ActionButtonInfo viewInfoConfig;
        ArrayList<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
        HashSet<String> addedActions = new HashSet<String>();
        List<GuiButton> sortedButtons = layout.getAllButtons().values().stream().filter(GuiButton::isEnabled).sorted(Comparator.comparing(GuiButton::getSlot)).toList();
        for (GuiButton button : sortedButtons) {
            if (button.getCondition() != null && !this.evaluateCondition(button.getCondition())) continue;
            HashSet<String> buttonActions = new HashSet<String>(button.getActions().values());
            for (String action : buttonActions) {
                ActionButtonInfo actionConfig;
                if (addedActions.contains(action) || "none".equals(action) || !this.hasPermissionForAction(player, action) || (actionConfig = ACTION_BUTTON_CONFIG.get(action)) == null) continue;
                String text = this.languageManager.getGuiItemName(actionConfig.langKey, placeholders);
                buttons.add(new ButtonInfo(action, text, actionConfig.imageUrl));
                addedActions.add(action);
            }
        }
        if (!addedActions.contains("view_info") && (viewInfoConfig = ACTION_BUTTON_CONFIG.get("view_info")) != null) {
            String text = this.languageManager.getGuiItemName(viewInfoConfig.langKey, placeholders);
            buttons.add(new ButtonInfo("view_info", text, viewInfoConfig.imageUrl));
        }
        return buttons;
    }

    private boolean evaluateCondition(String condition) {
        switch (condition) {
            case "shop_integration": {
                return this.plugin.hasSellIntegration();
            }
            case "no_shop_integration": {
                return !this.plugin.hasSellIntegration();
            }
        }
        this.plugin.getLogger().warning("Unknown condition in FormUI: " + condition);
        return true;
    }

    private boolean hasPermissionForAction(Player player, String action) {
        switch (action) {
            case "open_storage": {
                return true;
            }
            case "open_stacker": {
                return player.hasPermission("smartspawner.stack");
            }
            case "sell_and_exp": 
            case "sell_all": {
                return this.plugin.hasSellIntegration() && player.hasPermission("smartspawner.sellall");
            }
            case "collect_exp": {
                return true;
            }
            case "view_info": {
                return true;
            }
        }
        return false;
    }

    private void handleSpawnerInfo(Player player, SpawnerData spawner) {
        if (!player.hasPermission("smartspawner.stack")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        this.plugin.getSpawnerStackerUI().openStackerGui(player, spawner);
    }

    private void handleSellInventory(Player player, SpawnerData spawner) {
        if (!this.plugin.hasSellIntegration() || !player.hasPermission("smartspawner.sellall")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        this.plugin.getSpawnerMenuAction().handleExpBottleClick(player, spawner, true);
        this.plugin.getSpawnerSellManager().sellAllItems(player, spawner);
    }

    private void handleSellAll(Player player, SpawnerData spawner) {
        if (!this.plugin.hasSellIntegration() || !player.hasPermission("smartspawner.sellall")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        this.plugin.getSpawnerSellManager().sellAllItems(player, spawner);
    }

    private void handleExpCollection(Player player, SpawnerData spawner) {
        this.plugin.getSpawnerMenuAction().handleExpBottleClick(player, spawner, false);
    }

    private void openViewInfoForm(Player player, SpawnerData spawner) {
        Map<String, String> placeholders = this.createPlaceholders(spawner);
        String title = this.languageManager.getGuiTitle("bedrock.main_gui.view_info_title", placeholders);
        String spawnerInfo = this.createSpawnerInfoContent(placeholders);
        String backButtonText = this.languageManager.getGuiItemName("bedrock.main_gui.button_names.back", placeholders);
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(title)).content(spawnerInfo).button(backButtonText).closedOrInvalidResultHandler(() -> {})).validResultHandler(response -> Scheduler.runTask(() -> this.openSpawnerForm(player, spawner)))).build();
        FloodgateApi.getInstance().getPlayer(player.getUniqueId()).sendForm((Form)form);
    }

    private Map<String, String> createPlaceholders(SpawnerData spawner) {
        String entityName = this.languageManager.getFormattedMobName(spawner.getEntityType());
        String entityNameSmallCaps = this.languageManager.getSmallCaps(entityName);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", entityNameSmallCaps);
        placeholders.put("entity", entityName);
        placeholders.put("amount", String.valueOf(spawner.getStackSize()));
        placeholders.put("entity_type", spawner.getEntityType().toString());
        placeholders.put("stack_size", String.valueOf(spawner.getStackSize()));
        placeholders.put("range", String.valueOf(spawner.getSpawnerRange()));
        long delaySeconds = spawner.getSpawnDelay() / 20L;
        placeholders.put("delay", String.valueOf(delaySeconds));
        placeholders.put("delay_raw", String.valueOf(spawner.getSpawnDelay()));
        placeholders.put("min_mobs", String.valueOf(spawner.getMinMobs()));
        placeholders.put("max_mobs", String.valueOf(spawner.getMaxMobs()));
        VirtualInventory virtualInventory = spawner.getVirtualInventory();
        int currentItems = virtualInventory.getUsedSlots();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        double percentStorageDecimal = maxSlots > 0 ? (double)currentItems / (double)maxSlots * 100.0 : 0.0;
        String formattedPercentStorage = String.format("%.1f", percentStorageDecimal);
        int percentStorageRounded = (int)Math.round(percentStorageDecimal);
        placeholders.put("current_items", String.valueOf(currentItems));
        placeholders.put("max_items", this.languageManager.formatNumber(maxSlots));
        placeholders.put("percent_storage_decimal", formattedPercentStorage);
        placeholders.put("percent_storage_rounded", String.valueOf(percentStorageRounded));
        long currentExp = spawner.getSpawnerExp().intValue();
        long maxExp = spawner.getMaxStoredExp();
        double percentExpDecimal = maxExp > 0L ? (double)currentExp / (double)maxExp * 100.0 : 0.0;
        String formattedPercentExp = String.format("%.1f", percentExpDecimal);
        int percentExpRounded = (int)Math.round(percentExpDecimal);
        String formattedCurrentExp = this.languageManager.formatNumber(currentExp);
        String formattedMaxExp = this.languageManager.formatNumber(maxExp);
        placeholders.put("current_exp", formattedCurrentExp);
        placeholders.put("max_exp", formattedMaxExp);
        placeholders.put("raw_current_exp", String.valueOf(currentExp));
        placeholders.put("raw_max_exp", String.valueOf(maxExp));
        placeholders.put("percent_exp_decimal", formattedPercentExp);
        placeholders.put("percent_exp_rounded", String.valueOf(percentExpRounded));
        if (spawner.isSellValueDirty()) {
            spawner.recalculateSellValue();
        }
        double totalSellPrice = spawner.getAccumulatedSellValue();
        placeholders.put("total_sell_price", this.languageManager.formatNumber(totalSellPrice));
        return placeholders;
    }

    private String createSpawnerInfoContent(Map<String, String> placeholders) {
        List<String> infoLines = this.languageManager.getGuiItemLoreAsList("bedrock.main_gui.spawner_info", placeholders);
        if (infoLines == null || infoLines.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (String line : infoLines) {
            String bedrockLine = this.convertToBedrockColors(line);
            content.append(bedrockLine).append("\n");
        }
        if (content.length() > 0) {
            content.setLength(content.length() - 1);
        }
        return content.toString();
    }

    private String convertToBedrockColors(String text) {
        if (text == null) {
            return "";
        }
        String result = text;
        result = result.replaceAll("&#([A-Fa-f0-9]{6})", "");
        result = this.mapHexToBedrockColors(result, text);
        result = result.replace("&0", "\u00a70");
        result = result.replace("&1", "\u00a71");
        result = result.replace("&2", "\u00a72");
        result = result.replace("&3", "\u00a73");
        result = result.replace("&4", "\u00a74");
        result = result.replace("&5", "\u00a75");
        result = result.replace("&6", "\u00a76");
        result = result.replace("&7", "\u00a77");
        result = result.replace("&8", "\u00a78");
        result = result.replace("&9", "\u00a79");
        result = result.replace("&a", "\u00a7a");
        result = result.replace("&b", "\u00a7b");
        result = result.replace("&c", "\u00a7c");
        result = result.replace("&d", "\u00a7d");
        result = result.replace("&e", "\u00a7e");
        result = result.replace("&f", "\u00a7f");
        result = result.replace("&g", "\u00a7g");
        return result;
    }

    private String mapHexToBedrockColors(String result, String original) {
        HashMap<String, String> colorMap = new HashMap<String, String>();
        colorMap.put("545454", "\u00a78");
        colorMap.put("bdc3c7", "\u00a77");
        colorMap.put("ecf0f1", "\u00a7f");
        colorMap.put("f8f8ff", "\u00a7f");
        colorMap.put("3498db", "\u00a79");
        colorMap.put("2ecc71", "\u00a7a");
        colorMap.put("37eb9a", "\u00a7a");
        colorMap.put("2cc483", "\u00a7a");
        colorMap.put("48e89b", "\u00a7a");
        colorMap.put("00F986", "\u00a7a");
        colorMap.put("e67e22", "\u00a76");
        colorMap.put("ff5252", "\u00a7c");
        colorMap.put("e63939", "\u00a74");
        colorMap.put("ff7070", "\u00a7c");
        colorMap.put("d8c5ff", "\u00a7d");
        colorMap.put("7b68ee", "\u00a75");
        colorMap.put("a885fc", "\u00a7d");
        colorMap.put("c2a8fc", "\u00a7d");
        colorMap.put("ab7afd", "\u00a7d");
        colorMap.put("EF6C00", "\u00a76");
        colorMap.put("607D8B", "\u00a78");
        for (Map.Entry entry : colorMap.entrySet()) {
            result = result.replace("&#" + (String)entry.getKey(), (CharSequence)entry.getValue());
            result = result.replace("&#" + ((String)entry.getKey()).toLowerCase(), (CharSequence)entry.getValue());
        }
        return result;
    }

    static {
        ACTION_BUTTON_CONFIG.put("open_storage", new ActionButtonInfo("bedrock.main_gui.button_names.storage", "https://i.pinimg.com/736x/7a/28/50/7a28504d8446ab0ad670757cfa32fe59.jpg"));
        ACTION_BUTTON_CONFIG.put("open_stacker", new ActionButtonInfo("bedrock.main_gui.button_names.stacker", "https://cdn.modrinth.com/data/9tQwxSFr/f0f1cc267f587a39acd2c820cfe6b29d0f2ccae3.png"));
        ACTION_BUTTON_CONFIG.put("sell_and_exp", new ActionButtonInfo("bedrock.main_gui.button_names.sell_and_exp", "https://static.wikia.nocookie.net/minecraft_gamepedia/images/8/8a/Gold_Ingot_JE4_BE2.png/revision/latest?cb=20200224211607"));
        ACTION_BUTTON_CONFIG.put("sell_all", new ActionButtonInfo("bedrock.main_gui.button_names.sell_all", "https://static.wikia.nocookie.net/minecraft_gamepedia/images/8/8a/Gold_Ingot_JE4_BE2.png/revision/latest?cb=20200224211607"));
        ACTION_BUTTON_CONFIG.put("collect_exp", new ActionButtonInfo("bedrock.main_gui.button_names.exp", "https://minecraft.wiki/images/Bottle_o%27_Enchanting.gif"));
        ACTION_BUTTON_CONFIG.put("view_info", new ActionButtonInfo("bedrock.main_gui.button_names.view_info", "https://static.wikia.nocookie.net/minecraft_gamepedia/images/9/9f/Information_sign.png/revision/latest/scale-to-width-down/268?cb=20200105100749"));
    }

    private static class CachedForm {
        final SimpleForm form;
        final List<ButtonInfo> buttons;
        final long timestamp;

        CachedForm(SimpleForm form, List<ButtonInfo> buttons) {
            this.form = form;
            this.buttons = buttons;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 30000L;
        }
    }

    private static class ButtonInfo {
        final String action;
        final String text;
        final String imageUrl;

        ButtonInfo(String action, String text, String imageUrl) {
            this.action = action;
            this.text = text;
            this.imageUrl = imageUrl;
        }
    }

    private static class ActionButtonInfo {
        final String langKey;
        final String imageUrl;

        ActionButtonInfo(String langKey, String imageUrl) {
            this.langKey = langKey;
            this.imageUrl = imageUrl;
        }
    }
}

