/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.storage;

import github.nighter.smartspawner.spawner.gui.SpawnerHolder;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class StoragePageHolder
implements InventoryHolder,
SpawnerHolder {
    private final SpawnerData spawnerData;
    private int currentPage;
    private int totalPages;
    private int oldUsedSlots;
    public static final int ROWS_PER_PAGE = 5;
    public static final int SLOTS_PER_PAGE = 45;
    public static final int MAX_ITEMS_PER_PAGE = 45;
    private Inventory inventory;

    public StoragePageHolder(SpawnerData spawnerData, int currentPage, int totalPages) {
        this.spawnerData = spawnerData;
        this.currentPage = Math.max(1, Math.min(currentPage, totalPages));
        this.totalPages = Math.max(1, totalPages);
        this.oldUsedSlots = spawnerData.getVirtualInventory().getUsedSlots();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public SpawnerData getSpawnerData() {
        return this.spawnerData;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        this.currentPage = Math.max(1, Math.min(page, this.totalPages));
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = Math.max(1, totalPages);
    }

    public int getOldUsedSlots() {
        return this.oldUsedSlots;
    }

    public void updateOldUsedSlots() {
        this.oldUsedSlots = this.spawnerData.getVirtualInventory().getUsedSlots();
    }

    public boolean hasNextPage() {
        return this.currentPage < this.totalPages;
    }

    public boolean hasPreviousPage() {
        return this.currentPage > 1;
    }

    public int getSlotIndex(int itemIndex) {
        return itemIndex % 45;
    }

    public int getItemIndex(int slotIndex) {
        return (this.currentPage - 1) * 45 + slotIndex;
    }
}

