/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.gui.storage.filter.FilterConfigHolder;
import github.nighter.smartspawner.spawner.gui.synchronization.listeners.InventoryEventListener;
import github.nighter.smartspawner.spawner.gui.synchronization.listeners.PlayerEventListener;
import github.nighter.smartspawner.spawner.gui.synchronization.managers.SlotCacheManager;
import github.nighter.smartspawner.spawner.gui.synchronization.managers.UpdateTaskManager;
import github.nighter.smartspawner.spawner.gui.synchronization.managers.ViewerTrackingManager;
import github.nighter.smartspawner.spawner.gui.synchronization.services.GuiUpdateService;
import github.nighter.smartspawner.spawner.gui.synchronization.services.StorageUpdateService;
import github.nighter.smartspawner.spawner.gui.synchronization.services.TimerUpdateService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class SpawnerGuiViewManager {
    private final SmartSpawner plugin;
    private final ViewerTrackingManager viewerTrackingManager;
    private final SlotCacheManager slotCacheManager;
    private final UpdateTaskManager updateTaskManager;
    private final TimerUpdateService timerUpdateService;
    private final GuiUpdateService guiUpdateService;
    private final StorageUpdateService storageUpdateService;
    private final InventoryEventListener inventoryEventListener;
    private final PlayerEventListener playerEventListener;

    public SpawnerGuiViewManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.viewerTrackingManager = new ViewerTrackingManager();
        this.slotCacheManager = new SlotCacheManager(plugin);
        this.updateTaskManager = new UpdateTaskManager();
        this.timerUpdateService = new TimerUpdateService(plugin, this.viewerTrackingManager, this.slotCacheManager);
        this.guiUpdateService = new GuiUpdateService(plugin, this.slotCacheManager);
        this.storageUpdateService = new StorageUpdateService(plugin);
        this.inventoryEventListener = new InventoryEventListener(this.viewerTrackingManager, this::onViewerAdded);
        this.playerEventListener = new PlayerEventListener(this.viewerTrackingManager);
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoryEventListener, (Plugin)plugin);
        Bukkit.getPluginManager().registerEvents((Listener)this.playerEventListener, (Plugin)plugin);
    }

    private void onViewerAdded() {
        if (!this.updateTaskManager.isRunning() && this.viewerTrackingManager.hasAnyViewers()) {
            this.updateTaskManager.startTask(this::processPeriodicUpdates);
        }
    }

    private void processPeriodicUpdates() {
        this.guiUpdateService.processPendingUpdates(this.viewerTrackingManager::getViewerInfo, this::cleanupViewer);
        if (this.timerUpdateService.shouldProcessTimerUpdates()) {
            this.timerUpdateService.processTimerUpdates();
        }
        if (!this.viewerTrackingManager.hasAnyViewers()) {
            this.updateTaskManager.stopTask();
        }
    }

    private void cleanupViewer(UUID playerId) {
        this.viewerTrackingManager.untrackViewer(playerId);
        this.guiUpdateService.clearPlayerUpdates(playerId);
        this.timerUpdateService.clearPlayerTracking(playerId);
    }

    public boolean isTimerPlaceholdersEnabled() {
        return this.timerUpdateService.isTimerPlaceholdersEnabled();
    }

    public String calculateTimerDisplay(SpawnerData spawner) {
        return this.timerUpdateService.calculateTimerDisplay(spawner, null);
    }

    public String calculateTimerDisplay(SpawnerData spawner, Player player) {
        return this.timerUpdateService.calculateTimerDisplay(spawner, player);
    }

    public void recheckTimerPlaceholders() {
        this.timerUpdateService.recheckTimerPlaceholders();
    }

    public void clearSlotCache() {
        this.slotCacheManager.clearAndReinitialize();
    }

    public Set<Player> getViewers(String spawnerId) {
        return this.viewerTrackingManager.getViewers(spawnerId);
    }

    public boolean hasViewers(SpawnerData spawner) {
        return this.viewerTrackingManager.hasViewers(spawner);
    }

    public void clearAllTrackedGuis() {
        this.viewerTrackingManager.clearAll();
        this.guiUpdateService.clearAllPendingUpdates();
        this.timerUpdateService.clearAllTracking();
    }

    public void forceStateChangeUpdate(SpawnerData spawner) {
        this.timerUpdateService.forceStateChangeUpdate(spawner);
    }

    public void forceTimerUpdateInactive(Player player, SpawnerData spawner) {
        this.timerUpdateService.forceTimerUpdateInactive(player, spawner);
    }

    public void updateSpawnerMenuViewers(SpawnerData spawner) {
        int viewerCount;
        Set<UUID> viewers = this.viewerTrackingManager.getViewerIds(spawner.getSpawnerId());
        if (viewers == null || viewers.isEmpty()) {
            return;
        }
        if (this.plugin.getSpawnerMenuUI() != null) {
            this.plugin.getSpawnerMenuUI().invalidateSpawnerCache(spawner.getSpawnerId());
        }
        if (this.plugin.getSpawnerMenuFormUI() != null) {
            this.plugin.getSpawnerMenuFormUI().invalidateSpawnerCache(spawner.getSpawnerId());
        }
        if ((viewerCount = viewers.size()) > 10) {
            this.plugin.debug(viewerCount + " spawner menu viewers to update for " + spawner.getSpawnerId() + " (batch update)");
        }
        for (UUID viewerId : viewers) {
            Location loc;
            Player viewer = Bukkit.getPlayer((UUID)viewerId);
            if (viewer == null || !viewer.isOnline()) {
                this.cleanupViewer(viewerId);
                continue;
            }
            this.guiUpdateService.scheduleUpdate(viewerId, 7);
            Inventory openInv = viewer.getOpenInventory().getTopInventory();
            if (openInv == null || !(openInv.getHolder(false) instanceof StoragePageHolder) || (loc = viewer.getLocation()) == null) continue;
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline()) {
                    return;
                }
                Inventory inv = viewer.getOpenInventory().getTopInventory();
                if (inv != null && inv.getHolder(false) instanceof StoragePageHolder) {
                    StoragePageHolder holder = (StoragePageHolder)inv.getHolder(false);
                    int oldPages = this.storageUpdateService.calculateTotalPages(holder.getOldUsedSlots());
                    int newPages = this.storageUpdateService.calculateTotalPages(spawner.getVirtualInventory().getUsedSlots());
                    this.storageUpdateService.processStorageUpdateDirect(viewer, inv, spawner, holder, oldPages, newPages);
                }
            });
        }
    }

    public void updateSpawnerMenuGui(Player player, SpawnerData spawner, boolean forceUpdate) {
        this.guiUpdateService.scheduleUpdate(player.getUniqueId(), 7);
    }

    public void closeAllViewersInventory(SpawnerData spawner) {
        Set<UUID> filterViewers;
        String spawnerId = spawner.getSpawnerId();
        Set<Player> viewers = this.getViewers(spawnerId);
        if (!viewers.isEmpty()) {
            for (Player viewer : viewers) {
                if (viewer == null || !viewer.isOnline()) continue;
                viewer.closeInventory();
            }
        }
        if ((filterViewers = this.viewerTrackingManager.getFilterViewersForSpawner(spawnerId)) != null && !filterViewers.isEmpty()) {
            HashSet<UUID> filterViewersCopy = new HashSet<UUID>(filterViewers);
            for (UUID viewerId : filterViewersCopy) {
                FilterConfigHolder filterHolder;
                InventoryHolder inventoryHolder;
                Inventory openInventory;
                Player viewer = Bukkit.getPlayer((UUID)viewerId);
                if (viewer == null || !viewer.isOnline() || (openInventory = viewer.getOpenInventory().getTopInventory()) == null || !((inventoryHolder = openInventory.getHolder(false)) instanceof FilterConfigHolder) || !(filterHolder = (FilterConfigHolder)inventoryHolder).getSpawnerData().getSpawnerId().equals(spawnerId)) continue;
                viewer.closeInventory();
            }
        }
        if (this.plugin.getSpawnerStackerHandler() != null) {
            this.plugin.getSpawnerStackerHandler().closeAllViewersInventory(spawnerId);
        }
    }

    public void cleanup() {
        this.updateTaskManager.stopTask();
        this.clearAllTrackedGuis();
        HandlerList.unregisterAll((Listener)this.inventoryEventListener);
        HandlerList.unregisterAll((Listener)this.playerEventListener);
    }
}

