/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization.managers;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;

public class SlotCacheManager {
    private final SmartSpawner plugin;
    private volatile int cachedStorageSlot = -1;
    private volatile int cachedExpSlot = -1;
    private volatile int cachedSpawnerInfoSlot = -1;

    public SlotCacheManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.initializeSlotPositions();
    }

    public void initializeSlotPositions() {
        GuiLayout layout = this.plugin.getGuiLayoutConfig().getCurrentMainLayout();
        if (layout == null) {
            this.cachedStorageSlot = -1;
            this.cachedExpSlot = -1;
            this.cachedSpawnerInfoSlot = -1;
            return;
        }
        GuiButton storageButton = layout.getButton("storage");
        this.cachedStorageSlot = storageButton != null ? storageButton.getSlot() : -1;
        GuiButton expButton = layout.getButton("exp");
        this.cachedExpSlot = expButton != null ? expButton.getSlot() : -1;
        GuiButton spawnerInfoButton = null;
        if (this.plugin.hasSellIntegration()) {
            spawnerInfoButton = layout.getButton("spawner_info_with_shop");
        }
        if (spawnerInfoButton == null) {
            spawnerInfoButton = layout.getButton("spawner_info_no_shop");
        }
        if (spawnerInfoButton == null) {
            spawnerInfoButton = layout.getButton("spawner_info");
        }
        this.cachedSpawnerInfoSlot = spawnerInfoButton != null ? spawnerInfoButton.getSlot() : -1;
    }

    public int getStorageSlot() {
        return this.cachedStorageSlot;
    }

    public int getExpSlot() {
        return this.cachedExpSlot;
    }

    public int getSpawnerInfoSlot() {
        return this.cachedSpawnerInfoSlot;
    }

    public void clearAndReinitialize() {
        this.initializeSlotPositions();
    }
}

