/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization.services;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.storage.StoragePageHolder;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class StorageUpdateService {
    private static final int ITEMS_PER_PAGE = 45;
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final SpawnerStorageUI spawnerStorageUI;
    private String cachedStorageTitleFormat = null;

    public StorageUpdateService(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.spawnerStorageUI = plugin.getSpawnerStorageUI();
        this.initializeCache();
    }

    private void initializeCache() {
        this.cachedStorageTitleFormat = this.languageManager.getGuiTitle("gui_title_storage");
    }

    public void reloadCache() {
        this.cachedStorageTitleFormat = null;
        this.initializeCache();
    }

    public void processStorageUpdate(Player viewer, SpawnerData spawner, int oldTotalPages, int newTotalPages) {
        Location loc = viewer.getLocation();
        if (loc != null) {
            Scheduler.runLocationTask(loc, () -> {
                if (!viewer.isOnline()) {
                    return;
                }
                Inventory openInv = viewer.getOpenInventory().getTopInventory();
                if (openInv == null || !(openInv.getHolder(false) instanceof StoragePageHolder)) {
                    return;
                }
                StoragePageHolder holder = (StoragePageHolder)openInv.getHolder(false);
                this.processStorageUpdateDirect(viewer, openInv, spawner, holder, oldTotalPages, newTotalPages);
            });
        }
    }

    public void processStorageUpdateDirect(Player viewer, Inventory inventory, SpawnerData spawner, StoragePageHolder holder, int oldTotalPages, int newTotalPages) {
        boolean pagesChanged;
        int currentPage = holder.getCurrentPage();
        boolean bl = pagesChanged = oldTotalPages != newTotalPages;
        if (!pagesChanged) {
            this.spawnerStorageUI.updateDisplay(inventory, spawner, currentPage, newTotalPages);
            holder.updateOldUsedSlots();
            viewer.updateInventory();
            return;
        }
        boolean needsNewInventory = false;
        int targetPage = currentPage;
        if (currentPage > newTotalPages) {
            targetPage = newTotalPages;
            holder.setCurrentPage(targetPage);
            needsNewInventory = true;
        } else {
            needsNewInventory = true;
        }
        if (needsNewInventory) {
            try {
                holder.setTotalPages(newTotalPages);
                holder.updateOldUsedSlots();
                String newTitle = this.getStorageTitle(targetPage, newTotalPages);
                viewer.getOpenInventory().setTitle(newTitle);
                this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            }
            catch (Exception e) {
                Inventory newInv = this.spawnerStorageUI.createInventory(spawner, this.languageManager.getGuiTitle("gui_title_storage"), targetPage, newTotalPages);
                viewer.closeInventory();
                viewer.openInventory(newInv);
            }
        } else {
            this.spawnerStorageUI.updateDisplay(inventory, spawner, targetPage, newTotalPages);
            viewer.updateInventory();
        }
    }

    public int calculateTotalPages(int totalItems) {
        return totalItems <= 0 ? 1 : (int)Math.ceil((double)totalItems / 45.0);
    }

    private String getStorageTitle(int page, int totalPages) {
        if (this.cachedStorageTitleFormat == null) {
            this.cachedStorageTitleFormat = this.languageManager.getGuiTitle("gui_title_storage");
        }
        if (!this.cachedStorageTitleFormat.contains("{current_page}") && !this.cachedStorageTitleFormat.contains("{total_pages}")) {
            return this.cachedStorageTitleFormat;
        }
        return this.languageManager.getGuiTitle("gui_title_storage", Map.of("current_page", String.valueOf(page), "total_pages", String.valueOf(totalPages)));
    }
}

