/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.synchronization.utils;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public final class LootPreGenerationHelper {
    private static final long PRE_GENERATION_THRESHOLD = 2000L;
    private static final long EARLY_SPAWN_THRESHOLD = 1000L;
    private final SmartSpawner plugin;

    public LootPreGenerationHelper(SmartSpawner plugin) {
        this.plugin = plugin;
    }

    public boolean shouldPreGenerateLoot(long timeUntilNextSpawn) {
        return timeUntilNextSpawn > 0L && timeUntilNextSpawn <= 2000L;
    }

    public boolean shouldAddLootEarly(long timeUntilNextSpawn) {
        return timeUntilNextSpawn > 0L && timeUntilNextSpawn <= 1000L;
    }

    public void preGenerateLoot(SpawnerData spawner) {
        if (spawner.isPreGenerating() || spawner.hasPreGeneratedLoot()) {
            return;
        }
        if (!spawner.getSpawnerActive().booleanValue() || spawner.getSpawnerStop().get()) {
            return;
        }
        spawner.setPreGenerating(true);
        Location spawnerLocation = spawner.getSpawnerLocation();
        if (spawnerLocation != null) {
            Scheduler.runLocationTask(spawnerLocation, () -> {
                if (!spawner.getSpawnerActive().booleanValue() || spawner.getSpawnerStop().get()) {
                    spawner.setPreGenerating(false);
                    return;
                }
                this.plugin.getSpawnerLootGenerator().preGenerateLoot(spawner, (items, experience) -> {
                    spawner.storePreGeneratedLoot(items, experience);
                    spawner.setPreGenerating(false);
                });
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreGeneratedLootEarly(SpawnerData spawner, long cachedDelay) {
        block10: {
            if (!spawner.hasPreGeneratedLoot()) {
                return;
            }
            try {
                if (!spawner.getDataLock().tryLock(100L, TimeUnit.MILLISECONDS)) break block10;
                try {
                    long currentTime = System.currentTimeMillis();
                    long lastSpawnTime = spawner.getLastSpawnTime();
                    long timeElapsed = currentTime - lastSpawnTime;
                    long remainingTime = cachedDelay - timeElapsed;
                    if (remainingTime > 0L && remainingTime <= 1000L) {
                        if (!spawner.getSpawnerActive().booleanValue() || spawner.getSpawnerStop().get()) {
                            spawner.clearPreGeneratedLoot();
                            return;
                        }
                        Location spawnerLocation = spawner.getSpawnerLocation();
                        if (spawnerLocation != null) {
                            long scheduledSpawnTime = lastSpawnTime + cachedDelay;
                            Scheduler.runLocationTask(spawnerLocation, () -> {
                                if (!spawner.getSpawnerActive().booleanValue() || spawner.getSpawnerStop().get()) {
                                    spawner.clearPreGeneratedLoot();
                                    return;
                                }
                                if (spawner.hasPreGeneratedLoot()) {
                                    List<ItemStack> items = spawner.getAndClearPreGeneratedItems();
                                    int exp = spawner.getAndClearPreGeneratedExperience();
                                    this.plugin.getSpawnerLootGenerator().addPreGeneratedLoot(spawner, items, exp, scheduledSpawnTime);
                                }
                            });
                        }
                    }
                }
                finally {
                    spawner.getDataLock().unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

