/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.interactions.destroy;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerPlayerBreakEvent;
import github.nighter.smartspawner.extras.HopperHandler;
import github.nighter.smartspawner.hooks.protections.CheckBreakBlock;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.data.SpawnerFileHandler;
import github.nighter.smartspawner.spawner.data.SpawnerManager;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.spawner.limits.ChunkSpawnerLimiter;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerBreakListener
implements Listener {
    private static final int MAX_STACK_SIZE = 64;
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final HopperHandler hopperHandler;
    private final SpawnerItemFactory spawnerItemFactory;
    private final SpawnerFileHandler spawnerFileHandler;
    private ChunkSpawnerLimiter chunkSpawnerLimiter;

    public SpawnerBreakListener(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.hopperHandler = plugin.getHopperHandler();
        this.spawnerItemFactory = plugin.getSpawnerItemFactory();
        this.spawnerFileHandler = plugin.getSpawnerFileHandler();
        this.chunkSpawnerLimiter = plugin.getChunkSpawnerLimiter();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpawnerBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        if (!CheckBreakBlock.CanPlayerBreakBlock(player, location)) {
            event.setCancelled(true);
            return;
        }
        if (!this.plugin.getConfig().getBoolean("spawner_break.enabled", true)) {
            event.setCancelled(true);
            return;
        }
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(location);
        if (!this.plugin.getConfig().getBoolean("natural_spawner.breakable", false) && spawner == null) {
            block.setType(Material.AIR);
            event.setCancelled(true);
            this.messageService.sendMessage(player, "natural_spawner_break_blocked");
            return;
        }
        if (!player.hasPermission("smartspawner.break")) {
            event.setCancelled(true);
            this.messageService.sendMessage(player, "spawner_break_no_permission");
            return;
        }
        if (spawner != null) {
            this.handleSmartSpawnerBreak(block, spawner, player);
            this.plugin.getRangeChecker().deactivateSpawner(spawner);
        } else {
            CreatureSpawner creatureSpawner = (CreatureSpawner)block.getState(false);
            if (this.callAPIEvent(player, block.getLocation(), 1)) {
                event.setCancelled(true);
                return;
            }
            this.handleVanillaSpawnerBreak(block, creatureSpawner, player);
        }
        event.setCancelled(true);
        this.cleanupAssociatedHopper(block);
    }

    private void handleSmartSpawnerBreak(Block block, SpawnerData spawner, Player player) {
        Location location = block.getLocation();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.validateBreakConditions(player, tool, spawner)) {
            return;
        }
        spawner.updateLastInteractedPlayer(player.getName());
        this.plugin.getSpawnerGuiViewManager().closeAllViewersInventory(spawner);
        SpawnerBreakResult result = this.processDrops(player, location, spawner, player.isSneaking(), block);
        if (result.isSuccess() && player.getGameMode() != GameMode.CREATIVE) {
            this.reduceDurability(tool, player, result.getDurabilityLoss());
        }
    }

    private void handleVanillaSpawnerBreak(Block block, CreatureSpawner creatureSpawner, Player player) {
        Location location = block.getLocation();
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!this.validateBreakConditions(player, tool, null)) {
            return;
        }
        EntityType entityType = creatureSpawner.getSpawnedType();
        ItemStack spawnerItem = this.plugin.getConfig().getBoolean("natural_spawner.convert_to_smart_spawner", false) ? this.spawnerItemFactory.createSmartSpawnerItem(entityType) : this.spawnerItemFactory.createVanillaSpawnerItem(entityType);
        boolean directToInventory = this.plugin.getConfig().getBoolean("spawner_break.direct_to_inventory", false);
        World world = location.getWorld();
        if (world != null) {
            block.setType(Material.AIR);
            this.chunkSpawnerLimiter.unregisterSpawner(location, 1);
            if (directToInventory) {
                this.giveSpawnersToPlayer(player, 1, spawnerItem);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
            } else {
                world.dropItemNaturally(location.toCenterLocation(), spawnerItem);
            }
            this.reduceDurability(tool, player, this.plugin.getConfig().getInt("spawner_break.durability_loss", 1));
        }
    }

    private boolean validateBreakConditions(Player player, ItemStack tool, SpawnerData spawner) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        if (!player.hasPermission("smartspawner.break")) {
            this.messageService.sendMessage(player, "spawner_break_no_permission");
            return false;
        }
        if (!this.isValidTool(tool)) {
            this.messageService.sendMessage(player, "spawner_break_required_tools");
            return false;
        }
        if (this.plugin.getConfig().getBoolean("spawner_break.silk_touch.required", true)) {
            int requiredLevel = this.plugin.getConfig().getInt("spawner_break.silk_touch.level", 1);
            if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) < requiredLevel) {
                this.messageService.sendMessage(player, "spawner_break_silk_touch_required");
                return false;
            }
        }
        return true;
    }

    private SpawnerBreakResult processDrops(Player player, Location location, SpawnerData spawner, boolean isCrouching, Block spawnerBlock) {
        int dropAmount;
        ItemStack template;
        int currentStackSize = spawner.getStackSize();
        int durabilityLoss = this.plugin.getConfig().getInt("spawner_break.durability_loss", 1);
        World world = location.getWorld();
        if (world == null) {
            return new SpawnerBreakResult(false, 0, durabilityLoss);
        }
        if (spawner.isItemSpawner()) {
            template = this.spawnerItemFactory.createItemSpawnerItem(spawner.getSpawnedItemMaterial());
        } else {
            EntityType entityType = spawner.getEntityType();
            template = this.spawnerItemFactory.createSmartSpawnerItem(entityType);
        }
        boolean shouldDeleteSpawner = false;
        if (isCrouching) {
            if (currentStackSize <= 64) {
                dropAmount = currentStackSize;
                if (this.callAPIEvent(player, location, dropAmount)) {
                    return new SpawnerBreakResult(false, dropAmount, 0);
                }
                this.chunkSpawnerLimiter.unregisterSpawner(location, currentStackSize);
            } else {
                dropAmount = 64;
                if (this.callAPIEvent(player, location, dropAmount)) {
                    return new SpawnerBreakResult(false, dropAmount, 0);
                }
                this.chunkSpawnerLimiter.unregisterSpawner(location, 64);
                spawner.setStackSize(currentStackSize - 64);
            }
        } else {
            dropAmount = 1;
            if (this.callAPIEvent(player, location, dropAmount)) {
                return new SpawnerBreakResult(false, dropAmount, 0);
            }
            this.chunkSpawnerLimiter.unregisterSpawner(location, 1);
            if (currentStackSize <= 1) {
                shouldDeleteSpawner = true;
            } else {
                spawner.setStackSize(currentStackSize - 1);
            }
        }
        if (dropAmount == currentStackSize || shouldDeleteSpawner) {
            this.cleanupSpawner(spawnerBlock, spawner);
        } else {
            this.spawnerManager.markSpawnerModified(spawner.getSpawnerId());
        }
        boolean directToInventory = this.plugin.getConfig().getBoolean("spawner_break.direct_to_inventory", false);
        if (directToInventory) {
            this.giveSpawnersToPlayer(player, dropAmount, template);
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
        } else {
            template.setAmount(dropAmount);
            world.dropItemNaturally(location.toCenterLocation(), template.clone());
        }
        return new SpawnerBreakResult(true, dropAmount, durabilityLoss);
    }

    private boolean callAPIEvent(Player player, Location location, int dropAmount) {
        if (SpawnerPlayerBreakEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerPlayerBreakEvent e = new SpawnerPlayerBreakEvent(player, location, dropAmount);
            Bukkit.getPluginManager().callEvent((Event)e);
            return e.isCancelled();
        }
        return false;
    }

    private void reduceDurability(ItemStack tool, Player player, int durabilityLoss) {
        if (tool.getType().getMaxDurability() == 0) {
            return;
        }
        ItemMeta meta = tool.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            int currentDurability = damageable.getDamage();
            int newDurability = currentDurability + durabilityLoss;
            if (newDurability >= tool.getType().getMaxDurability()) {
                player.getInventory().setItemInMainHand(null);
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            } else {
                damageable.setDamage(newDurability);
                tool.setItemMeta(meta);
            }
        }
    }

    private void cleanupSpawner(Block block, SpawnerData spawner) {
        spawner.getSpawnerStop().set(true);
        block.setType(Material.AIR);
        String spawnerId = spawner.getSpawnerId();
        this.spawnerManager.removeSpawner(spawnerId);
        this.spawnerFileHandler.markSpawnerDeleted(spawnerId);
    }

    private void cleanupAssociatedHopper(Block block) {
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        if (blockBelow.getType() == Material.HOPPER && this.hopperHandler != null) {
            this.hopperHandler.stopHopperTask(blockBelow.getLocation());
        }
    }

    private boolean isValidTool(ItemStack tool) {
        if (tool == null) {
            return false;
        }
        return this.plugin.getConfig().getStringList("spawner_break.required_tools").contains(tool.getType().name());
    }

    private void giveSpawnersToPlayer(Player player, int amount, ItemStack template) {
        int MAX_STACK_SIZE = 64;
        ItemStack itemToGive = template.clone();
        itemToGive.setAmount(Math.min(amount, 64));
        HashMap failedItems = player.getInventory().addItem(new ItemStack[]{itemToGive});
        if (!failedItems.isEmpty()) {
            for (ItemStack failedItem : failedItems.values()) {
                player.getWorld().dropItemNaturally(player.getLocation().toCenterLocation(), failedItem);
            }
            this.messageService.sendMessage(player, "inventory_full_items_dropped");
        }
        player.updateInventory();
    }

    @EventHandler
    public void onSpawnerDamage(BlockDamageEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool.getType() == Material.AIR) {
            return;
        }
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(block.getLocation());
        if (spawner != null) {
            this.messageService.sendMessage(player, "spawner_break_warning");
        }
        if (this.isValidTool(tool)) {
            if (this.plugin.getConfig().getBoolean("spawner_break.silk_touch.required", true)) {
                int requiredLevel = this.plugin.getConfig().getInt("spawner_break.silk_touch.level", 1);
                if (tool.getEnchantmentLevel(Enchantment.SILK_TOUCH) < requiredLevel) {
                    this.messageService.sendMessage(player, "spawner_break_silk_touch_required");
                    return;
                }
            }
            if (!player.hasPermission("smartspawner.break")) {
                this.messageService.sendMessage(player, "spawner_break_no_permission");
            }
        } else {
            this.messageService.sendMessage(player, "spawner_break_required_tools");
        }
    }

    private static class SpawnerBreakResult {
        private final boolean success;
        private final int droppedAmount;
        private final int baseDurabilityLoss;

        public SpawnerBreakResult(boolean success, int droppedAmount, int baseDurabilityLoss) {
            this.success = success;
            this.droppedAmount = droppedAmount;
            this.baseDurabilityLoss = baseDurabilityLoss;
        }

        public int getDurabilityLoss() {
            return this.droppedAmount * this.baseDurabilityLoss;
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }
    }
}

