/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.updates;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.updates.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    private final String currentVersion;
    private final SmartSpawner plugin;
    private static final String CONFIG_VERSION_KEY = "config_version";

    public ConfigUpdater(SmartSpawner plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkAndUpdateConfig() {
        Version pluginVersion;
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.createDefaultConfigWithHeader(configFile);
            return;
        }
        YamlConfiguration currentConfig = YamlConfiguration.loadConfiguration((File)configFile);
        String configVersionStr = currentConfig.getString(CONFIG_VERSION_KEY, "0.0.0");
        Version configVersion = new Version(configVersionStr);
        if (configVersion.compareTo(pluginVersion = new Version(this.currentVersion)) >= 0) {
            return;
        }
        this.plugin.getLogger().info("Updating config from version " + configVersionStr + " to " + this.currentVersion);
        try {
            Map<String, Object> userValues = this.flattenConfig((ConfigurationSection)currentConfig);
            File tempFile = new File(this.plugin.getDataFolder(), "config_new.yml");
            this.createDefaultConfigWithHeader(tempFile);
            YamlConfiguration newConfig = YamlConfiguration.loadConfiguration((File)tempFile);
            newConfig.set(CONFIG_VERSION_KEY, (Object)this.currentVersion);
            boolean configDiffers = this.hasConfigDifferences(userValues, (FileConfiguration)newConfig);
            if (configDiffers) {
                File backupFile = new File(this.plugin.getDataFolder(), "config_backup_" + configVersionStr + ".yml");
                Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("Config backup created at " + backupFile.getName());
            } else {
                this.plugin.debug("No significant config changes detected, skipping backup creation");
            }
            this.applyUserValues((FileConfiguration)newConfig, userValues);
            newConfig.save(configFile);
            tempFile.delete();
            this.plugin.reloadConfig();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean hasConfigDifferences(Map<String, Object> userValues, FileConfiguration newConfig) {
        Map<String, Object> newConfigMap = this.flattenConfig((ConfigurationSection)newConfig);
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object oldValue = entry.getValue();
            if (path.equals(CONFIG_VERSION_KEY)) continue;
            if (!newConfig.contains(path)) {
                return true;
            }
            Object newDefaultValue = newConfig.get(path);
            if (newDefaultValue == null || newDefaultValue.equals(oldValue)) continue;
            return true;
        }
        for (String path : newConfigMap.keySet()) {
            if (path.equals(CONFIG_VERSION_KEY) || userValues.containsKey(path)) continue;
            return true;
        }
        return false;
    }

    private void createDefaultConfigWithHeader(File destinationFile) {
        try {
            File parentDir = destinationFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (InputStream in = this.plugin.getResource("config.yml");){
                if (in != null) {
                    List<String> defaultLines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().toList();
                    ArrayList<Object> newLines = new ArrayList<Object>();
                    newLines.add("# Configuration version - Do not modify this value");
                    newLines.add("config_version: " + this.currentVersion);
                    newLines.add("");
                    newLines.addAll(defaultLines);
                    Files.write(destinationFile.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    this.plugin.getLogger().warning("Default config.yml not found in the plugin's resources.");
                    destinationFile.createNewFile();
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create default config with header: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private Map<String, Object> flattenConfig(ConfigurationSection config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : config.getKeys(true)) {
            if (config.isConfigurationSection(key)) continue;
            result.put(key, config.get(key));
        }
        return result;
    }

    private void applyUserValues(FileConfiguration newConfig, Map<String, Object> userValues) {
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object value = entry.getValue();
            if (path.equals(CONFIG_VERSION_KEY)) continue;
            if (newConfig.contains(path)) {
                newConfig.set(path, value);
                continue;
            }
            this.plugin.getLogger().warning("Config path '" + path + "' from old config no longer exists in new config");
        }
    }
}

