/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.clear;

import com.mojang.brigadier.context.CommandContext;
import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.BaseSubCommand;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ClearGhostSpawnersSubCommand
extends BaseSubCommand {
    public ClearGhostSpawnersSubCommand(SmartSpawner plugin) {
        super(plugin);
    }

    @Override
    public String getName() {
        return "ghost_spawners";
    }

    @Override
    public String getPermission() {
        return "smartspawner.command.clear";
    }

    @Override
    public String getDescription() {
        return "Check and remove all ghost spawners asynchronously";
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.plugin.getMessageService().sendMessage(sender, "command_ghost_spawner_check_start");
        Scheduler.runTaskAsync(() -> {
            ArrayList<String> ghostSpawnerIds = new ArrayList<String>();
            List<SpawnerData> allSpawners = this.plugin.getSpawnerManager().getAllSpawners();
            for (SpawnerData spawner : allSpawners) {
                if (!this.plugin.getSpawnerManager().isGhostSpawner(spawner)) continue;
                ghostSpawnerIds.add(spawner.getSpawnerId());
            }
            int removedCount = ghostSpawnerIds.size();
            for (String spawnerId : ghostSpawnerIds) {
                this.plugin.getSpawnerManager().removeGhostSpawner(spawnerId);
            }
            Scheduler.runTask(() -> {
                if (removedCount > 0) {
                    this.plugin.getMessageService().sendMessage(sender, "command_ghost_spawner_cleared", Map.of("count", String.valueOf(removedCount)));
                } else {
                    this.plugin.getMessageService().sendMessage(sender, "command_ghost_spawner_none_found");
                }
            });
        });
        return 1;
    }
}

