/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list.gui.adminstacker;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.list.gui.adminstacker.AdminStackerHolder;
import github.nighter.smartspawner.commands.list.gui.adminstacker.AdminStackerUI;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementGUI;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import java.util.HashMap;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;

public class AdminStackerHandler
implements Listener {
    private static final int[] DECREASE_SLOTS = new int[]{9, 10, 11};
    private static final int[] INCREASE_SLOTS = new int[]{17, 16, 15};
    private static final int SPAWNER_INFO_SLOT = 13;
    private static final int BACK_SLOT = 22;
    private static final int[] STACK_AMOUNTS = new int[]{64, 10, 1};
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final SpawnerManagementGUI managementGUI;

    public AdminStackerHandler(SmartSpawner plugin, SpawnerManagementGUI managementGUI) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.managementGUI = managementGUI;
    }

    @EventHandler
    public void onAdminStackerClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof AdminStackerHolder)) {
            return;
        }
        AdminStackerHolder holder = (AdminStackerHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        SpawnerData spawner = holder.getSpawnerData();
        String worldName = holder.getWorldName();
        int listPage = holder.getListPage();
        if (spawner == null) {
            this.messageService.sendMessage(player, "spawner_not_found");
            return;
        }
        int slot = event.getSlot();
        this.handleClick(player, spawner, worldName, listPage, slot);
    }

    private void handleClick(Player player, SpawnerData spawner, String worldName, int listPage, int slot) {
        int i;
        if (slot == 22) {
            this.managementGUI.openManagementMenu(player, spawner.getSpawnerId(), worldName, listPage);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return;
        }
        if (slot == 13) {
            return;
        }
        for (i = 0; i < DECREASE_SLOTS.length; ++i) {
            if (slot != DECREASE_SLOTS[i]) continue;
            this.handleStackChange(player, spawner, worldName, listPage, -STACK_AMOUNTS[i]);
            return;
        }
        for (i = 0; i < INCREASE_SLOTS.length; ++i) {
            if (slot != INCREASE_SLOTS[i]) continue;
            this.handleStackChange(player, spawner, worldName, listPage, STACK_AMOUNTS[i]);
            return;
        }
    }

    private void handleStackChange(Player player, SpawnerData spawner, String worldName, int listPage, int change) {
        if (!player.hasPermission("smartspawner.stack")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        int newStackSize = spawner.getStackSize() + change;
        if (newStackSize < 1) {
            newStackSize = 1;
        } else if (newStackSize > spawner.getMaxStackSize()) {
            newStackSize = spawner.getMaxStackSize();
            HashMap<String, String> placeholders = new HashMap<String, String>(2);
            placeholders.put("max", String.valueOf(newStackSize));
            this.messageService.sendMessage(player, "spawner_stack_full", placeholders);
        }
        spawner.setStackSize(newStackSize);
        spawner.updateLastInteractedPlayer(player.getName());
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        AdminStackerUI adminStackerUI = new AdminStackerUI(this.plugin);
        adminStackerUI.openAdminStackerGui(player, spawner, worldName, listPage);
    }
}

