/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.extras;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class HopperHandler
implements Listener {
    private final SmartSpawner plugin;
    private final Map<Location, Scheduler.Task> activeHoppers = new ConcurrentHashMap<Location, Scheduler.Task>();
    private final SpawnerManager spawnerManager;
    private final SpawnerGuiViewManager spawnerGuiViewManager;
    private final Map<String, ReentrantLock> spawnerLocks = new ConcurrentHashMap<String, ReentrantLock>();

    public HopperHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Scheduler.runTaskLater(() -> {
            if (plugin.getConfig().getBoolean("hopper.enabled", false)) {
                this.restartAllHoppers();
            }
        }, 40L);
    }

    public void restartAllHoppers() {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        for (World world : this.plugin.getServer().getWorlds()) {
            try {
                Location worldLocation = world.getSpawnLocation();
                Scheduler.runLocationTask(worldLocation, () -> {
                    try {
                        for (Chunk chunk : world.getLoadedChunks()) {
                            this.processChunkHoppers(chunk);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error processing hoppers in world " + world.getName(), e);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error scheduling hopper task for world " + world.getName(), e);
            }
        }
    }

    private void processChunkHoppers(Chunk chunk) {
        Location chunkLoc = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 8), 64.0, (double)(chunk.getZ() * 16 + 8));
        Scheduler.runLocationTask(chunkLoc, () -> {
            try {
                for (BlockState state : chunk.getTileEntities(block -> block.getType() == Material.HOPPER, false)) {
                    Block hopperBlock = state.getBlock();
                    Block aboveBlock = hopperBlock.getRelative(BlockFace.UP);
                    if (aboveBlock.getType() != Material.SPAWNER) continue;
                    this.startHopperTask(hopperBlock.getLocation(), aboveBlock.getLocation());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error processing hoppers in chunk at " + chunk.getX() + "," + chunk.getZ(), e);
            }
        });
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        Chunk chunk = event.getChunk();
        this.processChunkHoppers(chunk);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        for (BlockState state : chunk.getTileEntities(block -> block.getType() == Material.HOPPER, false)) {
            this.stopHopperTask(state.getLocation());
        }
    }

    public void cleanup() {
        this.activeHoppers.values().forEach(Scheduler.Task::cancel);
        this.activeHoppers.clear();
        this.spawnerLocks.clear();
    }

    @EventHandler
    public void onHopperPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        if (event.getBlockPlaced().getType() != Material.HOPPER) {
            return;
        }
        Block above = event.getBlockPlaced().getRelative(BlockFace.UP);
        if (above.getType() == Material.SPAWNER) {
            this.startHopperTask(event.getBlockPlaced().getLocation(), above.getLocation());
        }
    }

    @EventHandler
    public void onHopperBreak(BlockBreakEvent event) {
        if (event.getBlock().getType() == Material.HOPPER) {
            this.stopHopperTask(event.getBlock().getLocation());
        }
    }

    private ReentrantLock getOrCreateLock(SpawnerData spawner) {
        return this.spawnerLocks.computeIfAbsent(spawner.getSpawnerId(), k -> new ReentrantLock());
    }

    public void startHopperTask(Location hopperLoc, Location spawnerLoc) {
        if (!this.plugin.getConfig().getBoolean("hopper.enabled", false)) {
            return;
        }
        if (this.activeHoppers.containsKey(hopperLoc)) {
            return;
        }
        Runnable hopperRunnable = () -> {
            try {
                if (!this.isValidSetup(hopperLoc, spawnerLoc)) {
                    this.stopHopperTask(hopperLoc);
                    return;
                }
                this.transferItems(hopperLoc, spawnerLoc);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error in hopper task at " + String.valueOf(hopperLoc), e);
            }
        };
        try {
            Scheduler.Task task = Scheduler.runLocationTaskTimer(hopperLoc, hopperRunnable, 0L, this.plugin.getTimeFromConfig("hopper.check_delay", "3s"));
            this.activeHoppers.put(hopperLoc, task);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to start hopper task at " + String.valueOf(hopperLoc), e);
        }
    }

    private boolean isValidSetup(Location hopperLoc, Location spawnerLoc) {
        Block hopper = hopperLoc.getBlock();
        Block spawner = spawnerLoc.getBlock();
        return hopper.getType() == Material.HOPPER && spawner.getType() == Material.SPAWNER && hopper.getRelative(BlockFace.UP).equals((Object)spawner);
    }

    public void stopHopperTask(Location hopperLoc) {
        Scheduler.Task task = this.activeHoppers.remove(hopperLoc);
        if (task != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferItems(Location hopperLoc, Location spawnerLoc) {
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(spawnerLoc);
        if (spawner == null) {
            return;
        }
        ReentrantLock lock = this.getOrCreateLock(spawner);
        if (!lock.tryLock()) {
            return;
        }
        try {
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            Hopper hopper = (Hopper)hopperLoc.getBlock().getState(false);
            int itemsPerTransfer = this.plugin.getConfig().getInt("hopper.stack_per_transfer", 5);
            int transferred = 0;
            boolean inventoryChanged = false;
            Map<Integer, ItemStack> displayItems = virtualInv.getDisplayInventory();
            ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
            block5: for (Map.Entry<Integer, ItemStack> entry : displayItems.entrySet()) {
                if (transferred >= itemsPerTransfer) break;
                ItemStack item = entry.getValue();
                if (item == null || item.getType() == Material.AIR) continue;
                ItemStack[] hopperContents = hopper.getInventory().getContents();
                for (int i = 0; i < hopperContents.length && transferred < itemsPerTransfer; ++i) {
                    ItemStack hopperItem = hopperContents[i];
                    if (hopperItem == null || hopperItem.getType() == Material.AIR) {
                        hopper.getInventory().setItem(i, item.clone());
                        itemsToRemove.add(item);
                        ++transferred;
                        inventoryChanged = true;
                        continue block5;
                    }
                    if (!hopperItem.isSimilar(item) || hopperItem.getAmount() >= hopperItem.getMaxStackSize()) continue;
                    int space = hopperItem.getMaxStackSize() - hopperItem.getAmount();
                    int toTransfer = Math.min(space, item.getAmount());
                    hopperItem.setAmount(hopperItem.getAmount() + toTransfer);
                    ItemStack toRemove = item.clone();
                    toRemove.setAmount(toTransfer);
                    itemsToRemove.add(toRemove);
                    ++transferred;
                    inventoryChanged = true;
                    continue block5;
                }
            }
            if (!itemsToRemove.isEmpty()) {
                spawner.removeItemsAndUpdateSellValue(itemsToRemove);
            }
            if (inventoryChanged) {
                this.updateOpenGuis(spawner);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error transferring items from spawner to hopper", e);
        }
        finally {
            lock.unlock();
        }
    }

    private void updateOpenGuis(SpawnerData spawner) {
        try {
            Scheduler.runLocationTaskLater(spawner.getSpawnerLocation(), () -> {
                try {
                    this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Error updating GUIs for spawner", e);
                }
            }, 2L);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error scheduling GUI update task", e);
        }
    }
}

