/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.economy.shops.providers.zshop;

import fr.maxlego08.zshop.api.ShopManager;
import fr.maxlego08.zshop.api.buttons.ItemButton;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economy.shops.providers.ShopProvider;
import java.util.Optional;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;

public class ZShopProvider
implements ShopProvider {
    private final SmartSpawner plugin;
    private ShopManager shopManager;

    @Override
    public String getPluginName() {
        return "zShop";
    }

    @Override
    public boolean isAvailable() {
        try {
            Plugin zShopPlugin = Bukkit.getPluginManager().getPlugin("zShop");
            if (zShopPlugin != null && zShopPlugin.isEnabled()) {
                Class.forName("fr.maxlego08.zshop.api.ShopManager");
                Class.forName("fr.maxlego08.zshop.api.buttons.ItemButton");
                ShopManager manager = this.getShopManager();
                return manager != null;
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            this.plugin.debug("zShop API not found: " + e.getMessage());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error initializing zShop integration: " + e.getMessage());
        }
        return false;
    }

    @Override
    public double getSellPrice(Material material) {
        try {
            Optional<ItemButton> itemButtonOpt = this.getItemButton(material);
            if (itemButtonOpt.isEmpty()) {
                return 0.0;
            }
            ItemButton itemButton = itemButtonOpt.get();
            double sellPrice = itemButton.getSellPrice();
            return sellPrice > 0.0 ? sellPrice : 0.0;
        }
        catch (Exception e) {
            this.plugin.debug("Error getting sell price for " + String.valueOf(material) + " from zShop: " + e.getMessage());
            return 0.0;
        }
    }

    private ShopManager getShopManager() {
        if (this.shopManager != null) {
            return this.shopManager;
        }
        try {
            this.shopManager = (ShopManager)this.plugin.getServer().getServicesManager().getRegistration(ShopManager.class).getProvider();
            return this.shopManager;
        }
        catch (Exception e) {
            this.plugin.debug("Failed to get zShop ShopManager: " + e.getMessage());
            return null;
        }
    }

    private Optional<ItemButton> getItemButton(Material material) {
        try {
            ShopManager manager = this.getShopManager();
            if (manager == null) {
                return Optional.empty();
            }
            return manager.getItemButton(material);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting item button from zShop", e);
            return Optional.empty();
        }
    }

    @Generated
    public ZShopProvider(SmartSpawner plugin) {
        this.plugin = plugin;
    }
}

