/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.rpg;

import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.user.SkillsUser;
import github.nighter.smartspawner.SmartSpawner;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class AuraSkillsIntegration {
    private final SmartSpawner plugin;
    private final Map<EntityType, SkillConfig> entitySkillMap;
    private FileConfiguration config;
    private File configFile;
    private boolean enabled = false;
    private AuraSkillsApi auraSkillsApi;

    public AuraSkillsIntegration(SmartSpawner plugin) {
        this.plugin = plugin;
        this.entitySkillMap = new HashMap<EntityType, SkillConfig>();
        if (this.initializeAuraSkills()) {
            this.loadConfig();
            this.loadEntityMappings();
        }
    }

    private boolean initializeAuraSkills() {
        try {
            if (this.plugin.getServer().getPluginManager().getPlugin("AuraSkills") == null) {
                this.plugin.debug("AuraSkills plugin not found");
                return false;
            }
            this.auraSkillsApi = AuraSkillsApi.get();
            if (this.auraSkillsApi == null) {
                this.plugin.getLogger().warning("Failed to get AuraSkills API instance");
                return false;
            }
            this.plugin.getLogger().info("AuraSkills integration initialized successfully!");
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            this.plugin.debug("AuraSkills not available: " + e.getMessage());
            return false;
        }
    }

    private void loadConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "auraskills.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("auraskills.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.enabled = this.config.getBoolean("enabled", true);
        this.plugin.debug("AuraSkills config loaded - Enabled: " + this.enabled);
    }

    private void loadEntityMappings() {
        if (!this.enabled) {
            return;
        }
        this.entitySkillMap.clear();
        ConfigurationSection entitySection = this.config.getConfigurationSection("entity_skills");
        if (entitySection == null) {
            this.plugin.getLogger().warning("No entity_skills section found in auraskills.yml");
            return;
        }
        for (String entityName : entitySection.getKeys(false)) {
            try {
                EntityType entityType = EntityType.valueOf((String)entityName.toUpperCase());
                ConfigurationSection entityConfig = entitySection.getConfigurationSection(entityName);
                if (entityConfig == null) continue;
                String skillName = entityConfig.getString("skill", "FIGHTING");
                double ratio = entityConfig.getDouble("ratio", 0.5);
                SkillConfig skillConfig = new SkillConfig(skillName, ratio);
                this.entitySkillMap.put(entityType, skillConfig);
                this.plugin.debug("Mapped " + String.valueOf(entityType) + " to skill " + skillName + " with ratio " + ratio);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid entity type in auraskills.yml: " + entityName);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.entitySkillMap.size() + " AuraSkills entity mappings");
    }

    public boolean isEnabled() {
        return this.enabled && this.auraSkillsApi != null;
    }

    public void giveSkillXp(Player player, EntityType entityType, int spawnerExp) {
        if (!this.isEnabled()) {
            return;
        }
        SkillConfig skillConfig = this.entitySkillMap.get(entityType);
        if (skillConfig == null) {
            this.plugin.debug("No skill mapping found for entity: " + String.valueOf(entityType));
            return;
        }
        try {
            SkillsUser user = this.auraSkillsApi.getUser(player.getUniqueId());
            if (user == null) {
                this.plugin.debug("Could not get SkillsUser for player: " + player.getName());
                return;
            }
            double skillXp = (double)spawnerExp * skillConfig.ratio();
            switch (skillConfig.skillName().toUpperCase()) {
                case "FIGHTING": {
                    user.addSkillXp((Skill)Skills.FIGHTING, skillXp);
                    break;
                }
                case "FARMING": {
                    user.addSkillXp((Skill)Skills.FARMING, skillXp);
                    break;
                }
                case "MINING": {
                    user.addSkillXp((Skill)Skills.MINING, skillXp);
                    break;
                }
                case "FORAGING": {
                    user.addSkillXp((Skill)Skills.FORAGING, skillXp);
                    break;
                }
                case "FISHING": {
                    user.addSkillXp((Skill)Skills.FISHING, skillXp);
                    break;
                }
                case "EXCAVATION": {
                    user.addSkillXp((Skill)Skills.EXCAVATION, skillXp);
                    break;
                }
                case "ARCHERY": {
                    user.addSkillXp((Skill)Skills.ARCHERY, skillXp);
                    break;
                }
                case "DEFENSE": {
                    user.addSkillXp((Skill)Skills.DEFENSE, skillXp);
                    break;
                }
                case "ENDURANCE": {
                    user.addSkillXp((Skill)Skills.ENDURANCE, skillXp);
                    break;
                }
                case "AGILITY": {
                    user.addSkillXp((Skill)Skills.AGILITY, skillXp);
                    break;
                }
                case "ALCHEMY": {
                    user.addSkillXp((Skill)Skills.ALCHEMY, skillXp);
                    break;
                }
                case "ENCHANTING": {
                    user.addSkillXp((Skill)Skills.ENCHANTING, skillXp);
                    break;
                }
                case "SORCERY": {
                    user.addSkillXp((Skill)Skills.SORCERY, skillXp);
                    break;
                }
                case "HEALING": {
                    user.addSkillXp((Skill)Skills.HEALING, skillXp);
                    break;
                }
                case "FORGING": {
                    user.addSkillXp((Skill)Skills.FORGING, skillXp);
                    break;
                }
                default: {
                    this.plugin.getLogger().warning("Unknown skill type: " + skillConfig.skillName());
                    return;
                }
            }
            if (this.config.getBoolean("debug", false)) {
                this.plugin.getLogger().info("Gave " + skillXp + " " + skillConfig.skillName() + " XP to " + player.getName() + " from " + String.valueOf(entityType) + " spawner");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error giving AuraSkills XP to player " + player.getName(), e);
        }
    }

    public void reloadConfig() {
        this.loadConfig();
        this.loadEntityMappings();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save auraskills.yml", e);
        }
    }

    private record SkillConfig(String skillName, double ratio) {
    }
}

