/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.utils;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.utils.ItemStackSerializer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class SpawnerFileHandler {
    private final SmartSpawner plugin;
    private final Logger logger;
    private File spawnerDataFile;
    private FileConfiguration spawnerData;
    private static final String DATA_VERSION_KEY = "data_version";
    private final int CURRENT_VERSION;
    private final Set<String> dirtySpawners = ConcurrentHashMap.newKeySet();
    private final Set<String> deletedSpawners = ConcurrentHashMap.newKeySet();
    private volatile boolean isSaving = false;
    private Scheduler.Task saveTask = null;

    public SpawnerFileHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.CURRENT_VERSION = plugin.getDATA_VERSION();
        this.setupSpawnerDataFile();
        this.startSaveTask();
    }

    private void setupSpawnerDataFile() {
        this.spawnerDataFile = new File(this.plugin.getDataFolder(), "spawners_data.yml");
        if (!this.spawnerDataFile.exists()) {
            this.plugin.saveResource("spawners_data.yml", false);
        }
        this.spawnerData = YamlConfiguration.loadConfiguration((File)this.spawnerDataFile);
        int version = this.spawnerData.getInt(DATA_VERSION_KEY, 1);
        if (version < this.CURRENT_VERSION) {
            this.logger.info("Data version " + version + " detected. Current version is " + this.CURRENT_VERSION + ".");
            this.logger.info("A migration will be attempted when the plugin fully loads.");
        }
    }

    private void startSaveTask() {
        long intervalTicks = 6000L;
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        this.saveTask = Scheduler.runTaskTimerAsync(() -> {
            this.plugin.debug("Running scheduled save task");
            this.flushChanges();
        }, intervalTicks, intervalTicks);
    }

    public void markSpawnerModified(String spawnerId) {
        if (spawnerId != null) {
            this.dirtySpawners.add(spawnerId);
            this.deletedSpawners.remove(spawnerId);
        }
    }

    public void markSpawnerDeleted(String spawnerId) {
        if (spawnerId != null) {
            this.deletedSpawners.add(spawnerId);
            this.dirtySpawners.remove(spawnerId);
        }
    }

    public void flushChanges() {
        if (this.dirtySpawners.isEmpty() && this.deletedSpawners.isEmpty()) {
            this.plugin.debug("No changes to flush");
            return;
        }
        if (this.isSaving) {
            this.plugin.debug("Flush operation already in progress");
            return;
        }
        this.isSaving = true;
        this.plugin.debug("Flushing " + this.dirtySpawners.size() + " modified and " + this.deletedSpawners.size() + " deleted spawners");
        Scheduler.runTaskAsync(() -> {
            try {
                if (!this.dirtySpawners.isEmpty()) {
                    HashSet<String> toUpdate = new HashSet<String>(this.dirtySpawners);
                    this.dirtySpawners.removeAll(toUpdate);
                    HashMap<String, SpawnerData> batch = new HashMap<String, SpawnerData>();
                    for (String id : toUpdate) {
                        SpawnerData spawner = this.plugin.getSpawnerManager().getSpawnerById(id);
                        if (spawner == null) continue;
                        batch.put(id, spawner);
                    }
                    if (!batch.isEmpty()) {
                        this.saveSpawnerBatch(batch);
                    }
                }
                if (!this.deletedSpawners.isEmpty()) {
                    HashSet<String> toDelete = new HashSet<String>(this.deletedSpawners);
                    this.deletedSpawners.removeAll(toDelete);
                    for (String id : toDelete) {
                        String path = "spawners." + id;
                        this.spawnerData.set(path, null);
                    }
                    if (!toDelete.isEmpty()) {
                        this.spawnerData.save(this.spawnerDataFile);
                    }
                }
                this.scheduleGhostSpawnerCheck();
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error during flush: " + e.getMessage());
                e.printStackTrace();
                for (String id : this.dirtySpawners) {
                    this.dirtySpawners.add(id);
                }
                for (String id : this.deletedSpawners) {
                    this.deletedSpawners.add(id);
                }
            }
            finally {
                this.isSaving = false;
            }
        });
    }

    private void scheduleGhostSpawnerCheck() {
        this.plugin.debug("Scheduling ghost spawner check after save");
        Scheduler.runTaskAsync(() -> {
            ArrayList<String> ghostSpawnerIds = new ArrayList<String>();
            List<SpawnerData> allSpawners = this.plugin.getSpawnerManager().getAllSpawners();
            for (SpawnerData spawner : allSpawners) {
                if (!this.plugin.getSpawnerManager().isGhostSpawner(spawner)) continue;
                ghostSpawnerIds.add(spawner.getSpawnerId());
            }
            if (!ghostSpawnerIds.isEmpty()) {
                this.plugin.debug("Found " + ghostSpawnerIds.size() + " ghost spawners during scheduled check");
                for (String spawnerId : ghostSpawnerIds) {
                    this.plugin.getSpawnerManager().removeGhostSpawner(spawnerId);
                }
            }
        });
    }

    private boolean saveSpawnerBatch(Map<String, SpawnerData> spawners) {
        if (spawners.isEmpty()) {
            return true;
        }
        try {
            ConfigurationSection spawnersSection = this.spawnerData.getConfigurationSection("spawners");
            if (spawnersSection == null) {
                spawnersSection = this.spawnerData.createSection("spawners");
            }
            this.spawnerData.set(DATA_VERSION_KEY, (Object)this.CURRENT_VERSION);
            for (Map.Entry<String, SpawnerData> entry : spawners.entrySet()) {
                VirtualInventory virtualInv;
                String spawnerId = entry.getKey();
                SpawnerData spawner = entry.getValue();
                String path = "spawners." + spawnerId;
                Location loc = spawner.getSpawnerLocation();
                this.spawnerData.set(path + ".location", (Object)String.format("%s,%d,%d,%d", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
                this.spawnerData.set(path + ".entityType", spawner.getEntityType() != null ? spawner.getEntityType().name() : null);
                String settings = String.format("%d,%b,%d,%b,%d,%d,%d,%d,%d,%d,%d,%d,%b", spawner.getSpawnerExp(), spawner.getSpawnerActive(), spawner.getSpawnerRange(), spawner.getSpawnerStop().get(), spawner.getSpawnDelay(), spawner.getMaxSpawnerLootSlots(), spawner.getMaxStoredExp(), spawner.getMinMobs(), spawner.getMaxMobs(), spawner.getStackSize(), spawner.getMaxStackSize(), spawner.getLastSpawnTime(), spawner.getIsAtCapacity());
                this.spawnerData.set(path + ".settings", (Object)settings);
                this.spawnerData.set(path + ".lastInteractedPlayer", (Object)spawner.getLastInteractedPlayer());
                this.spawnerData.set(path + ".preferredSortItem", spawner.getPreferredSortItem() != null ? spawner.getPreferredSortItem().name() : null);
                Set<Material> filteredItems = spawner.getFilteredItems();
                if (filteredItems != null && !filteredItems.isEmpty()) {
                    List materials = filteredItems.stream().map(Enum::name).collect(Collectors.toList());
                    this.spawnerData.set(path + ".filteredItems", (Object)String.join((CharSequence)",", materials));
                } else {
                    this.spawnerData.set(path + ".filteredItems", null);
                }
                if ((virtualInv = spawner.getVirtualInventory()) == null) continue;
                Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
                List<String> serializedItems = ItemStackSerializer.serializeInventory(items);
                this.spawnerData.set(path + ".inventory", serializedItems);
            }
            this.spawnerData.save(this.spawnerDataFile);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save spawner batch to file!");
            e.printStackTrace();
            return false;
        }
    }

    public Map<String, SpawnerData> loadAllSpawnersRaw() {
        HashMap<String, SpawnerData> loadedSpawners = new HashMap<String, SpawnerData>();
        ConfigurationSection spawnersSection = this.spawnerData.getConfigurationSection("spawners");
        if (spawnersSection == null) {
            return loadedSpawners;
        }
        for (String spawnerId : spawnersSection.getKeys(false)) {
            try {
                SpawnerData spawner = this.loadSpawnerFromConfig(spawnerId, false);
                loadedSpawners.put(spawnerId, spawner);
            }
            catch (Exception e) {
                this.plugin.debug("Error loading spawner " + spawnerId + ": " + e.getMessage());
                loadedSpawners.put(spawnerId, null);
            }
        }
        return loadedSpawners;
    }

    public SpawnerData loadSpecificSpawner(String spawnerId) {
        try {
            return this.loadSpawnerFromConfig(spawnerId, false);
        }
        catch (Exception e) {
            this.plugin.debug("Error loading spawner " + spawnerId + ": " + e.getMessage());
            return null;
        }
    }

    public String getRawLocationString(String spawnerId) {
        String path = "spawners." + spawnerId + ".location";
        return this.spawnerData.getString(path);
    }

    private SpawnerData loadSpawnerFromConfig(String spawnerId) {
        return this.loadSpawnerFromConfig(spawnerId, true);
    }

    private SpawnerData loadSpawnerFromConfig(String spawnerId, boolean logErrors) {
        String filteredItemsStr;
        EntityType entityType;
        String path = "spawners." + spawnerId;
        String locationString = this.spawnerData.getString(path + ".location");
        if (locationString == null) {
            if (logErrors) {
                this.logger.severe("Invalid location for spawner " + spawnerId);
            }
            return null;
        }
        String[] locParts = locationString.split(",");
        if (locParts.length != 4) {
            if (logErrors) {
                this.logger.severe("Invalid location format for spawner " + spawnerId);
            }
            return null;
        }
        World world = Bukkit.getWorld((String)locParts[0]);
        if (world == null) {
            if (logErrors) {
                this.logger.severe("World not found for spawner " + spawnerId + ": " + locParts[0]);
            } else {
                this.plugin.debug("World not yet loaded for spawner " + spawnerId + ": " + locParts[0]);
            }
            return null;
        }
        Location location = new Location(world, (double)Integer.parseInt(locParts[1]), (double)Integer.parseInt(locParts[2]), (double)Integer.parseInt(locParts[3]));
        String entityTypeString = this.spawnerData.getString(path + ".entityType");
        if (entityTypeString == null) {
            if (logErrors) {
                this.logger.severe("Missing entity type for spawner " + spawnerId);
            }
            return null;
        }
        try {
            entityType = EntityType.valueOf((String)entityTypeString);
        }
        catch (IllegalArgumentException e) {
            if (logErrors) {
                this.logger.severe("Invalid entity type for spawner " + spawnerId + ": " + entityTypeString);
            }
            return null;
        }
        SpawnerData spawner = new SpawnerData(spawnerId, location, entityType, this.plugin);
        String settingsString = this.spawnerData.getString(path + ".settings");
        if (settingsString != null) {
            String[] settings = settingsString.split(",");
            int version = this.spawnerData.getInt(DATA_VERSION_KEY, 1);
            try {
                if (version >= 3) {
                    if (settings.length >= 13) {
                        spawner.setSpawnerExpData(Integer.parseInt(settings[0]));
                        spawner.setSpawnerActive(Boolean.parseBoolean(settings[1]));
                        spawner.setSpawnerRange(Integer.parseInt(settings[2]));
                        spawner.getSpawnerStop().set(Boolean.parseBoolean(settings[3]));
                        spawner.setSpawnDelay(Integer.parseInt(settings[4]));
                        spawner.setMaxSpawnerLootSlots(Integer.parseInt(settings[5]));
                        spawner.setMaxStoredExp(Integer.parseInt(settings[6]));
                        spawner.setMinMobs(Integer.parseInt(settings[7]));
                        spawner.setMaxMobs(Integer.parseInt(settings[8]));
                        spawner.setStackSize(Integer.parseInt(settings[9]));
                        spawner.setMaxStackSize(Integer.parseInt(settings[10]));
                        spawner.setLastSpawnTime(Long.parseLong(settings[11]));
                        spawner.setIsAtCapacity(Boolean.parseBoolean(settings[12]));
                    }
                } else {
                    spawner.setSpawnerExpData(Integer.parseInt(settings[0]));
                    spawner.setSpawnerActive(Boolean.parseBoolean(settings[1]));
                    spawner.setSpawnerRange(Integer.parseInt(settings[2]));
                    spawner.getSpawnerStop().set(Boolean.parseBoolean(settings[3]));
                    spawner.setSpawnDelay(Integer.parseInt(settings[4]));
                    spawner.setMaxSpawnerLootSlots(Integer.parseInt(settings[5]));
                    spawner.setMaxStoredExp(Integer.parseInt(settings[6]));
                    spawner.setMinMobs(Integer.parseInt(settings[7]));
                    spawner.setMaxMobs(Integer.parseInt(settings[8]));
                    spawner.setStackSize(Integer.parseInt(settings[9]));
                    spawner.setLastSpawnTime(Long.parseLong(settings[10]));
                    spawner.setIsAtCapacity(false);
                }
            }
            catch (NumberFormatException e) {
                this.logger.severe("Invalid settings format for spawner " + spawnerId);
                this.logger.severe("Settings: " + settingsString);
                e.printStackTrace();
                return null;
            }
        }
        if ((filteredItemsStr = this.spawnerData.getString(path + ".filteredItems")) != null && !filteredItemsStr.isEmpty()) {
            String[] materialNames;
            for (String materialName : materialNames = filteredItemsStr.split(",")) {
                try {
                    Material material = Material.valueOf((String)materialName.trim());
                    spawner.getFilteredItems().add(material);
                }
                catch (IllegalArgumentException e) {
                    this.logger.warning("Invalid material in filtered items for spawner " + spawnerId + ": " + materialName);
                }
            }
        }
        List inventoryData = this.spawnerData.getStringList(path + ".inventory");
        VirtualInventory virtualInv = new VirtualInventory(spawner.getMaxSpawnerLootSlots());
        if (inventoryData != null && !inventoryData.isEmpty()) {
            try {
                Map<ItemStack, Integer> items = ItemStackSerializer.deserializeInventory(inventoryData);
                for (Map.Entry<ItemStack, Integer> entry : items.entrySet()) {
                    int batchSize;
                    int amount;
                    ItemStack item = entry.getKey();
                    if (item == null || amount <= 0) continue;
                    for (amount = entry.getValue().intValue(); amount > 0; amount -= batchSize) {
                        batchSize = Math.min(amount, item.getMaxStackSize());
                        ItemStack batch = item.clone();
                        batch.setAmount(batchSize);
                        virtualInv.addItems(Collections.singletonList(batch));
                    }
                }
            }
            catch (Exception e) {
                this.logger.warning("Error loading inventory for spawner " + spawnerId);
                e.printStackTrace();
            }
        }
        spawner.setVirtualInventory(virtualInv);
        spawner.recalculateSellValue();
        String lastInteractedPlayer = this.spawnerData.getString(path + ".lastInteractedPlayer");
        spawner.setLastInteractedPlayer(lastInteractedPlayer);
        String preferredSortItemStr = this.spawnerData.getString(path + ".preferredSortItem");
        if (preferredSortItemStr != null && !preferredSortItemStr.isEmpty()) {
            try {
                Material preferredSortItem = Material.valueOf((String)preferredSortItemStr);
                spawner.setPreferredSortItem(preferredSortItem);
                virtualInv.sortItems(preferredSortItem);
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("Invalid preferred sort item for spawner " + spawnerId + ": " + preferredSortItemStr);
            }
        }
        return spawner;
    }

    public void queueSpawnerForSaving(String spawnerId) {
        this.markSpawnerModified(spawnerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        if (!this.dirtySpawners.isEmpty() || !this.deletedSpawners.isEmpty()) {
            try {
                this.isSaving = true;
                if (!this.dirtySpawners.isEmpty()) {
                    HashMap batch = new HashMap();
                    for (String id : this.dirtySpawners) {
                        SpawnerData spawner = this.plugin.getSpawnerManager().getSpawnerById(id);
                        if (spawner == null) continue;
                        batch.put(id, spawner);
                    }
                    if (!batch.isEmpty()) {
                        this.saveSpawnerBatch(batch);
                    }
                }
                if (!this.deletedSpawners.isEmpty()) {
                    for (String id : this.deletedSpawners) {
                        String path = "spawners." + id;
                        this.spawnerData.set(path, null);
                    }
                    this.spawnerData.save(this.spawnerDataFile);
                }
                this.dirtySpawners.clear();
                this.deletedSpawners.clear();
            }
            catch (Exception e) {
                this.logger.severe("Error during shutdown flush: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.isSaving = false;
            }
        }
    }
}

