/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list;

import com.mojang.brigadier.context.CommandContext;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.BaseSubCommand;
import github.nighter.smartspawner.commands.list.gui.list.SpawnerListHolder;
import github.nighter.smartspawner.commands.list.gui.list.UserPreferenceCache;
import github.nighter.smartspawner.commands.list.gui.list.enums.FilterOption;
import github.nighter.smartspawner.commands.list.gui.list.enums.SortOption;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementGUI;
import github.nighter.smartspawner.commands.list.gui.worldselection.WorldSelectionHolder;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.utils.SpawnerMobHeadTexture;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ListSubCommand
extends BaseSubCommand {
    private final SpawnerManager spawnerManager;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final UserPreferenceCache userPreferenceCache;
    private final SpawnerManagementGUI spawnerManagementGUI;
    private static final int SPAWNERS_PER_PAGE = 45;

    public ListSubCommand(SmartSpawner plugin) {
        super(plugin);
        this.spawnerManager = plugin.getSpawnerManager();
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.userPreferenceCache = plugin.getUserPreferenceCache();
        this.spawnerManagementGUI = new SpawnerManagementGUI(plugin);
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public String getPermission() {
        return "smartspawner.command.list";
    }

    @Override
    public String getDescription() {
        return "Open the spawner list GUI";
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        if (!this.isPlayer(((CommandSourceStack)context.getSource()).getSender())) {
            return 0;
        }
        Player player = this.getPlayer(((CommandSourceStack)context.getSource()).getSender());
        this.openWorldSelectionGUI(player);
        return 1;
    }

    public void openWorldSelectionGUI(Player player) {
        if (!player.hasPermission("smartspawner.list")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        List worlds = Bukkit.getWorlds().stream().filter(world -> this.spawnerManager.countSpawnersInWorld(world.getName()) > 0).collect(Collectors.toList());
        List customWorlds = worlds.stream().filter(world -> !this.isDefaultWorld(world.getName())).collect(Collectors.toList());
        boolean hasCustomWorlds = !customWorlds.isEmpty();
        int size = hasCustomWorlds ? Math.max(27, (int)Math.ceil((double)(worlds.size() + 2) / 7.0) * 9) : 27;
        Inventory inv = Bukkit.createInventory((InventoryHolder)new WorldSelectionHolder(), (int)size, (String)this.languageManager.getGuiTitle("gui_title_world_selection"));
        if (!hasCustomWorlds) {
            ItemStack overworldButton = this.createWorldButtonIfWorldExists("world", Material.GRASS_BLOCK, this.languageManager.getGuiTitle("world_buttons.overworld.name"));
            ItemStack netherButton = this.createWorldButtonIfWorldExists("world_nether", Material.NETHERRACK, this.languageManager.getGuiTitle("world_buttons.nether.name"));
            ItemStack endButton = this.createWorldButtonIfWorldExists("world_the_end", Material.END_STONE, this.languageManager.getGuiTitle("world_buttons.end.name"));
            if (overworldButton != null) {
                inv.setItem(11, overworldButton);
            }
            if (netherButton != null) {
                inv.setItem(13, netherButton);
            }
            if (endButton != null) {
                inv.setItem(15, endButton);
            }
        } else {
            int slot = 10;
            int row = 1;
            if (this.addWorldButtonIfExists(inv, "world", Material.GRASS_BLOCK, this.languageManager.getGuiTitle("world_buttons.overworld.name"), slot)) {
                ++slot;
            }
            if (this.addWorldButtonIfExists(inv, "world_nether", Material.NETHERRACK, this.languageManager.getGuiTitle("world_buttons.nether.name"), slot)) {
                ++slot;
            }
            if (this.addWorldButtonIfExists(inv, "world_the_end", Material.END_STONE, this.languageManager.getGuiTitle("world_buttons.end.name"), slot)) {
                ++slot;
            }
            for (World world2 : customWorlds) {
                if (slot % 9 == 8) {
                    slot = 9 * ++row + 1;
                }
                if (slot >= size) break;
                Material material = this.getMaterialForWorldType(world2.getEnvironment());
                this.addWorldButton(inv, world2.getName(), material, this.formatWorldName(world2.getName()), slot++);
            }
        }
        player.openInventory(inv);
    }

    private boolean isDefaultWorld(String worldName) {
        return worldName.equals("world") || worldName.equals("world_nether") || worldName.equals("world_the_end");
    }

    private ItemStack createWorldButtonIfWorldExists(String worldName, Material material, String displayName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null && this.spawnerManager.countSpawnersInWorld(worldName) > 0) {
            return this.createWorldButton(material, displayName, this.getWorldDescription(worldName));
        }
        return null;
    }

    private boolean addWorldButtonIfExists(Inventory inv, String worldName, Material material, String displayName, int slot) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null && this.spawnerManager.countSpawnersInWorld(worldName) > 0) {
            this.addWorldButton(inv, worldName, material, displayName, slot);
            return true;
        }
        return false;
    }

    private void addWorldButton(Inventory inv, String worldName, Material material, String displayName, int slot) {
        World world;
        if (!this.isDefaultWorld(worldName) && (world = Bukkit.getWorld((String)worldName)) != null) {
            World.Environment environment = world.getEnvironment();
            String namePath = switch (environment) {
                case World.Environment.NORMAL -> "world_buttons.custom_overworld.name";
                case World.Environment.NETHER -> "world_buttons.custom_nether.name";
                case World.Environment.THE_END -> "world_buttons.custom_end.name";
                default -> "world_buttons.custom_default.name";
            };
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world_name", displayName);
            displayName = this.languageManager.getGuiTitle(namePath, placeholders);
        }
        ItemStack button = this.createWorldButton(material, displayName, this.getWorldDescription(worldName));
        inv.setItem(slot, button);
    }

    private Material getMaterialForWorldType(World.Environment environment) {
        return switch (environment) {
            case World.Environment.NORMAL -> Material.GRASS_BLOCK;
            case World.Environment.NETHER -> Material.NETHERRACK;
            case World.Environment.THE_END -> Material.END_STONE;
            default -> Material.ENDER_PEARL;
        };
    }

    private String formatWorldName(String worldName) {
        return Arrays.stream(worldName.replace('_', ' ').split(" ")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private List<String> getWorldDescription(String worldName) {
        String path;
        ArrayList description = new ArrayList();
        int physicalSpawners = this.spawnerManager.countSpawnersInWorld(worldName);
        int totalWithStacks = this.spawnerManager.countTotalSpawnersWithStacks(worldName);
        if (worldName.equals("world")) {
            path = "world_buttons.overworld.lore";
        } else if (worldName.equals("world_nether")) {
            path = "world_buttons.nether.lore";
        } else if (worldName.equals("world_the_end")) {
            path = "world_buttons.end.lore";
        } else {
            World world = Bukkit.getWorld((String)worldName);
            World.Environment environment = world != null ? world.getEnvironment() : World.Environment.NORMAL;
            switch (environment) {
                case NORMAL: {
                    path = "world_buttons.overworld.lore";
                    break;
                }
                case NETHER: {
                    path = "world_buttons.nether.lore";
                    break;
                }
                case THE_END: {
                    path = "world_buttons.end.lore";
                    break;
                }
                default: {
                    path = "world_buttons.custom_default.lore";
                }
            }
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("total", String.valueOf(physicalSpawners));
        placeholders.put("total_stacked", this.languageManager.formatNumber(totalWithStacks));
        String[] loreArray = this.languageManager.getGuiItemLore(path, placeholders);
        return Arrays.asList(loreArray);
    }

    private ItemStack createWorldButton(Material material, String name, List<String> lore) {
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    public void openSpawnerListGUI(Player player, String worldName, int page) {
        UserPreferenceCache.UserPreference preference = this.userPreferenceCache.getPreference(player.getUniqueId(), worldName);
        if (preference != null) {
            this.openSpawnerListGUI(player, worldName, page, preference.getFilterOption(), preference.getSortOption());
        } else {
            this.openSpawnerListGUI(player, worldName, page, FilterOption.ALL, SortOption.DEFAULT);
        }
    }

    public void saveUserPreference(Player player, String worldName, FilterOption filter, SortOption sort) {
        this.userPreferenceCache.savePreference(player.getUniqueId(), worldName, filter, sort);
    }

    public void openSpawnerListGUI(Player player, String worldName, int page, FilterOption filter, SortOption sortType) {
        if (!player.hasPermission("smartspawner.list")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        List worldSpawners = this.spawnerManager.getAllSpawners().stream().filter(spawner -> spawner.getSpawnerLocation().getWorld().getName().equals(worldName)).collect(Collectors.toList());
        if (filter == FilterOption.ACTIVE) {
            worldSpawners = worldSpawners.stream().filter(spawner -> !spawner.getSpawnerStop().get()).collect(Collectors.toList());
        } else if (filter == FilterOption.INACTIVE) {
            worldSpawners = worldSpawners.stream().filter(spawner -> spawner.getSpawnerStop().get()).collect(Collectors.toList());
        }
        switch (sortType) {
            case STACK_SIZE_ASC: {
                worldSpawners.sort(Comparator.comparingInt(SpawnerData::getStackSize));
                break;
            }
            case STACK_SIZE_DESC: {
                worldSpawners.sort(Comparator.comparingInt(SpawnerData::getStackSize).reversed());
                break;
            }
        }
        int totalPages = (int)Math.ceil((double)worldSpawners.size() / 45.0);
        page = Math.max(1, Math.min(page, totalPages));
        String worldTitle = switch (worldName) {
            case "world" -> this.languageManager.getGuiTitle("world_buttons.overworld.name");
            case "world_nether" -> this.languageManager.getGuiTitle("world_buttons.nether.name");
            case "world_the_end" -> this.languageManager.getGuiTitle("world_buttons.end.name");
            default -> this.formatWorldName(worldName);
        };
        HashMap<String, String> titlePlaceholders = new HashMap<String, String>();
        worldTitle = ChatColor.stripColor((String)worldTitle);
        titlePlaceholders.put("world", worldTitle);
        titlePlaceholders.put("current", String.valueOf(page));
        titlePlaceholders.put("total", String.valueOf(totalPages));
        String title = this.languageManager.getGuiTitle("gui_title_spawner_list", titlePlaceholders);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new SpawnerListHolder(page, totalPages, worldName, filter, sortType), (int)54, (String)title);
        int startIndex = (page - 1) * 45;
        int endIndex = Math.min(startIndex + 45, worldSpawners.size());
        for (int i = startIndex; i < endIndex; ++i) {
            SpawnerData spawner2 = (SpawnerData)worldSpawners.get(i);
            inv.addItem(new ItemStack[]{this.createSpawnerInfoItem(spawner2)});
        }
        this.addControlButtons(inv, filter, sortType);
        if (page > 1) {
            inv.setItem(45, this.createNavigationButton(Material.SPECTRAL_ARROW, "navigation.previous_page"));
        }
        inv.setItem(49, this.createNavigationButton(Material.RED_STAINED_GLASS_PANE, "navigation.back"));
        if (page < totalPages) {
            inv.setItem(53, this.createNavigationButton(Material.SPECTRAL_ARROW, "navigation.next_page"));
        }
        player.openInventory(inv);
    }

    private void addControlButtons(Inventory inv, FilterOption currentFilter, SortOption currentSort) {
        ItemStack filterButton = this.createEnhancedControlButton(Material.CAULDRON, "filter", currentFilter);
        ItemStack sortButton = this.createEnhancedControlButton(Material.HOPPER, "sort", currentSort);
        inv.setItem(48, filterButton);
        inv.setItem(50, sortButton);
    }

    private ItemStack createEnhancedControlButton(Material material, String controlType, Enum<?> currentOption) {
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        if (meta == null) {
            return button;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        String selectedFormat = this.languageManager.getGuiItemName(controlType + ".selected_option");
        String unselectedFormat = this.languageManager.getGuiItemName(controlType + ".unselected_option");
        StringBuilder availableOptions = new StringBuilder();
        boolean first = true;
        if (controlType.equals("filter")) {
            FilterOption currentFilter = (FilterOption)currentOption;
            for (Enum enum_ : FilterOption.values()) {
                if (!first) {
                    availableOptions.append("\n");
                }
                String optionName = this.languageManager.getGuiItemName("filter." + ((FilterOption)enum_).getName());
                String format = enum_ == currentFilter ? selectedFormat : unselectedFormat;
                String formattedOption = format.replace("%option_name%", optionName);
                availableOptions.append(formattedOption);
                first = false;
            }
            meta.setDisplayName(this.languageManager.getGuiItemName("filter.button.name"));
        } else if (controlType.equals("sort")) {
            SortOption currentSort = (SortOption)currentOption;
            for (Enum enum_ : SortOption.values()) {
                if (!first) {
                    availableOptions.append("\n");
                }
                String optionName = this.languageManager.getGuiItemName("sort." + ((SortOption)enum_).getName());
                String format = enum_ == currentSort ? selectedFormat : unselectedFormat;
                String formattedOption = format.replace("%option_name%", optionName);
                availableOptions.append(formattedOption);
                first = false;
            }
            meta.setDisplayName(this.languageManager.getGuiItemName("sort.button.name"));
        }
        placeholders.put("available_options", availableOptions.toString());
        String lorePath = controlType + ".button.lore";
        List<String> lore = this.languageManager.getGuiItemLoreWithMultilinePlaceholders(lorePath, placeholders);
        meta.setLore(lore);
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack createNavigationButton(Material material, String namePath) {
        ItemStack button = new ItemStack(material);
        ItemMeta meta = button.getItemMeta();
        meta.setDisplayName(this.languageManager.getGuiItemName(namePath));
        button.setItemMeta(meta);
        return button;
    }

    private ItemStack createSpawnerInfoItem(SpawnerData spawner) {
        ItemMeta meta;
        ItemStack spawnerItem;
        EntityType entityType = spawner.getEntityType();
        if (entityType == null) {
            spawnerItem = new ItemStack(Material.SPAWNER);
            meta = spawnerItem.getItemMeta();
            if (meta == null) {
                return spawnerItem;
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE});
        } else {
            spawnerItem = SpawnerMobHeadTexture.getCustomHead(entityType);
            meta = spawnerItem.getItemMeta();
            if (meta == null) {
                return spawnerItem;
            }
        }
        Location loc = spawner.getSpawnerLocation();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("id", String.valueOf(spawner.getSpawnerId()));
        meta.setDisplayName(this.languageManager.getGuiItemName("spawner_item_list.name", placeholders));
        placeholders.put("entity", this.languageManager.getFormattedMobName(entityType));
        placeholders.put("size", String.valueOf(spawner.getStackSize()));
        if (spawner.getSpawnerStop().get()) {
            placeholders.put("status_color", "&#ff6b6b");
            placeholders.put("status_text", "Inactive");
        } else {
            placeholders.put("status_color", "&#00E689");
            placeholders.put("status_text", "Active");
        }
        placeholders.put("x", String.valueOf(loc.getBlockX()));
        placeholders.put("y", String.valueOf(loc.getBlockY()));
        placeholders.put("z", String.valueOf(loc.getBlockZ()));
        String lastPlayer = spawner.getLastInteractedPlayer();
        placeholders.put("last_player", lastPlayer != null ? lastPlayer : "None");
        List<String> lore = Arrays.asList(this.languageManager.getGuiItemLore("spawner_item_list.lore", placeholders));
        meta.setLore(lore);
        spawnerItem.setItemMeta(meta);
        return spawnerItem;
    }

    public void openSpawnerManagementGUI(Player player, String spawnerId, String worldName, int listPage) {
        this.spawnerManagementGUI.openManagementMenu(player, spawnerId, worldName, listPage);
    }

    public FilterOption getUserFilter(Player player, String worldName) {
        return this.userPreferenceCache.getUserFilter(player, worldName);
    }

    public SortOption getUserSort(Player player, String worldName) {
        return this.userPreferenceCache.getUserSort(player, worldName);
    }
}

