/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list.gui.management;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.list.ListSubCommand;
import github.nighter.smartspawner.commands.list.gui.adminstacker.AdminStackerUI;
import github.nighter.smartspawner.commands.list.gui.list.enums.FilterOption;
import github.nighter.smartspawner.commands.list.gui.list.enums.SortOption;
import github.nighter.smartspawner.commands.list.gui.management.SpawnerManagementHolder;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.utils.SpawnerFileHandler;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SpawnerManagementHandler
implements Listener {
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerManager spawnerManager;
    private final SpawnerFileHandler spawnerFileHandler;
    private final ListSubCommand listSubCommand;
    private final SpawnerMenuUI spawnerMenuUI;
    private final AdminStackerUI adminStackerUI;

    public SpawnerManagementHandler(SmartSpawner plugin, ListSubCommand listSubCommand) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerManager = plugin.getSpawnerManager();
        this.spawnerFileHandler = plugin.getSpawnerFileHandler();
        this.listSubCommand = listSubCommand;
        this.spawnerMenuUI = plugin.getSpawnerMenuUI();
        this.adminStackerUI = new AdminStackerUI(plugin);
    }

    @EventHandler
    public void onSpawnerManagementClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof SpawnerManagementHolder)) {
            return;
        }
        SpawnerManagementHolder holder = (SpawnerManagementHolder)inventoryHolder;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        event.setCancelled(true);
        if (event.getCurrentItem() == null) {
            return;
        }
        String spawnerId = holder.getSpawnerId();
        String worldName = holder.getWorldName();
        int listPage = holder.getListPage();
        SpawnerData spawner = this.spawnerManager.getSpawnerById(spawnerId);
        if (spawner == null) {
            this.messageService.sendMessage(player, "spawner_not_found");
            return;
        }
        int slot = event.getSlot();
        ItemStack clickedItem = event.getCurrentItem();
        switch (slot) {
            case 10: {
                this.handleTeleport(player, spawner);
                break;
            }
            case 12: {
                this.handleOpenSpawner(player, spawner);
                break;
            }
            case 14: {
                this.handleStackManagement(player, spawner, worldName, listPage);
                break;
            }
            case 16: {
                this.handleRemoveSpawner(player, spawner, worldName, listPage);
                break;
            }
            case 26: {
                this.handleBack(player, worldName, listPage);
            }
        }
    }

    private void handleTeleport(Player player, SpawnerData spawner) {
        Location loc = spawner.getSpawnerLocation().clone().add(0.5, 1.0, 0.5);
        player.teleportAsync(loc);
        this.messageService.sendMessage(player, "teleported_to_spawner");
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        player.closeInventory();
    }

    private void handleOpenSpawner(Player player, SpawnerData spawner) {
        if (this.isBedrockPlayer(player)) {
            if (this.plugin.getSpawnerMenuFormUI() != null) {
                this.plugin.getSpawnerMenuFormUI().openSpawnerForm(player, spawner);
            } else {
                this.spawnerMenuUI.openSpawnerMenu(player, spawner, false);
            }
        } else {
            this.spawnerMenuUI.openSpawnerMenu(player, spawner, false);
        }
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    private void handleStackManagement(Player player, SpawnerData spawner, String worldName, int listPage) {
        if (!player.hasPermission("smartspawner.stack")) {
            this.messageService.sendMessage(player, "no_permission");
            return;
        }
        this.adminStackerUI.openAdminStackerGui(player, spawner, worldName, listPage);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    private void handleRemoveSpawner(Player player, SpawnerData spawner, String worldName, int listPage) {
        Location loc = spawner.getSpawnerLocation();
        this.plugin.getSpawnerGuiViewManager().closeAllViewersInventory(spawner);
        String spawnerId = spawner.getSpawnerId();
        spawner.getSpawnerStop().set(true);
        if (loc.getBlock().getType() == Material.SPAWNER) {
            loc.getBlock().setType(Material.AIR);
        }
        this.spawnerManager.removeSpawner(spawnerId);
        this.spawnerFileHandler.markSpawnerDeleted(spawnerId);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("id", spawner.getSpawnerId());
        this.messageService.sendMessage(player, "spawner_management.removed", placeholders);
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        this.handleBack(player, worldName, listPage);
    }

    private void handleBack(Player player, String worldName, int listPage) {
        FilterOption filter = FilterOption.ALL;
        SortOption sort = SortOption.DEFAULT;
        try {
            filter = this.listSubCommand.getUserFilter(player, worldName);
            sort = this.listSubCommand.getUserSort(player, worldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listSubCommand.openSpawnerListGUI(player, worldName, listPage, filter, sort);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    private boolean isBedrockPlayer(Player player) {
        if (this.plugin.getIntegrationManager() == null || this.plugin.getIntegrationManager().getFloodgateHook() == null) {
            return false;
        }
        return this.plugin.getIntegrationManager().getFloodgateHook().isBedrockPlayer(player);
    }
}

