/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.gui.main;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerOpenGUIEvent;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.gui.layout.GuiButton;
import github.nighter.smartspawner.spawner.gui.layout.GuiLayout;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuHolder;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.LootItem;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.utils.SpawnerMobHeadTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerMenuUI {
    private static final int INVENTORY_SIZE = 27;
    private static final int TICKS_PER_SECOND = 20;
    private static final Map<String, String> EMPTY_PLACEHOLDERS = Collections.emptyMap();
    private static final String LOOT_ITEM_FORMAT_KEY = "spawner_storage_item.loot_items";
    private static final String EMPTY_LOOT_MESSAGE_KEY = "spawner_storage_item.loot_items_empty";
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private String lootItemFormat;
    private String emptyLootMessage;
    private final Map<String, ItemStack> itemCache = new HashMap<String, ItemStack>();
    private final Map<String, Long> cacheTimestamps = new HashMap<String, Long>();
    private static final long CACHE_EXPIRY_TIME_MS = 30000L;

    public SpawnerMenuUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.loadConfig();
    }

    public void loadConfig() {
        this.clearCache();
        this.lootItemFormat = this.languageManager.getGuiItemName(LOOT_ITEM_FORMAT_KEY, EMPTY_PLACEHOLDERS);
        this.emptyLootMessage = this.languageManager.getGuiItemName(EMPTY_LOOT_MESSAGE_KEY, EMPTY_PLACEHOLDERS);
    }

    public void clearCache() {
        this.itemCache.clear();
        this.cacheTimestamps.clear();
    }

    public void invalidateSpawnerCache(String spawnerId) {
        this.itemCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(spawnerId + "|"));
        this.cacheTimestamps.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(spawnerId + "|"));
    }

    private boolean isCacheEntryExpired(String cacheKey) {
        Long timestamp = this.cacheTimestamps.get(cacheKey);
        return timestamp == null || System.currentTimeMillis() - timestamp > 30000L;
    }

    public void openSpawnerMenu(Player player, SpawnerData spawner, boolean refresh) {
        GuiButton expButton;
        GuiButton spawnerInfoButton;
        if (SpawnerOpenGUIEvent.getHandlerList().getRegisteredListeners().length != 0) {
            SpawnerOpenGUIEvent openEvent = new SpawnerOpenGUIEvent(player, spawner.getSpawnerLocation(), spawner.getEntityType(), spawner.getStackSize(), refresh);
            Bukkit.getPluginManager().callEvent((Event)openEvent);
            if (openEvent.isCancelled()) {
                return;
            }
        }
        Inventory menu = this.createMenu(spawner);
        GuiLayout layout = this.plugin.getGuiLayoutConfig().getCurrentMainLayout();
        ItemStack[] items = new ItemStack[27];
        GuiButton storageButton = layout.getButton("storage");
        if (storageButton != null) {
            items[storageButton.getSlot()] = this.createLootStorageItem(spawner);
        }
        if ((spawnerInfoButton = this.getSpawnerInfoButton(layout, player)) != null) {
            items[spawnerInfoButton.getSlot()] = this.createSpawnerInfoItem(player, spawner);
        }
        if ((expButton = layout.getButton("exp")) != null) {
            items[expButton.getSlot()] = this.createExpItem(spawner);
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            menu.setItem(i, items[i]);
        }
        player.openInventory(menu);
        if (!refresh) {
            player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
        }
        if (this.plugin.getSpawnerGuiViewManager().isTimerPlaceholdersEnabled()) {
            this.plugin.getSpawnerGuiViewManager().forceTimerUpdate(player, spawner);
        }
    }

    private Inventory createMenu(SpawnerData spawner) {
        String entityName = this.languageManager.getFormattedMobName(spawner.getEntityType());
        String entityNameSmallCaps = this.languageManager.getSmallCaps(this.languageManager.getFormattedMobName(spawner.getEntityType()));
        HashMap<String, String> placeholders = new HashMap<String, String>(4);
        placeholders.put("entity", entityName);
        placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", entityNameSmallCaps);
        placeholders.put("amount", String.valueOf(spawner.getStackSize()));
        String title = spawner.getStackSize() > 1 ? this.languageManager.getGuiTitle("gui_title_main.stacked_spawner", placeholders) : this.languageManager.getGuiTitle("gui_title_main.single_spawner", placeholders);
        return Bukkit.createInventory((InventoryHolder)new SpawnerMenuHolder(spawner), (int)27, (String)title);
    }

    public ItemStack createLootStorageItem(SpawnerData spawner) {
        VirtualInventory virtualInventory = spawner.getVirtualInventory();
        int currentItems = virtualInventory.getUsedSlots();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        String cacheKey = spawner.getSpawnerId() + "|storage|" + currentItems + "|" + maxSlots + "|" + virtualInventory.hashCode();
        ItemStack cachedItem = this.itemCache.get(cacheKey);
        if (cachedItem != null && !this.isCacheEntryExpired(cacheKey)) {
            return cachedItem.clone();
        }
        int percentStorage = this.calculatePercentage(currentItems, maxSlots);
        ItemStack chestItem = new ItemStack(Material.CHEST);
        ItemMeta chestMeta = chestItem.getItemMeta();
        if (chestMeta == null) {
            return chestItem;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>(4);
        placeholders.put("max_slots", this.languageManager.formatNumber(maxSlots));
        placeholders.put("current_items", String.valueOf(currentItems));
        placeholders.put("percent_storage", String.valueOf(percentStorage));
        Map<VirtualInventory.ItemSignature, Long> storedItems = virtualInventory.getConsolidatedItems();
        String lootItemsText = this.buildLootItemsText(spawner.getEntityType(), storedItems);
        placeholders.put("loot_items", lootItemsText);
        chestMeta.setDisplayName(this.languageManager.getGuiItemName("spawner_storage_item.name", placeholders));
        List<String> lore = this.languageManager.getGuiItemLoreWithMultilinePlaceholders("spawner_storage_item.lore", placeholders);
        chestMeta.setLore(lore);
        chestItem.setItemMeta(chestMeta);
        this.itemCache.put(cacheKey, chestItem.clone());
        this.cacheTimestamps.put(cacheKey, System.currentTimeMillis());
        return chestItem;
    }

    private String buildLootItemsText(EntityType entityType, Map<VirtualInventory.ItemSignature, Long> storedItems) {
        int length;
        List<Object> possibleLootItems;
        HashMap<Material, Long> materialAmountMap = new HashMap<Material, Long>();
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : storedItems.entrySet()) {
            Material material = entry.getKey().getTemplateRef().getType();
            materialAmountMap.merge(material, entry.getValue(), Long::sum);
        }
        EntityLootConfig lootConfig = this.plugin.getEntityLootRegistry().getLootConfig(entityType);
        List<Object> list = possibleLootItems = lootConfig != null ? lootConfig.getAllItems() : Collections.emptyList();
        if (possibleLootItems.isEmpty() && storedItems.isEmpty()) {
            return this.emptyLootMessage;
        }
        StringBuilder builder = new StringBuilder(Math.max(possibleLootItems.size(), storedItems.size()) * 40);
        if (!possibleLootItems.isEmpty()) {
            possibleLootItems.sort(Comparator.comparing(item -> this.languageManager.getVanillaItemName(item.getMaterial())));
            for (LootItem lootItem : possibleLootItems) {
                Material material = lootItem.getMaterial();
                long amount = materialAmountMap.getOrDefault(material, 0L);
                String materialName = this.languageManager.getVanillaItemName(material);
                String materialNameSmallCaps = this.languageManager.getSmallCaps(this.languageManager.getVanillaItemName(material));
                String formattedAmount = this.languageManager.formatNumber(amount);
                String chance = String.format("%.1f", lootItem.getChance()) + "%";
                String line = this.lootItemFormat.replace("%item_name%", materialName).replace("%\u026a\u1d1b\u1d07\u1d0d_\u0274\u1d00\u1d0d\u1d07%", materialNameSmallCaps).replace("%amount%", formattedAmount).replace("%raw_amount%", String.valueOf(amount)).replace("%chance%", chance);
                builder.append(line).append('\n');
            }
        } else if (!storedItems.isEmpty()) {
            ArrayList<Map.Entry<VirtualInventory.ItemSignature, Long>> sortedItems = new ArrayList<Map.Entry<VirtualInventory.ItemSignature, Long>>(storedItems.entrySet());
            sortedItems.sort(Comparator.comparing(e -> ((VirtualInventory.ItemSignature)e.getKey()).getMaterialName()));
            for (Map.Entry entry : sortedItems) {
                ItemStack templateItem = ((VirtualInventory.ItemSignature)entry.getKey()).getTemplateRef();
                Material material = templateItem.getType();
                long amount = (Long)entry.getValue();
                String materialName = this.languageManager.getVanillaItemName(material);
                String materialNameSmallCaps = this.languageManager.getSmallCaps(this.languageManager.getVanillaItemName(material));
                String formattedAmount = this.languageManager.formatNumber(amount);
                String line = this.lootItemFormat.replace("%item_name%", materialName).replace("%\u026a\u1d1b\u1d07\u1d0d_\u0274\u1d00\u1d0d\u1d07%", materialNameSmallCaps).replace("%amount%", formattedAmount).replace("%raw_amount%", String.valueOf(amount)).replace("%chance%", "");
                builder.append(line).append('\n');
            }
        }
        if ((length = builder.length()) > 0 && builder.charAt(length - 1) == '\n') {
            builder.setLength(length - 1);
        }
        return builder.toString();
    }

    public ItemStack createSpawnerInfoItem(Player player, SpawnerData spawner) {
        boolean hasShopPermission;
        GuiLayout layout = this.plugin.getGuiLayoutConfig().getCurrentMainLayout();
        GuiButton spawnerInfoButton = layout.getButton("spawner_info");
        EntityType entityType = spawner.getEntityType();
        int stackSize = spawner.getStackSize();
        VirtualInventory virtualInventory = spawner.getVirtualInventory();
        int currentItems = virtualInventory.getUsedSlots();
        int maxSlots = spawner.getMaxSpawnerLootSlots();
        double percentStorageDecimal = maxSlots > 0 ? (double)currentItems / (double)maxSlots * 100.0 : 0.0;
        String formattedPercentStorage = String.format("%.1f", percentStorageDecimal);
        long currentExp = spawner.getSpawnerExp().intValue();
        long maxExp = spawner.getMaxStoredExp();
        double percentExpDecimal = maxExp > 0L ? (double)currentExp / (double)maxExp * 100.0 : 0.0;
        String formattedPercentExp = String.format("%.1f", percentExpDecimal);
        boolean bl = hasShopPermission = this.plugin.hasSellIntegration() && player.hasPermission("smartspawner.sellall");
        ItemStack spawnerItem = spawnerInfoButton != null && spawnerInfoButton.getMaterial() == Material.PLAYER_HEAD ? SpawnerMobHeadTexture.getCustomHead(entityType, player) : (spawnerInfoButton != null ? new ItemStack(spawnerInfoButton.getMaterial()) : SpawnerMobHeadTexture.getCustomHead(entityType, player));
        ItemMeta spawnerMeta = spawnerItem.getItemMeta();
        if (spawnerMeta == null) {
            return spawnerItem;
        }
        String entityName = this.languageManager.getFormattedMobName(entityType);
        String entityNameSmallCaps = this.languageManager.getSmallCaps(this.languageManager.getFormattedMobName(entityType));
        HashMap<String, String> placeholders = new HashMap<String, String>(16);
        placeholders.put("entity", entityName);
        placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", entityNameSmallCaps);
        placeholders.put("entity_type", entityType.toString());
        placeholders.put("stack_size", String.valueOf(stackSize));
        placeholders.put("range", String.valueOf(spawner.getSpawnerRange()));
        long delaySeconds = spawner.getSpawnDelay() / 20L;
        placeholders.put("delay", String.valueOf(delaySeconds));
        placeholders.put("delay_raw", String.valueOf(spawner.getSpawnDelay()));
        placeholders.put("min_mobs", String.valueOf(spawner.getMinMobs()));
        placeholders.put("max_mobs", String.valueOf(spawner.getMaxMobs()));
        placeholders.put("current_items", String.valueOf(currentItems));
        placeholders.put("max_items", this.languageManager.formatNumber(maxSlots));
        placeholders.put("percentage_storage", formattedPercentStorage);
        String formattedCurrentExp = this.languageManager.formatNumber(currentExp);
        String formattedMaxExp = this.languageManager.formatNumber(maxExp);
        placeholders.put("current_exp", formattedCurrentExp);
        placeholders.put("max_exp", formattedMaxExp);
        placeholders.put("raw_current_exp", String.valueOf(currentExp));
        placeholders.put("raw_max_exp", String.valueOf(maxExp));
        placeholders.put("percentage_exp", formattedPercentExp);
        double totalSellPrice = spawner.getAccumulatedSellValue();
        placeholders.put("total_sell_price", this.languageManager.formatNumber(totalSellPrice));
        String timerValue = this.plugin.getSpawnerGuiViewManager().calculateTimerDisplay(spawner);
        placeholders.put("time", timerValue);
        spawnerMeta.setDisplayName(this.languageManager.getGuiItemName("spawner_info_item.name", placeholders));
        String loreKey = hasShopPermission ? "spawner_info_item.lore" : "spawner_info_item.lore_no_shop";
        List<String> lore = this.languageManager.getGuiItemLoreWithMultilinePlaceholders(loreKey, placeholders);
        spawnerMeta.setLore(lore);
        spawnerItem.setItemMeta(spawnerMeta);
        return spawnerItem;
    }

    public ItemStack createExpItem(SpawnerData spawner) {
        long currentExp = spawner.getSpawnerExp().intValue();
        long maxExp = spawner.getMaxStoredExp();
        int percentExp = this.calculatePercentage(currentExp, maxExp);
        String cacheKey = spawner.getSpawnerId() + "|exp|" + currentExp + "|" + maxExp;
        ItemStack cachedItem = this.itemCache.get(cacheKey);
        if (cachedItem != null && !this.isCacheEntryExpired(cacheKey)) {
            return cachedItem.clone();
        }
        ItemStack expItem = new ItemStack(Material.EXPERIENCE_BOTTLE);
        ItemMeta expMeta = expItem.getItemMeta();
        if (expMeta == null) {
            return expItem;
        }
        String formattedExp = this.languageManager.formatNumber(currentExp);
        String formattedMaxExp = this.languageManager.formatNumber(maxExp);
        HashMap<String, String> placeholders = new HashMap<String, String>(5);
        placeholders.put("current_exp", formattedExp);
        placeholders.put("raw_current_exp", String.valueOf(currentExp));
        placeholders.put("max_exp", formattedMaxExp);
        placeholders.put("percent_exp", String.valueOf(percentExp));
        placeholders.put("u_max_exp", String.valueOf(maxExp));
        expMeta.setDisplayName(this.languageManager.getGuiItemName("exp_info_item.name", placeholders));
        List<String> loreExp = this.languageManager.getGuiItemLoreAsList("exp_info_item.lore", placeholders);
        expMeta.setLore(loreExp);
        expItem.setItemMeta(expMeta);
        this.itemCache.put(cacheKey, expItem.clone());
        this.cacheTimestamps.put(cacheKey, System.currentTimeMillis());
        return expItem;
    }

    private int calculatePercentage(long current, long maximum) {
        return maximum > 0L ? (int)((double)current / (double)maximum * 100.0) : 0;
    }

    private GuiButton getSpawnerInfoButton(GuiLayout layout, Player player) {
        boolean hasShopPermission;
        boolean bl = hasShopPermission = this.plugin.hasSellIntegration() && player.hasPermission("smartspawner.sellall");
        if (hasShopPermission) {
            GuiButton shopButton = layout.getButton("spawner_info_with_shop");
            if (shopButton != null) {
                return shopButton;
            }
        } else {
            GuiButton noShopButton = layout.getButton("spawner_info_no_shop");
            if (noShopButton != null) {
                return noShopButton;
            }
        }
        return layout.getButton("spawner_info");
    }
}

