/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.loot;

import java.util.Random;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class LootItem {
    private final Material material;
    private final int minAmount;
    private final int maxAmount;
    private final double chance;
    private final Integer minDurability;
    private final Integer maxDurability;
    private final PotionType potionType;
    private final double sellPrice;

    public LootItem(Material material, int minAmount, int maxAmount, double chance, Integer minDurability, Integer maxDurability, PotionType potionType, double sellPrice) {
        this.material = material;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.chance = chance;
        this.minDurability = minDurability;
        this.maxDurability = maxDurability;
        this.potionType = potionType;
        this.sellPrice = sellPrice;
    }

    public ItemStack createItemStack(Random random) {
        ItemMeta meta;
        if (this.material == null) {
            return null;
        }
        ItemStack item = new ItemStack(this.material, 1);
        if (this.minDurability != null && this.maxDurability != null && (meta = item.getItemMeta()) instanceof Damageable) {
            int durability = random.nextInt(this.maxDurability - this.minDurability + 1) + this.minDurability;
            ((Damageable)meta).setDamage(durability);
            item.setItemMeta(meta);
        }
        if (this.material == Material.TIPPED_ARROW && this.potionType != null && (meta = (PotionMeta)item.getItemMeta()) != null) {
            meta.setBasePotionType(this.potionType);
            item.setItemMeta(meta);
        }
        return item;
    }

    public int generateAmount(Random random) {
        return random.nextInt(this.maxAmount - this.minAmount + 1) + this.minAmount;
    }

    public boolean isAvailable() {
        return this.material != null;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getMinAmount() {
        return this.minAmount;
    }

    @Generated
    public int getMaxAmount() {
        return this.maxAmount;
    }

    @Generated
    public double getChance() {
        return this.chance;
    }

    @Generated
    public Integer getMinDurability() {
        return this.minDurability;
    }

    @Generated
    public Integer getMaxDurability() {
        return this.maxDurability;
    }

    @Generated
    public PotionType getPotionType() {
        return this.potionType;
    }

    @Generated
    public double getSellPrice() {
        return this.sellPrice;
    }
}

