/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.sell;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.api.events.SpawnerSellEvent;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import github.nighter.smartspawner.spawner.sell.SellResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class SpawnerSellManager {
    private final SmartSpawner plugin;
    private final MessageService messageService;
    private final SpawnerGuiViewManager spawnerGuiViewManager;

    public SpawnerSellManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.spawnerGuiViewManager = plugin.getSpawnerGuiViewManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sellAllItems(Player player, SpawnerData spawner) {
        boolean lockAcquired = spawner.getLock().tryLock();
        if (!lockAcquired) {
            this.messageService.sendMessage(player, "sale_failed");
            return;
        }
        try {
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            if (virtualInv.getUsedSlots() == 0) {
                this.messageService.sendMessage(player, "no_items");
                return;
            }
            if (spawner.isSellValueDirty()) {
                spawner.recalculateSellValue();
            }
            Map<VirtualInventory.ItemSignature, Long> consolidatedItems = virtualInv.getConsolidatedItems();
            Scheduler.runTaskAsync(() -> {
                SellResult result = this.calculateSellValue(consolidatedItems, spawner);
                spawner.setLastSellResult(result);
                Scheduler.runLocationTask(spawner.getSpawnerLocation(), () -> this.processSellResult(player, spawner, result));
            });
        }
        finally {
            spawner.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSellResult(Player player, SpawnerData spawner, SellResult sellResult) {
        boolean finalLockAcquired = spawner.getLock().tryLock();
        if (!finalLockAcquired) {
            this.messageService.sendMessage(player, "sale_failed");
            return;
        }
        try {
            boolean depositSuccess;
            VirtualInventory virtualInv = spawner.getVirtualInventory();
            if (!sellResult.isSuccessful()) {
                this.messageService.sendMessage(player, "no_sellable_items");
                return;
            }
            if (!this.validateItemsStillExist(virtualInv, sellResult)) {
                this.messageService.sendMessage(player, "sale_failed");
                return;
            }
            double amount = sellResult.getTotalValue();
            if (SpawnerSellEvent.getHandlerList().getRegisteredListeners().length != 0) {
                SpawnerSellEvent event = new SpawnerSellEvent(player, spawner.getSpawnerLocation(), sellResult.getItemsToRemove(), amount);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                if (event.getMoneyAmount() >= 0.0) {
                    amount = event.getMoneyAmount();
                }
            }
            if (!(depositSuccess = this.plugin.getItemPriceManager().deposit(amount, (OfflinePlayer)player))) {
                this.messageService.sendMessage(player, "sell_failed");
                return;
            }
            boolean itemsRemoved = spawner.removeItemsAndUpdateSellValue(sellResult.getItemsToRemove());
            if (!itemsRemoved) {
                this.plugin.getLogger().warning("Critical: Could not remove all items after depositing money for player " + player.getName() + " at spawner " + spawner.getSpawnerId() + ". Possible exploit detected.");
            }
            spawner.updateHologramData();
            if (spawner.getIsAtCapacity().booleanValue() && virtualInv.getUsedSlots() < spawner.getMaxSpawnerLootSlots()) {
                spawner.setIsAtCapacity(false);
            }
            this.spawnerGuiViewManager.updateSpawnerMenuViewers(spawner);
            player.closeInventory();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount", this.plugin.getLanguageManager().formatNumber(sellResult.getItemsSold()));
            placeholders.put("price", this.plugin.getLanguageManager().formatNumber(amount));
            this.messageService.sendMessage(player, "sell_success", placeholders);
            this.plugin.getSpawnerManager().markSpawnerModified(spawner.getSpawnerId());
            spawner.markLastSellAsProcessed();
        }
        finally {
            spawner.getLock().unlock();
        }
    }

    private SellResult calculateSellValue(Map<VirtualInventory.ItemSignature, Long> consolidatedItems, SpawnerData spawner) {
        double totalValue = spawner.getAccumulatedSellValue();
        long totalItemsSold = 0L;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : consolidatedItems.entrySet()) {
            int stackSize;
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            totalItemsSold += amount;
            for (long remainingAmount = amount; remainingAmount > 0L; remainingAmount -= (long)stackSize) {
                ItemStack stackToRemove = template.clone();
                stackSize = (int)Math.min(remainingAmount, (long)template.getMaxStackSize());
                stackToRemove.setAmount(stackSize);
                itemsToRemove.add(stackToRemove);
            }
        }
        return new SellResult(totalValue, totalItemsSold, itemsToRemove);
    }

    private boolean validateItemsStillExist(VirtualInventory virtualInv, SellResult sellResult) {
        Map<VirtualInventory.ItemSignature, Long> consolidatedItems = virtualInv.getConsolidatedItems();
        HashMap<VirtualInventory.ItemSignature, Long> itemsToValidate = new HashMap<VirtualInventory.ItemSignature, Long>();
        for (ItemStack itemStack : sellResult.getItemsToRemove()) {
            if (itemStack == null || itemStack.getAmount() <= 0) continue;
            VirtualInventory.ItemSignature sig = new VirtualInventory.ItemSignature(itemStack);
            itemsToValidate.merge(sig, Long.valueOf(itemStack.getAmount()), Long::sum);
        }
        for (Map.Entry entry : itemsToValidate.entrySet()) {
            VirtualInventory.ItemSignature signature = (VirtualInventory.ItemSignature)entry.getKey();
            long requiredAmount = (Long)entry.getValue();
            long availableAmount = consolidatedItems.getOrDefault(signature, 0L);
            if (availableAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }
}

