/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.nms;

import github.nighter.smartspawner.SmartSpawner;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class VersionInitializer {
    private final SmartSpawner plugin;
    private final String serverVersion;
    private final String basePackage = "github.nighter.smartspawner";
    private final String[][] components = new String[][]{{"Materials", "MaterialInitializer"}, {"Particles", "ParticleInitializer"}, {"Textures", "TextureInitializer"}, {"Spawners", "SpawnerInitializer"}};
    private final List<Version> supportedVersions = Arrays.asList(new Version(1, 21, 6, "v1_21_6"), new Version(1, 21, 4, "v1_21_4"), new Version(1, 21, 0, "v1_21"));

    public VersionInitializer(SmartSpawner plugin) {
        this.plugin = plugin;
        this.serverVersion = Bukkit.getServer().getBukkitVersion();
    }

    public void initialize() {
        String versionPath = this.determineVersionPath();
        if (versionPath == null) {
            throw new IllegalStateException("Unsupported server version: " + this.serverVersion);
        }
        this.plugin.debug("Detected server version: " + this.serverVersion + ", using version path: " + versionPath);
        this.initializeComponentsForVersion(versionPath);
    }

    private String determineVersionPath() {
        this.plugin.debug("Checking server version: " + this.serverVersion);
        Version currentVersion = this.parseVersion(this.serverVersion);
        if (currentVersion == null) {
            this.plugin.debug("Failed to parse version: " + this.serverVersion);
            return null;
        }
        for (Version supportedVersion : this.supportedVersions) {
            if (!currentVersion.isGreaterThanOrEqualTo(supportedVersion)) continue;
            this.plugin.debug("Matched version " + String.valueOf(currentVersion) + " -> " + supportedVersion.packageName);
            return supportedVersion.packageName;
        }
        this.plugin.debug("No matching version found for: " + this.serverVersion);
        return null;
    }

    private Version parseVersion(String versionString) {
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.find()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
            return new Version(major, minor, patch, null);
        }
        return null;
    }

    private void initializeComponentsForVersion(String versionPath) {
        for (String[] component : this.components) {
            this.initializeComponent(component[0], component[1], versionPath);
        }
    }

    private void initializeComponent(String componentName, String initializerClass, String versionPath) {
        try {
            String className = String.format("%s.%s.%s", "github.nighter.smartspawner", versionPath, initializerClass);
            Class<?> clazz = Class.forName(className);
            Method initMethod = clazz.getMethod("init", new Class[0]);
            initMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to initialize %s for version %s: %s", componentName, this.serverVersion, e.getMessage()));
            this.plugin.debug("Stack trace for " + componentName + " initialization failure: " + e.toString());
            throw new RuntimeException("Failed to initialize " + componentName, e);
        }
    }

    private static class Version {
        final int major;
        final int minor;
        final int patch;
        final String packageName;

        Version(int major, int minor, int patch, String packageName) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.packageName = packageName;
        }

        boolean isGreaterThanOrEqualTo(Version other) {
            if (this.major != other.major) {
                return this.major >= other.major;
            }
            if (this.minor != other.minor) {
                return this.minor >= other.minor;
            }
            return this.patch >= other.patch;
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.patch;
        }
    }
}

