/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.item;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.spawner.loot.EntityLootConfig;
import github.nighter.smartspawner.spawner.loot.EntityLootRegistry;
import github.nighter.smartspawner.spawner.loot.LootItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SpawnerItemFactory {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private EntityLootRegistry entityLootRegistry;
    private static NamespacedKey VANILLA_SPAWNER_KEY;
    private final Map<EntityType, ItemStack> spawnerItemCache = new HashMap<EntityType, ItemStack>();
    private final Map<EntityType, Long> cacheTimestamps = new HashMap<EntityType, Long>();
    private static final long CACHE_EXPIRY_TIME_MS;
    private static final int MAX_CACHE_SIZE = 100;
    private long lastCacheCleanup = System.currentTimeMillis();

    public SpawnerItemFactory(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.entityLootRegistry = plugin.getEntityLootRegistry();
        VANILLA_SPAWNER_KEY = new NamespacedKey((Plugin)plugin, "vanilla_spawner");
    }

    public void reload() {
        this.entityLootRegistry = this.plugin.getEntityLootRegistry();
        this.clearAllCaches();
    }

    public void clearAllCaches() {
        this.spawnerItemCache.clear();
        this.cacheTimestamps.clear();
        this.lastCacheCleanup = System.currentTimeMillis();
    }

    private void cleanupCacheIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCacheCleanup < TimeUnit.MINUTES.toMillis(1L)) {
            return;
        }
        this.lastCacheCleanup = currentTime;
        Iterator<Map.Entry<EntityType, Long>> iterator = this.cacheTimestamps.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntityType, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= CACHE_EXPIRY_TIME_MS) continue;
            EntityType type = entry.getKey();
            this.spawnerItemCache.remove(type);
            iterator.remove();
        }
    }

    public ItemStack createSpawnerItem(EntityType entityType) {
        return this.createSpawnerItem(entityType, 1);
    }

    public ItemStack createSpawnerItem(EntityType entityType, int amount) {
        ItemStack cachedItem;
        this.cleanupCacheIfNeeded();
        if (amount == 1 && (cachedItem = this.spawnerItemCache.get(entityType)) != null) {
            return cachedItem.clone();
        }
        ItemStack spawner = new ItemStack(Material.SPAWNER, amount);
        ItemMeta meta = spawner.getItemMeta();
        if (meta != null && entityType != null && entityType != EntityType.UNKNOWN) {
            BlockStateMeta blockMeta;
            BlockState blockState;
            if (meta instanceof BlockStateMeta && (blockState = (blockMeta = (BlockStateMeta)meta).getBlockState()) instanceof CreatureSpawner) {
                CreatureSpawner cs = (CreatureSpawner)blockState;
                cs.setSpawnedType(entityType);
                blockMeta.setBlockState((BlockState)cs);
            }
            String entityTypeName = this.languageManager.getFormattedMobName(entityType);
            String entityTypeNameSmallCaps = this.languageManager.getSmallCaps(entityTypeName);
            EntityLootConfig lootConfig = this.entityLootRegistry.getLootConfig(entityType);
            List<Object> lootItems = lootConfig != null ? lootConfig.getAllItems() : Collections.emptyList();
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("entity", entityTypeName);
            placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", entityTypeNameSmallCaps);
            placeholders.put("exp", String.valueOf(lootConfig != null ? lootConfig.getExperience() : 0));
            ArrayList sortedLootItems = new ArrayList(lootItems);
            sortedLootItems.sort(Comparator.comparing(item -> item.getMaterial().name()));
            if (!sortedLootItems.isEmpty()) {
                String lootFormat = this.languageManager.getItemName("custom_item.spawner.loot_items", placeholders);
                StringBuilder lootItemsBuilder = new StringBuilder();
                for (LootItem item2 : sortedLootItems) {
                    String itemName = this.languageManager.getVanillaItemName(item2.getMaterial());
                    String itemNameSmallCaps = this.languageManager.getSmallCaps(itemName);
                    String amountRange = item2.getMinAmount() == item2.getMaxAmount() ? String.valueOf(item2.getMinAmount()) : item2.getMinAmount() + "-" + item2.getMaxAmount();
                    String chance = String.format("%.1f", item2.getChance());
                    HashMap<String, String> itemPlaceholders = new HashMap<String, String>(placeholders);
                    itemPlaceholders.put("item_name", itemName);
                    itemPlaceholders.put("\u026a\u1d1b\u1d07\u1d0d_\u0274\u1d00\u1d0d\u1d07", itemNameSmallCaps);
                    itemPlaceholders.put("amount", amountRange);
                    itemPlaceholders.put("chance", chance);
                    String formattedItem = this.languageManager.applyPlaceholdersAndColors(lootFormat, itemPlaceholders);
                    lootItemsBuilder.append(formattedItem).append("\n");
                }
                if (!lootItemsBuilder.isEmpty()) {
                    lootItemsBuilder.setLength(lootItemsBuilder.length() - 1);
                }
                placeholders.put("loot_items", lootItemsBuilder.toString());
            } else {
                placeholders.put("loot_items", this.languageManager.getItemName("custom_item.spawner.loot_items_empty", placeholders));
            }
            String displayName = this.languageManager.getItemName("custom_item.spawner.name", placeholders);
            meta.setDisplayName(displayName);
            List<String> lore = this.languageManager.getItemLoreWithMultilinePlaceholders("custom_item.spawner.lore", placeholders);
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore);
            }
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
            spawner.setItemMeta(meta);
        }
        if (amount == 1) {
            this.spawnerItemCache.put(entityType, spawner.clone());
            this.cacheTimestamps.put(entityType, System.currentTimeMillis());
            if (this.spawnerItemCache.size() > 100) {
                EntityType oldestEntity = null;
                long oldestTime = Long.MAX_VALUE;
                for (Map.Entry<EntityType, Long> entry : this.cacheTimestamps.entrySet()) {
                    if (entry.getValue() >= oldestTime) continue;
                    oldestTime = entry.getValue();
                    oldestEntity = entry.getKey();
                }
                if (oldestEntity != null) {
                    this.spawnerItemCache.remove(oldestEntity);
                    this.cacheTimestamps.remove(oldestEntity);
                }
            }
        }
        return spawner;
    }

    public ItemStack createVanillaSpawnerItem(EntityType entityType) {
        return this.createVanillaSpawnerItem(entityType, 1);
    }

    public ItemStack createVanillaSpawnerItem(EntityType entityType, int amount) {
        ItemStack spawner = new ItemStack(Material.SPAWNER, amount);
        ItemMeta meta = spawner.getItemMeta();
        if (meta != null && entityType != null && entityType != EntityType.UNKNOWN) {
            List<String> lore;
            BlockStateMeta blockMeta;
            BlockState blockState;
            if (meta instanceof BlockStateMeta && (blockState = (blockMeta = (BlockStateMeta)meta).getBlockState()) instanceof CreatureSpawner) {
                CreatureSpawner cs = (CreatureSpawner)blockState;
                cs.setSpawnedType(entityType);
                blockMeta.setBlockState((BlockState)cs);
            }
            String entityTypeName = this.languageManager.getFormattedMobName(entityType);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("entity", entityTypeName);
            placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", this.languageManager.getSmallCaps(entityTypeName));
            String displayName = this.languageManager.getItemName("custom_item.vanilla_spawner.name", placeholders);
            if (displayName != null && !displayName.isEmpty() && !displayName.equals("custom_item.vanilla_spawner.name")) {
                meta.setDisplayName(displayName);
            }
            if ((lore = this.languageManager.getItemLoreWithMultilinePlaceholders("custom_item.vanilla_spawner.lore", placeholders)) != null && !lore.isEmpty()) {
                meta.setLore(lore);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_UNBREAKABLE});
            }
            meta.getPersistentDataContainer().set(VANILLA_SPAWNER_KEY, PersistentDataType.BOOLEAN, (Object)true);
            spawner.setItemMeta(meta);
        }
        return spawner;
    }

    static {
        CACHE_EXPIRY_TIME_MS = TimeUnit.MINUTES.toMillis(30L);
    }
}

