/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.spawner.lootgen;

import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RangeMath {
    private final List<SpawnerData> spawners;
    private final RangePlayerWrapper[] rangePlayers;
    private final boolean[] activeSpawners;

    public RangeMath(List<Player> players, List<SpawnerData> spawners) {
        this.spawners = spawners;
        this.rangePlayers = new RangePlayerWrapper[players.size()];
        this.activeSpawners = new boolean[spawners.size()];
        for (int i = 0; i < players.size(); ++i) {
            Player p = players.get(i);
            Location loc = p.getLocation();
            boolean conditions = p.isConnected() && !p.isDead() && p.getGameMode() != GameMode.SPECTATOR;
            this.rangePlayers[i] = new RangePlayerWrapper(loc.getWorld() != null ? loc.getWorld().getUID() : null, loc.getX(), loc.getY(), loc.getZ(), conditions);
        }
    }

    public void updateActiveSpawners() {
        for (int i = 0; i < this.spawners.size(); ++i) {
            World locWorld;
            SpawnerData s = this.spawners.get(i);
            Location spawnerLoc = s.getSpawnerLocation();
            if (spawnerLoc == null || (locWorld = spawnerLoc.getWorld()) == null) continue;
            UUID worldUID = locWorld.getUID();
            double rangeSq = s.getSpawnerRange() * s.getSpawnerRange();
            boolean playerFound = false;
            for (RangePlayerWrapper p : this.rangePlayers) {
                if (!p.spawnConditions || p.worldUID == null || !worldUID.equals(p.worldUID) || !(p.distanceSquared(spawnerLoc) <= rangeSq)) continue;
                playerFound = true;
                break;
            }
            this.activeSpawners[i] = playerFound;
        }
    }

    @Generated
    public boolean[] getActiveSpawners() {
        return this.activeSpawners;
    }

    private record RangePlayerWrapper(UUID worldUID, double x, double y, double z, boolean spawnConditions) {
        double distanceSquared(Location loc2) {
            double dx = this.x - loc2.getX();
            double dy = this.y - loc2.getY();
            double dz = this.z - loc2.getZ();
            return dx * dx + dy * dy + dz * dz;
        }
    }
}

