/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.updates;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.updates.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuiLayoutUpdater {
    private static final String GUI_LAYOUT_VERSION_KEY = "gui_layout_version";
    private static final String GUI_LAYOUTS_DIR = "gui_layouts";
    private static final String[] LAYOUT_FILES = new String[]{"storage_gui.yml", "main_gui.yml"};
    private static final String[] LAYOUT_NAMES = new String[]{"default", "DonutSMP"};
    private final SmartSpawner plugin;
    private final String currentVersion;

    public GuiLayoutUpdater(SmartSpawner plugin) {
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkAndUpdateLayouts() {
        File layoutsDir = new File(this.plugin.getDataFolder(), GUI_LAYOUTS_DIR);
        if (!layoutsDir.exists()) {
            layoutsDir.mkdirs();
        }
        for (String layoutName : LAYOUT_NAMES) {
            File layoutDir = new File(layoutsDir, layoutName);
            if (!layoutDir.exists()) {
                layoutDir.mkdirs();
            }
            for (String fileName : LAYOUT_FILES) {
                this.checkAndUpdateLayoutFile(layoutDir, layoutName, fileName);
            }
        }
    }

    private void checkAndUpdateLayoutFile(File layoutDir, String layoutName, String fileName) {
        Version pluginVersion;
        File layoutFile = new File(layoutDir, fileName);
        if (!layoutFile.exists()) {
            this.createDefaultLayoutWithHeader(layoutDir, layoutName, fileName);
            return;
        }
        YamlConfiguration currentLayout = YamlConfiguration.loadConfiguration((File)layoutFile);
        String layoutVersionStr = currentLayout.getString(GUI_LAYOUT_VERSION_KEY, "0.0.0");
        Version layoutVersion = new Version(layoutVersionStr);
        if (layoutVersion.compareTo(pluginVersion = new Version(this.currentVersion)) >= 0) {
            return;
        }
        this.plugin.getLogger().info("Updating GUI layout " + layoutName + "/" + fileName + " from version " + layoutVersionStr + " to " + this.currentVersion);
        try {
            Map<String, Object> userValues = this.flattenConfig((ConfigurationSection)currentLayout);
            File tempFile = new File(layoutDir, fileName + ".new");
            this.createDefaultLayoutWithHeader(layoutDir, layoutName, fileName, tempFile);
            YamlConfiguration newLayout = YamlConfiguration.loadConfiguration((File)tempFile);
            newLayout.set(GUI_LAYOUT_VERSION_KEY, (Object)this.currentVersion);
            boolean layoutDiffers = this.hasLayoutDifferences(userValues, (FileConfiguration)newLayout);
            if (layoutDiffers) {
                File backupFile = new File(layoutDir, fileName.replace(".yml", "_backup_" + layoutVersionStr + ".yml"));
                Files.copy(layoutFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.plugin.getLogger().info("GUI layout backup created at " + layoutName + "/" + backupFile.getName());
            } else {
                this.plugin.debug("No significant GUI layout changes detected for " + layoutName + "/" + fileName + ", skipping backup creation");
            }
            this.applyUserValues((FileConfiguration)newLayout, userValues);
            newLayout.save(layoutFile);
            tempFile.delete();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to update GUI layout " + layoutName + "/" + fileName + ": " + e.getMessage(), e);
        }
    }

    private boolean hasLayoutDifferences(Map<String, Object> userValues, FileConfiguration newLayout) {
        Map<String, Object> newLayoutMap = this.flattenConfig((ConfigurationSection)newLayout);
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object oldValue = entry.getValue();
            if (path.equals(GUI_LAYOUT_VERSION_KEY)) continue;
            if (!newLayout.contains(path)) {
                return true;
            }
            Object newDefaultValue = newLayout.get(path);
            if (newDefaultValue == null || newDefaultValue.equals(oldValue)) continue;
            return true;
        }
        for (String path : newLayoutMap.keySet()) {
            if (path.equals(GUI_LAYOUT_VERSION_KEY) || userValues.containsKey(path)) continue;
            return true;
        }
        return false;
    }

    private void createDefaultLayoutWithHeader(File layoutDir, String layoutName, String fileName) {
        this.createDefaultLayoutWithHeader(layoutDir, layoutName, fileName, new File(layoutDir, fileName));
    }

    private void createDefaultLayoutWithHeader(File layoutDir, String layoutName, String fileName, File destinationFile) {
        try {
            File parentDir = destinationFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            String resourcePath = "gui_layouts/" + layoutName + "/" + fileName;
            try (InputStream in = this.plugin.getResource(resourcePath);){
                if (in != null) {
                    List<String> defaultLines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().toList();
                    ArrayList<Object> newLines = new ArrayList<Object>();
                    newLines.add("# GUI Layout version - Do not modify this value");
                    newLines.add("gui_layout_version: " + this.currentVersion);
                    newLines.add("");
                    newLines.addAll(defaultLines);
                    Files.write(destinationFile.toPath(), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
                } else {
                    this.plugin.getLogger().warning("Default GUI layout " + resourcePath + " not found in the plugin's resources.");
                    destinationFile.createNewFile();
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create default GUI layout with header for " + layoutName + "/" + fileName + ": " + e.getMessage(), e);
        }
    }

    private Map<String, Object> flattenConfig(ConfigurationSection config) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : config.getKeys(true)) {
            if (config.isConfigurationSection(key)) continue;
            result.put(key, config.get(key));
        }
        return result;
    }

    private void applyUserValues(FileConfiguration newLayout, Map<String, Object> userValues) {
        for (Map.Entry<String, Object> entry : userValues.entrySet()) {
            String path = entry.getKey();
            Object value = entry.getValue();
            if (path.equals(GUI_LAYOUT_VERSION_KEY)) continue;
            if (newLayout.contains(path)) {
                newLayout.set(path, value);
                continue;
            }
            this.plugin.getLogger().warning("GUI layout path '" + path + "' from old layout no longer exists in new layout");
        }
    }
}

