/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class GlobalEventHandlers
implements Listener {
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private static final int CHECK_RADIUS = 4;

    public GlobalEventHandlers(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(SpawnerSpawnEvent event) {
        if (event.getSpawner() == null) {
            return;
        }
        SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(event.getSpawner().getLocation());
        if (spawner != null && spawner.getSpawnerActive().booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.CHICKEN) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = null;
        if (event instanceof CreatureSpawnEvent) {
            spawnReason = ((CreatureSpawnEvent)event).getSpawnReason();
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.BREEDING) {
            return;
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.EGG) {
            return;
        }
        if (spawnReason == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
            return;
        }
        if (this.isNearZombieSpawner(entity.getLocation())) {
            event.setCancelled(true);
            this.plugin.debug("Prevented chicken spawn near zombie spawner at " + String.valueOf(entity.getLocation()));
        }
    }

    private boolean isNearZombieSpawner(Location location) {
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    Location checkLoc = new Location(location.getWorld(), (double)(location.getBlockX() + x), (double)(location.getBlockY() + y), (double)(location.getBlockZ() + z));
                    SpawnerData spawner = this.spawnerManager.getSpawnerByLocation(checkLoc);
                    if (spawner == null || spawner.getEntityType() != EntityType.ZOMBIE && spawner.getEntityType() != EntityType.ZOMBIFIED_PIGLIN) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        if (this.plugin.getShopIntegrationManager().hasShopIntegration()) {
            return;
        }
        String pluginName = event.getPlugin().getName();
        if (pluginName.equalsIgnoreCase("EconomyShopGUI") || pluginName.equalsIgnoreCase("EconomyShopGUI-Premium")) {
            Scheduler.runTaskLater(() -> this.plugin.getShopIntegrationManager().reload(), 20L);
        }
    }
}

