/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner;

import github.nighter.smartspawner.SmartSpawner;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class Scheduler {
    private static final Plugin plugin = SmartSpawner.getInstance();
    private static final boolean isFolia;

    public static Task runTask(Runnable runnable) {
        if (isFolia) {
            try {
                ScheduledTask task = Bukkit.getGlobalRegionScheduler().run(plugin, scheduledTask -> runnable.run());
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTask(plugin, runnable));
    }

    public static Task runTaskAsync(Runnable runnable) {
        if (isFolia) {
            try {
                ScheduledTask task = Bukkit.getAsyncScheduler().runNow(plugin, scheduledTask -> runnable.run());
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling async task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTaskAsynchronously(plugin, runnable));
    }

    public static Task runTaskLater(Runnable runnable, long delayTicks) {
        if (isFolia) {
            try {
                ScheduledTask task = Bukkit.getGlobalRegionScheduler().runDelayed(plugin, scheduledTask -> runnable.run(), delayTicks < 1L ? 1L : delayTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling delayed task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTaskLater(plugin, runnable, delayTicks));
    }

    public static Task runTaskLaterAsync(Runnable runnable, long delayTicks) {
        if (isFolia) {
            try {
                long delayMs = delayTicks * 50L;
                ScheduledTask task = Bukkit.getAsyncScheduler().runDelayed(plugin, scheduledTask -> runnable.run(), delayMs, TimeUnit.MILLISECONDS);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling delayed async task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, runnable, delayTicks));
    }

    public static Task runTaskTimer(Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia) {
            try {
                ScheduledTask task = Bukkit.getGlobalRegionScheduler().runAtFixedRate(plugin, scheduledTask -> runnable.run(), delayTicks < 1L ? 1L : delayTicks, periodTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling timer task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTaskTimer(plugin, runnable, delayTicks, periodTicks));
    }

    public static Task runTaskTimerAsync(Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia) {
            try {
                long delayMs = delayTicks * 50L;
                long periodMs = periodTicks * 50L;
                ScheduledTask task = Bukkit.getAsyncScheduler().runAtFixedRate(plugin, scheduledTask -> runnable.run(), delayMs, periodMs, TimeUnit.MILLISECONDS);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.SEVERE, "Error scheduling timer async task in Folia", e);
                return new Task(null);
            }
        }
        return new Task(Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, runnable, delayTicks, periodTicks));
    }

    public static Task runEntityTask(Entity entity, Runnable runnable) {
        if (isFolia && entity != null) {
            try {
                ScheduledTask task = entity.getScheduler().run(plugin, scheduledTask -> runnable.run(), null);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling entity task in Folia, falling back to global scheduler", e);
                return Scheduler.runTask(runnable);
            }
        }
        return Scheduler.runTask(runnable);
    }

    public static Task runEntityTaskLater(Entity entity, Runnable runnable, long delayTicks) {
        if (isFolia && entity != null) {
            try {
                ScheduledTask task = entity.getScheduler().runDelayed(plugin, scheduledTask -> runnable.run(), null, delayTicks < 1L ? 1L : delayTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling delayed entity task in Folia, falling back to global scheduler", e);
                return Scheduler.runTaskLater(runnable, delayTicks);
            }
        }
        return Scheduler.runTaskLater(runnable, delayTicks);
    }

    public static Task runEntityTaskTimer(Entity entity, Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia && entity != null) {
            try {
                ScheduledTask task = entity.getScheduler().runAtFixedRate(plugin, scheduledTask -> runnable.run(), null, delayTicks < 1L ? 1L : delayTicks, periodTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling timer entity task in Folia, falling back to global scheduler", e);
                return Scheduler.runTaskTimer(runnable, delayTicks, periodTicks);
            }
        }
        return Scheduler.runTaskTimer(runnable, delayTicks, periodTicks);
    }

    public static Task runLocationTask(Location location, Runnable runnable) {
        if (isFolia && location != null && location.getWorld() != null) {
            try {
                ScheduledTask task = Bukkit.getRegionScheduler().run(plugin, location, scheduledTask -> runnable.run());
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling location task in Folia, falling back to global scheduler", e);
                return Scheduler.runTask(runnable);
            }
        }
        return Scheduler.runTask(runnable);
    }

    public static Task runLocationTaskLater(Location location, Runnable runnable, long delayTicks) {
        if (isFolia && location != null && location.getWorld() != null) {
            try {
                ScheduledTask task = Bukkit.getRegionScheduler().runDelayed(plugin, location, scheduledTask -> runnable.run(), delayTicks < 1L ? 1L : delayTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling delayed location task in Folia, falling back to global scheduler", e);
                return Scheduler.runTaskLater(runnable, delayTicks);
            }
        }
        return Scheduler.runTaskLater(runnable, delayTicks);
    }

    public static Task runLocationTaskTimer(Location location, Runnable runnable, long delayTicks, long periodTicks) {
        if (isFolia && location != null && location.getWorld() != null) {
            try {
                ScheduledTask task = Bukkit.getRegionScheduler().runAtFixedRate(plugin, location, scheduledTask -> runnable.run(), delayTicks < 1L ? 1L : delayTicks, periodTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling timer location task in Folia, falling back to global scheduler", e);
                return Scheduler.runTaskTimer(runnable, delayTicks, periodTicks);
            }
        }
        return Scheduler.runTaskTimer(runnable, delayTicks, periodTicks);
    }

    public static Task runWorldTask(Location location, Runnable runnable) {
        if (isFolia && location != null && location.getWorld() != null) {
            try {
                ScheduledTask task = Bukkit.getRegionScheduler().run(plugin, location, scheduledTask -> runnable.run());
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling world task in Folia, falling back to global scheduler", e);
                return Scheduler.runTask(runnable);
            }
        }
        return Scheduler.runTask(runnable);
    }

    public static Task runWorldTaskLater(Location location, Runnable runnable, long delayTicks) {
        if (isFolia && location != null && location.getWorld() != null) {
            try {
                ScheduledTask task = Bukkit.getRegionScheduler().runDelayed(plugin, location, scheduledTask -> runnable.run(), delayTicks < 1L ? 1L : delayTicks);
                return new Task(task);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Error scheduling delayed world task in Folia, falling back to global scheduler", e);
                return Scheduler.runTaskLater(runnable, delayTicks);
            }
        }
        return Scheduler.runTaskLater(runnable, delayTicks);
    }

    public static <T> CompletableFuture<T> supplySync(Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        try {
            if (isFolia) {
                Bukkit.getGlobalRegionScheduler().run(plugin, task -> {
                    try {
                        future.complete(supplier.get());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        plugin.getLogger().log(Level.SEVERE, "Error while executing sync task", t);
                    }
                });
            } else {
                Bukkit.getScheduler().runTask(plugin, () -> {
                    try {
                        future.complete(supplier.get());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        plugin.getLogger().log(Level.SEVERE, "Error while executing sync task", t);
                    }
                });
            }
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public static <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        try {
            if (isFolia) {
                Bukkit.getAsyncScheduler().runNow(plugin, task -> {
                    try {
                        future.complete(supplier.get());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        plugin.getLogger().log(Level.SEVERE, "Error while executing async task", t);
                    }
                });
            } else {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
                    try {
                        future.complete(supplier.get());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                        plugin.getLogger().log(Level.SEVERE, "Error while executing async task", t);
                    }
                });
            }
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    static {
        boolean foliaDetected = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            foliaDetected = true;
            plugin.getLogger().info("Folia detected! Using region-based threading system.");
        }
        catch (ClassNotFoundException e) {
            plugin.getLogger().info("Running on standard Paper server.");
        }
        isFolia = foliaDetected;
    }

    public static class Task {
        private final Object task;

        Task(Object task) {
            this.task = task;
        }

        public void cancel() {
            if (this.task == null) {
                return;
            }
            try {
                if (isFolia) {
                    if (this.task instanceof ScheduledTask) {
                        ((ScheduledTask)this.task).cancel();
                    }
                } else if (this.task instanceof BukkitTask) {
                    ((BukkitTask)this.task).cancel();
                }
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "Failed to cancel task", e);
            }
        }

        public Object getTask() {
            return this.task;
        }

        public boolean isCancelled() {
            if (this.task == null) {
                return true;
            }
            try {
                if (isFolia) {
                    if (this.task instanceof ScheduledTask) {
                        return ((ScheduledTask)this.task).isCancelled();
                    }
                } else if (this.task instanceof BukkitTask) {
                    return ((BukkitTask)this.task).isCancelled();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
    }
}

