/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner;

import com.palmergames.bukkit.towny.TownyAPI;
import fr.xyness.SCS.API.SimpleClaimSystemAPI_Provider;
import fr.xyness.SCS.SimpleClaimSystem;
import github.nighter.smartspawner.GlobalEventHandlers;
import github.nighter.smartspawner.api.SmartSpawnerAPI;
import github.nighter.smartspawner.api.SmartSpawnerAPIImpl;
import github.nighter.smartspawner.api.SmartSpawnerPlugin;
import github.nighter.smartspawner.bstats.Metrics;
import github.nighter.smartspawner.commands.CommandHandler;
import github.nighter.smartspawner.commands.give.GiveCommand;
import github.nighter.smartspawner.commands.hologram.HologramCommand;
import github.nighter.smartspawner.commands.list.ListCommand;
import github.nighter.smartspawner.commands.list.SpawnerListGUI;
import github.nighter.smartspawner.commands.list.UserPreferenceCache;
import github.nighter.smartspawner.commands.reload.ReloadCommand;
import github.nighter.smartspawner.configs.TimeFormatter;
import github.nighter.smartspawner.economy.CustomEconomyManager;
import github.nighter.smartspawner.economy.ItemPriceManager;
import github.nighter.smartspawner.extras.HopperHandler;
import github.nighter.smartspawner.hooks.protections.api.Lands;
import github.nighter.smartspawner.hooks.protections.api.SuperiorSkyblock2;
import github.nighter.smartspawner.hooks.shops.IShopIntegration;
import github.nighter.smartspawner.hooks.shops.SaleLogger;
import github.nighter.smartspawner.hooks.shops.ShopIntegrationManager;
import github.nighter.smartspawner.hooks.shops.api.shopguiplus.SpawnerHook;
import github.nighter.smartspawner.hooks.shops.api.shopguiplus.SpawnerProvider;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.migration.SpawnerDataMigration;
import github.nighter.smartspawner.nms.VersionInitializer;
import github.nighter.smartspawner.spawner.gui.main.ItemCache;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuAction;
import github.nighter.smartspawner.spawner.gui.main.SpawnerMenuUI;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerHandler;
import github.nighter.smartspawner.spawner.gui.stacker.SpawnerStackerUI;
import github.nighter.smartspawner.spawner.gui.storage.FilterConfigUI;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageAction;
import github.nighter.smartspawner.spawner.gui.storage.SpawnerStorageUI;
import github.nighter.smartspawner.spawner.gui.synchronization.SpawnerGuiViewManager;
import github.nighter.smartspawner.spawner.interactions.SpawnerClickManager;
import github.nighter.smartspawner.spawner.interactions.destroy.SpawnerBreakListener;
import github.nighter.smartspawner.spawner.interactions.destroy.SpawnerExplosionListener;
import github.nighter.smartspawner.spawner.interactions.place.SpawnerPlaceListener;
import github.nighter.smartspawner.spawner.interactions.stack.SpawnerStackHandler;
import github.nighter.smartspawner.spawner.interactions.type.SpawnEggHandler;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import github.nighter.smartspawner.spawner.loot.EntityLootRegistry;
import github.nighter.smartspawner.spawner.lootgen.SpawnerLootGenerator;
import github.nighter.smartspawner.spawner.lootgen.SpawnerRangeChecker;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import github.nighter.smartspawner.spawner.utils.SpawnerFileHandler;
import github.nighter.smartspawner.spawner.utils.SpawnerMobHeadTexture;
import github.nighter.smartspawner.updates.ConfigUpdater;
import github.nighter.smartspawner.updates.LanguageUpdater;
import github.nighter.smartspawner.updates.UpdateChecker;
import github.nighter.smartspawner.utils.SpawnerTypeChecker;
import java.io.File;
import java.util.Objects;
import java.util.logging.Level;
import lombok.Generated;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class SmartSpawner
extends JavaPlugin
implements SmartSpawnerPlugin {
    private static SmartSpawner instance;
    public final int DATA_VERSION = 3;
    private final boolean debugMode = this.getConfig().getBoolean("debug", false);
    private TimeFormatter timeFormatter;
    private ConfigUpdater configUpdater;
    private LanguageManager languageManager;
    private LanguageUpdater languageUpdater;
    private MessageService messageService;
    private SpawnerItemFactory spawnerItemFactory;
    private final ItemCache itemCache = new ItemCache(500, 30);
    private SpawnerMenuUI spawnerMenuUI;
    private SpawnerStorageUI spawnerStorageUI;
    private FilterConfigUI filterConfigUI;
    private SpawnerStackerUI spawnerStackerUI;
    private SpawnEggHandler spawnEggHandler;
    private SpawnerClickManager spawnerClickManager;
    private SpawnerStackHandler spawnerStackHandler;
    private SpawnerMenuAction spawnerMenuAction;
    private SpawnerStackerHandler spawnerStackerHandler;
    private SpawnerStorageAction spawnerStorageAction;
    private SpawnerFileHandler spawnerFileHandler;
    private SpawnerManager spawnerManager;
    private ShopIntegrationManager shopIntegrationManager;
    private HopperHandler hopperHandler;
    private GlobalEventHandlers globalEventHandlers;
    private SpawnerLootGenerator spawnerLootGenerator;
    private SpawnerListGUI spawnerListGUI;
    private SpawnerRangeChecker rangeChecker;
    private SpawnerGuiViewManager spawnerGuiViewManager;
    private SpawnerExplosionListener spawnerExplosionListener;
    private SpawnerBreakListener spawnerBreakListener;
    private SpawnerPlaceListener spawnerPlaceListener;
    private ItemPriceManager itemPriceManager;
    private CustomEconomyManager customEconomyManager;
    private EntityLootRegistry entityLootRegistry;
    private UpdateChecker updateChecker;
    private CommandHandler commandHandler;
    private ReloadCommand reloadCommand;
    private GiveCommand giveCommand;
    private UserPreferenceCache userPreferenceCache;
    private ListCommand listCommand;
    private HologramCommand hologramCommand;
    public static boolean hasTowny;
    public static boolean hasLands;
    public static boolean hasWorldGuard;
    public static boolean hasGriefPrevention;
    public static boolean hasSuperiorSkyblock2;
    public static boolean hasBentoBox;
    public static boolean hasSimpleClaimSystem;
    public static boolean hasRedProtect;
    private SmartSpawnerAPIImpl apiImpl;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        instance = this;
        this.saveResourceAsDefault("spawners_data.yml");
        this.saveResourceAsDefault("mob_drops.yml");
        this.initializeVersionComponents();
        this.migrateDataIfNeeded();
        this.initializeComponents();
        this.checkProtectionPlugins();
        this.setupCommand();
        this.setupBtatsMetrics();
        this.registerListeners();
        this.initializeSaleLogging();
        long loadTime = System.currentTimeMillis() - startTime;
        this.getLogger().info("SmartSpawner has been enabled! (Loaded in " + loadTime + "ms)");
    }

    @Override
    public SmartSpawnerAPI getAPI() {
        return this.apiImpl;
    }

    private void saveResourceAsDefault(String resourcePath) {
        File resourceFile = new File(this.getDataFolder(), resourcePath);
        if (!resourceFile.exists()) {
            this.saveResource(resourcePath, false);
        }
    }

    private void initializeVersionComponents() {
        try {
            new VersionInitializer(this).initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize version-specific components", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void migrateDataIfNeeded() {
        SpawnerDataMigration migration = new SpawnerDataMigration(this);
        if (migration.checkAndMigrateData()) {
            this.getLogger().info("Data migration completed. Loading with new format...");
        }
    }

    private void initializeComponents() {
        this.initializeServices();
        this.initializeEconomyComponents();
        this.initializeCoreComponents();
        this.initializeHandlers();
        this.initializeUIAndActions();
        this.setUpHopperHandler();
        this.initializeListeners();
        this.apiImpl = new SmartSpawnerAPIImpl(this);
        this.updateChecker = new UpdateChecker(this);
    }

    private void initializeServices() {
        SpawnerTypeChecker.init(this);
        this.timeFormatter = new TimeFormatter(this);
        this.configUpdater = new ConfigUpdater(this);
        this.configUpdater.checkAndUpdateConfig();
        this.languageManager = new LanguageManager(this);
        this.languageUpdater = new LanguageUpdater(this);
        this.messageService = new MessageService(this, this.languageManager);
    }

    private void initializeEconomyComponents() {
        this.shopIntegrationManager = new ShopIntegrationManager(this);
        this.itemPriceManager = new ItemPriceManager(this);
        this.itemPriceManager.init();
        this.customEconomyManager = this.getConfig().getBoolean("custom_sell_prices.enabled", false) ? new CustomEconomyManager(this, this.itemPriceManager) : null;
        this.shopIntegrationManager.initialize();
        this.entityLootRegistry = new EntityLootRegistry(this, this.itemPriceManager);
        this.spawnerItemFactory = new SpawnerItemFactory(this);
    }

    private void initializeCoreComponents() {
        this.spawnerFileHandler = new SpawnerFileHandler(this);
        this.spawnerManager = new SpawnerManager(this);
        this.spawnerManager.reloadAllHolograms();
        this.spawnerStorageUI = new SpawnerStorageUI(this);
        this.filterConfigUI = new FilterConfigUI(this);
        this.spawnerMenuUI = new SpawnerMenuUI(this);
        this.spawnerGuiViewManager = new SpawnerGuiViewManager(this);
        this.spawnerLootGenerator = new SpawnerLootGenerator(this);
        this.rangeChecker = new SpawnerRangeChecker(this);
    }

    private void initializeHandlers() {
        this.spawnerStackerUI = new SpawnerStackerUI(this);
        this.spawnEggHandler = new SpawnEggHandler(this);
        this.spawnerStackHandler = new SpawnerStackHandler(this);
        this.spawnerClickManager = new SpawnerClickManager(this);
    }

    private void initializeUIAndActions() {
        this.spawnerMenuAction = new SpawnerMenuAction(this);
        this.spawnerStackerHandler = new SpawnerStackerHandler(this);
        this.spawnerStorageAction = new SpawnerStorageAction(this);
    }

    private void initializeListeners() {
        this.globalEventHandlers = new GlobalEventHandlers(this);
        this.spawnerExplosionListener = new SpawnerExplosionListener(this);
        this.spawnerBreakListener = new SpawnerBreakListener(this);
        this.spawnerPlaceListener = new SpawnerPlaceListener(this);
    }

    public void setUpHopperHandler() {
        this.hopperHandler = this.getConfig().getBoolean("hopper.enabled", false) ? new HopperHandler(this) : null;
    }

    private void registerListeners() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.globalEventHandlers, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerListGUI, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerBreakListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerPlaceListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerStorageAction, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerExplosionListener, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerGuiViewManager, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerClickManager, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerMenuAction, (Plugin)this);
        pm.registerEvents((Listener)this.spawnerStackerHandler, (Plugin)this);
        if (this.shopIntegrationManager.isShopGUIPlusEnabled()) {
            pm.registerEvents((Listener)new SpawnerHook(this), (Plugin)this);
        }
    }

    private void setupCommand() {
        this.reloadCommand = new ReloadCommand(this);
        this.giveCommand = new GiveCommand(this);
        this.userPreferenceCache = new UserPreferenceCache((Plugin)this);
        this.listCommand = new ListCommand(this);
        this.spawnerListGUI = new SpawnerListGUI(this);
        this.hologramCommand = new HologramCommand(this);
        this.commandHandler = new CommandHandler(this);
        Objects.requireNonNull(this.getCommand("smartspawner")).setExecutor((CommandExecutor)this.commandHandler);
        Objects.requireNonNull(this.getCommand("smartspawner")).setTabCompleter((TabCompleter)this.commandHandler);
    }

    private void setupBtatsMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 24822);
        metrics.addCustomChart(new Metrics.SimplePie("holograms", () -> String.valueOf(this.getConfig().getBoolean("hologram.enabled", false))));
        metrics.addCustomChart(new Metrics.SimplePie("hoppers", () -> String.valueOf(this.getConfig().getBoolean("hopper.enabled", false))));
        metrics.addCustomChart(new Metrics.SimplePie("spawners", () -> String.valueOf(this.spawnerManager.getTotalSpawners() / 1000 * 1000)));
    }

    private void initializeSaleLogging() {
        if (this.getConfig().getBoolean("log_transactions.enabled", false)) {
            SaleLogger.getInstance();
        }
    }

    private void checkProtectionPlugins() {
        hasWorldGuard = this.checkPlugin("WorldGuard", () -> {
            Plugin worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
            return worldGuardPlugin != null && worldGuardPlugin.isEnabled();
        }, true);
        hasGriefPrevention = this.checkPlugin("GriefPrevention", () -> {
            Plugin griefPlugin = Bukkit.getPluginManager().getPlugin("GriefPrevention");
            return griefPlugin instanceof GriefPrevention;
        }, true);
        hasLands = this.checkPlugin("Lands", () -> {
            Plugin landsPlugin = Bukkit.getPluginManager().getPlugin("Lands");
            if (landsPlugin != null) {
                new Lands((Plugin)this);
                return true;
            }
            return false;
        }, true);
        hasTowny = this.checkPlugin("Towny", () -> {
            try {
                Class.forName("com.palmergames.bukkit.towny.TownyAPI");
                return TownyAPI.getInstance() != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }, true);
        hasSuperiorSkyblock2 = this.checkPlugin("SuperiorSkyblock2", () -> {
            Plugin superiorSkyblock2 = Bukkit.getPluginManager().getPlugin("SuperiorSkyblock2");
            if (superiorSkyblock2 != null) {
                SuperiorSkyblock2 ssb2 = new SuperiorSkyblock2();
                Bukkit.getPluginManager().registerEvents((Listener)ssb2, (Plugin)this);
                return true;
            }
            return false;
        }, true);
        hasBentoBox = this.checkPlugin("BentoBox", () -> {
            Plugin bentoPlugin = Bukkit.getPluginManager().getPlugin("BentoBox");
            return bentoPlugin != null;
        }, true);
        hasSimpleClaimSystem = this.checkPlugin("SimpleClaimSystem", () -> {
            Plugin simpleClaimPlugin = Bukkit.getPluginManager().getPlugin("SimpleClaimSystem");
            SimpleClaimSystemAPI_Provider.initialize((SimpleClaimSystem)((SimpleClaimSystem)simpleClaimPlugin));
            return simpleClaimPlugin != null;
        }, true);
        hasRedProtect = this.checkPlugin("RedProtect", () -> {
            Plugin pRP = Bukkit.getPluginManager().getPlugin("RedProtect");
            return pRP != null && pRP.isEnabled();
        }, true);
    }

    private boolean checkPlugin(String pluginName, PluginCheck checker, boolean logSuccess) {
        try {
            if (checker.check()) {
                if (logSuccess) {
                    this.getLogger().info(pluginName + " integration enabled successfully!");
                }
                return true;
            }
        }
        catch (NoClassDefFoundError | NullPointerException throwable) {
            // empty catch block
        }
        return false;
    }

    public void reload() {
        this.shopIntegrationManager.reload();
        this.itemPriceManager.reload();
        this.clearItemCache();
        boolean shouldUseCustomSellPrices = this.getConfig().getBoolean("custom_sell_prices.enabled", false);
        if (shouldUseCustomSellPrices) {
            if (this.customEconomyManager == null) {
                this.customEconomyManager = new CustomEconomyManager(this, this.itemPriceManager);
            } else {
                this.customEconomyManager.reload();
            }
        } else if (this.customEconomyManager != null) {
            this.customEconomyManager.shutdown();
            this.customEconomyManager = null;
        }
    }

    public void reloadStaticUI() {
        this.spawnerStorageUI = new SpawnerStorageUI(this);
        this.filterConfigUI = new FilterConfigUI(this);
    }

    public void onDisable() {
        this.saveAndCleanup();
        SpawnerMobHeadTexture.clearCache();
        this.shutdownSaleLogger();
        this.getLogger().info("SmartSpawner has been disabled!");
    }

    private void saveAndCleanup() {
        if (this.spawnerManager != null) {
            try {
                if (this.spawnerFileHandler != null) {
                    this.spawnerFileHandler.shutdown();
                }
                this.spawnerManager.cleanupAllSpawners();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Error saving spawner data during shutdown", e);
            }
        }
        this.cleanupResources();
    }

    private void cleanupResources() {
        if (this.rangeChecker != null) {
            this.rangeChecker.cleanup();
        }
        if (this.spawnerGuiViewManager != null) {
            this.spawnerGuiViewManager.cleanup();
        }
        if (this.hopperHandler != null) {
            this.hopperHandler.cleanup();
        }
        if (this.spawnerClickManager != null) {
            this.spawnerClickManager.cleanup();
        }
        if (this.spawnerStackerHandler != null) {
            this.spawnerStackerHandler.cleanupAll();
        }
        if (this.spawnerStorageUI != null) {
            this.spawnerStorageUI.cleanup();
        }
        if (this.customEconomyManager != null) {
            this.customEconomyManager.shutdown();
        }
    }

    private void shutdownSaleLogger() {
        if (this.getConfig().getBoolean("log_transactions.enabled", true)) {
            SaleLogger.getInstance().shutdown();
        }
    }

    public boolean hasShopIntegration() {
        return this.shopIntegrationManager.hasShopIntegration();
    }

    public IShopIntegration getShopIntegration() {
        return this.shopIntegrationManager.getShopIntegration();
    }

    public SpawnerProvider getSpawnerProvider() {
        return new SpawnerProvider(this);
    }

    public long getTimeFromConfig(String path, String defaultValue) {
        return this.timeFormatter.getTimeFromConfig(path, defaultValue);
    }

    public void refreshTimeCache() {
        if (this.timeFormatter != null) {
            this.timeFormatter.clearCache();
        }
    }

    public void clearItemCache() {
        this.itemCache.clear();
    }

    public void debug(String message) {
        if (this.debugMode) {
            this.getLogger().info("[DEBUG] " + message);
        }
    }

    @Generated
    public int getDATA_VERSION() {
        return this.DATA_VERSION;
    }

    @Generated
    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Generated
    public TimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    @Generated
    public ConfigUpdater getConfigUpdater() {
        return this.configUpdater;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Generated
    public LanguageUpdater getLanguageUpdater() {
        return this.languageUpdater;
    }

    @Generated
    public MessageService getMessageService() {
        return this.messageService;
    }

    @Generated
    public SpawnerItemFactory getSpawnerItemFactory() {
        return this.spawnerItemFactory;
    }

    @Generated
    public ItemCache getItemCache() {
        return this.itemCache;
    }

    @Generated
    public SpawnerMenuUI getSpawnerMenuUI() {
        return this.spawnerMenuUI;
    }

    @Generated
    public SpawnerStorageUI getSpawnerStorageUI() {
        return this.spawnerStorageUI;
    }

    @Generated
    public FilterConfigUI getFilterConfigUI() {
        return this.filterConfigUI;
    }

    @Generated
    public SpawnerStackerUI getSpawnerStackerUI() {
        return this.spawnerStackerUI;
    }

    @Generated
    public SpawnEggHandler getSpawnEggHandler() {
        return this.spawnEggHandler;
    }

    @Generated
    public SpawnerClickManager getSpawnerClickManager() {
        return this.spawnerClickManager;
    }

    @Generated
    public SpawnerStackHandler getSpawnerStackHandler() {
        return this.spawnerStackHandler;
    }

    @Generated
    public SpawnerMenuAction getSpawnerMenuAction() {
        return this.spawnerMenuAction;
    }

    @Generated
    public SpawnerStackerHandler getSpawnerStackerHandler() {
        return this.spawnerStackerHandler;
    }

    @Generated
    public SpawnerStorageAction getSpawnerStorageAction() {
        return this.spawnerStorageAction;
    }

    @Generated
    public SpawnerFileHandler getSpawnerFileHandler() {
        return this.spawnerFileHandler;
    }

    @Generated
    public SpawnerManager getSpawnerManager() {
        return this.spawnerManager;
    }

    @Generated
    public ShopIntegrationManager getShopIntegrationManager() {
        return this.shopIntegrationManager;
    }

    @Generated
    public HopperHandler getHopperHandler() {
        return this.hopperHandler;
    }

    @Generated
    public GlobalEventHandlers getGlobalEventHandlers() {
        return this.globalEventHandlers;
    }

    @Generated
    public SpawnerLootGenerator getSpawnerLootGenerator() {
        return this.spawnerLootGenerator;
    }

    @Generated
    public SpawnerListGUI getSpawnerListGUI() {
        return this.spawnerListGUI;
    }

    @Generated
    public SpawnerRangeChecker getRangeChecker() {
        return this.rangeChecker;
    }

    @Generated
    public SpawnerGuiViewManager getSpawnerGuiViewManager() {
        return this.spawnerGuiViewManager;
    }

    @Generated
    public SpawnerExplosionListener getSpawnerExplosionListener() {
        return this.spawnerExplosionListener;
    }

    @Generated
    public SpawnerBreakListener getSpawnerBreakListener() {
        return this.spawnerBreakListener;
    }

    @Generated
    public SpawnerPlaceListener getSpawnerPlaceListener() {
        return this.spawnerPlaceListener;
    }

    @Generated
    public ItemPriceManager getItemPriceManager() {
        return this.itemPriceManager;
    }

    @Generated
    public CustomEconomyManager getCustomEconomyManager() {
        return this.customEconomyManager;
    }

    @Generated
    public EntityLootRegistry getEntityLootRegistry() {
        return this.entityLootRegistry;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    @Generated
    public ReloadCommand getReloadCommand() {
        return this.reloadCommand;
    }

    @Generated
    public GiveCommand getGiveCommand() {
        return this.giveCommand;
    }

    @Generated
    public UserPreferenceCache getUserPreferenceCache() {
        return this.userPreferenceCache;
    }

    @Generated
    public ListCommand getListCommand() {
        return this.listCommand;
    }

    @Generated
    public HologramCommand getHologramCommand() {
        return this.hologramCommand;
    }

    @Generated
    public SmartSpawnerAPIImpl getApiImpl() {
        return this.apiImpl;
    }

    @Generated
    public static SmartSpawner getInstance() {
        return instance;
    }

    static {
        hasTowny = false;
        hasLands = false;
        hasWorldGuard = false;
        hasGriefPrevention = false;
        hasSuperiorSkyblock2 = false;
        hasBentoBox = false;
        hasSimpleClaimSystem = false;
        hasRedProtect = false;
    }

    @FunctionalInterface
    private static interface PluginCheck {
        public boolean check();
    }
}

