/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.commands.give.GiveCommand;
import github.nighter.smartspawner.commands.hologram.HologramCommand;
import github.nighter.smartspawner.commands.list.ListCommand;
import github.nighter.smartspawner.commands.reload.ReloadCommand;
import github.nighter.smartspawner.language.MessageService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final ReloadCommand reloadCommand;
    private final GiveCommand giveCommand;
    private final ListCommand listCommand;
    private final HologramCommand hologramCommand;
    private final SmartSpawner plugin;
    private final MessageService messageService;

    public CommandHandler(SmartSpawner plugin) {
        this.plugin = plugin;
        this.messageService = plugin.getMessageService();
        this.reloadCommand = plugin.getReloadCommand();
        this.giveCommand = plugin.getGiveCommand();
        this.listCommand = plugin.getListCommand();
        this.hologramCommand = plugin.getHologramCommand();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.messageService.sendMessage(sender, "command_usage");
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("giveVanillaSpawner")) {
                return this.giveCommand.executeCommand(args);
            }
            if (args[0].equalsIgnoreCase("reload")) {
                return this.reloadCommand.onCommand(sender, command, label, args);
            }
            this.messageService.sendConsoleMessage("command_usage");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        switch (args[0].toLowerCase()) {
            case "reload": {
                return this.reloadCommand.onCommand(sender, command, label, args);
            }
            case "give": 
            case "givevanillaspawner": {
                return this.giveCommand.executeCommand(sender, args);
            }
            case "list": {
                this.listCommand.openWorldSelectionGUI(player);
                return true;
            }
            case "hologram": {
                return this.hologramCommand.onCommand(sender, command, label, args);
            }
        }
        this.messageService.sendMessage(sender, "command_usage");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("smartspawner.reload")) {
                completions.add("reload");
            }
            if (sender.hasPermission("smartspawner.give")) {
                completions.add("give");
                completions.add("giveVanillaSpawner");
            }
            if (sender.hasPermission("smartspawner.list")) {
                completions.add("list");
            }
            if (sender.hasPermission("smartspawner.hologram")) {
                completions.add("hologram");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("reload")) {
            return this.reloadCommand.onTabComplete(sender, command, alias, args);
        }
        if (args[0].equalsIgnoreCase("give") || args[0].equalsIgnoreCase("giveVanillaSpawner")) {
            return this.giveCommand.tabComplete(sender, args);
        }
        return Collections.emptyList();
    }
}

