/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.give;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.nms.SpawnerWrapper;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final SpawnerItemFactory spawnerItemFactory;
    private final List<String> supportedMobs;
    private final int MAX_AMOUNT = 6400;

    public GiveCommand(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.spawnerItemFactory = plugin.getSpawnerItemFactory();
        this.supportedMobs = SpawnerWrapper.SUPPORTED_MOBS;
    }

    public boolean executeCommand(CommandSender sender, String[] args) {
        boolean isVanillaSpawner;
        if (!sender.hasPermission("smartspawner.give")) {
            this.messageService.sendMessage(sender, "no_permission");
            return true;
        }
        boolean bl = isVanillaSpawner = args.length > 0 && args[0].equalsIgnoreCase("giveVanillaSpawner");
        if (args.length < 3 || args.length > 4) {
            if (isVanillaSpawner) {
                this.messageService.sendMessage(sender, "command_give_vanilla_usage");
            } else {
                this.messageService.sendMessage(sender, "command_give_usage");
            }
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            this.messageService.sendMessage(sender, "command_give_player_not_found");
            return true;
        }
        String mobType = args[2].toUpperCase();
        if (!this.supportedMobs.contains(mobType)) {
            this.messageService.sendMessage(sender, "command_give_invalid_mob_type");
            return true;
        }
        int amount = this.parseAmount(sender, args);
        if (amount <= 0) {
            return true;
        }
        try {
            EntityType entityType = EntityType.valueOf((String)mobType);
            String messageKey = "command_give_spawner_";
            ItemStack spawner = isVanillaSpawner ? this.spawnerItemFactory.createVanillaSpawnerItem(entityType, amount) : this.spawnerItemFactory.createSpawnerItem(entityType, amount);
            String entityName = this.languageManager.getFormattedMobName(entityType);
            String smallCapsEntityName = this.languageManager.getSmallCaps(entityName);
            HashMap leftoverItems = target.getInventory().addItem(new ItemStack[]{spawner});
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", target.getName());
            placeholders.put("entity", entityName);
            placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            placeholders.put("amount", String.valueOf(amount));
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("amount", String.valueOf(amount));
            targetPlaceholders.put("entity", entityName);
            targetPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            if (!leftoverItems.isEmpty()) {
                for (ItemStack leftover : leftoverItems.values()) {
                    target.getWorld().dropItemNaturally(target.getLocation(), leftover);
                }
                this.messageService.sendMessage(target, "command_give_inventory_full");
                this.messageService.sendMessage(target, messageKey + "received", targetPlaceholders);
                this.messageService.sendMessage(sender, messageKey + "given", placeholders);
            } else {
                this.messageService.sendMessage(target, messageKey + "received", targetPlaceholders);
                this.messageService.sendMessage(sender, messageKey + "given", placeholders);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            this.messageService.sendMessage(sender, "command_give_invalid_mob_type");
            this.plugin.getLogger().warning("Error creating spawner: " + e.getMessage());
            return true;
        }
    }

    public boolean executeCommand(String[] args) {
        boolean isVanillaSpawner;
        boolean bl = isVanillaSpawner = args.length > 0 && args[0].equalsIgnoreCase("giveVanillaSpawner");
        if (args.length < 3 || args.length > 4) {
            if (isVanillaSpawner) {
                this.messageService.sendConsoleMessage("command_give_vanilla_usage");
            } else {
                this.messageService.sendConsoleMessage("command_give_usage");
            }
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            this.messageService.sendConsoleMessage("command_give_player_not_found");
            return true;
        }
        String mobType = args[2].toUpperCase();
        if (!this.supportedMobs.contains(mobType)) {
            this.messageService.sendConsoleMessage("command_give_invalid_mob_type");
            return true;
        }
        int amount = 1;
        if (args.length == 4) {
            try {
                amount = Integer.parseInt(args[3]);
                if (amount <= 0) {
                    this.messageService.sendConsoleMessage("command_give_invalid_amount");
                    return true;
                }
                if (amount > 6400) {
                    this.messageService.sendConsoleMessage("command_give_amount_too_large", Collections.singletonMap("max", String.valueOf(6400)));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                this.messageService.sendConsoleMessage("command_give_invalid_amount");
                return true;
            }
        }
        try {
            EntityType entityType = EntityType.valueOf((String)mobType);
            String messageKey = "command_give_spawner_";
            ItemStack spawner = isVanillaSpawner ? this.spawnerItemFactory.createVanillaSpawnerItem(entityType, amount) : this.spawnerItemFactory.createSpawnerItem(entityType, amount);
            String entityName = this.languageManager.getFormattedMobName(entityType);
            String smallCapsEntityName = this.languageManager.getSmallCaps(entityName);
            HashMap leftoverItems = target.getInventory().addItem(new ItemStack[]{spawner});
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("player", target.getName());
            placeholders.put("entity", entityName);
            placeholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            placeholders.put("amount", String.valueOf(amount));
            HashMap<String, String> targetPlaceholders = new HashMap<String, String>();
            targetPlaceholders.put("amount", String.valueOf(amount));
            targetPlaceholders.put("entity", entityName);
            targetPlaceholders.put("\u1d07\u0274\u1d1b\u026a\u1d1b\u028f", smallCapsEntityName);
            if (!leftoverItems.isEmpty()) {
                for (ItemStack leftover : leftoverItems.values()) {
                    target.getWorld().dropItemNaturally(target.getLocation(), leftover);
                }
                this.messageService.sendMessage(target, "command_give_inventory_full");
                target.playSound(target.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                this.messageService.sendConsoleMessage(messageKey + "given_dropped", placeholders);
            } else {
                this.messageService.sendMessage(target, messageKey + "received", targetPlaceholders);
                target.playSound(target.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                this.messageService.sendConsoleMessage(messageKey + "given", placeholders);
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            this.messageService.sendConsoleMessage("command_give_invalid_mob_type");
            this.plugin.getLogger().warning("Error creating spawner: " + e.getMessage());
            return true;
        }
    }

    private int parseAmount(CommandSender sender, String[] args) {
        int amount = 1;
        if (args.length == 4) {
            try {
                amount = Integer.parseInt(args[3]);
                if (amount <= 0) {
                    this.messageService.sendMessage(sender, "command_give_invalid_amount");
                    return -1;
                }
                if (amount > 6400) {
                    this.messageService.sendMessage(sender, "command_give_amount_too_large", Collections.singletonMap("max", String.valueOf(6400)));
                    return -1;
                }
            }
            catch (NumberFormatException e) {
                this.messageService.sendMessage(sender, "command_give_invalid_amount");
                return -1;
            }
        }
        return amount;
    }

    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("smartspawner.give")) {
            return Collections.emptyList();
        }
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        if (args.length == 3) {
            String input = args[2].toLowerCase();
            return this.supportedMobs.stream().map(String::toLowerCase).filter(mob -> mob.startsWith(input)).collect(Collectors.toList());
        }
        if (args.length == 4) {
            String input = args[3].toLowerCase();
            return Arrays.asList("1", "16", "32", "64").stream().filter(amount -> amount.startsWith(input)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

