/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.hologram;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class HologramCommand
implements CommandExecutor {
    private final SmartSpawner plugin;
    private final SpawnerManager spawnerManager;
    private final LanguageManager languageManager;
    private final MessageService messageService;

    public HologramCommand(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerManager = plugin.getSpawnerManager();
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("smartspawner.hologram")) {
            this.messageService.sendMessage(sender, "no_permission");
            return true;
        }
        boolean newValue = !this.plugin.getConfig().getBoolean("hologram.enabled");
        FileConfiguration mainConfig = this.plugin.getConfig();
        mainConfig.set("hologram.enabled", (Object)newValue);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        this.spawnerManager.refreshAllHolograms();
        String messageKey = newValue ? "command_hologram_enabled" : "command_hologram_disabled";
        this.messageService.sendMessage(sender, messageKey);
        return true;
    }
}

