/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.list;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.commands.list.ListCommand;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class UserPreferenceCache {
    private final Map<UUID, Map<String, UserPreference>> userPreferences = new ConcurrentHashMap<UUID, Map<String, UserPreference>>();
    private final Plugin plugin;
    private static final long EXPIRY_TICKS = 36000L;
    private Scheduler.Task cleanupTask;

    public UserPreferenceCache(Plugin plugin) {
        this.plugin = plugin;
        this.cleanupTask = Scheduler.runTaskTimerAsync(this::cleanupExpiredPreferences, 36000L, 36000L);
    }

    public void savePreference(UUID playerUuid, String worldName, ListCommand.FilterOption filterOption, ListCommand.SortOption sortOption) {
        this.userPreferences.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(worldName, new UserPreference(filterOption, sortOption));
    }

    public UserPreference getPreference(UUID playerUuid, String worldName) {
        Map<String, UserPreference> worldPreferences = this.userPreferences.get(playerUuid);
        if (worldPreferences == null) {
            return null;
        }
        UserPreference preference = worldPreferences.get(worldName);
        if (preference != null && preference.isExpired()) {
            worldPreferences.remove(worldName);
            return null;
        }
        return preference;
    }

    private void cleanupExpiredPreferences() {
        long now = System.currentTimeMillis();
        this.userPreferences.forEach((uuid, worldPrefs) -> {
            worldPrefs.entrySet().removeIf(entry -> ((UserPreference)entry.getValue()).isExpired());
            if (worldPrefs.isEmpty()) {
                this.userPreferences.remove(uuid);
            }
        });
    }

    public void clearPreferences(UUID playerUuid) {
        this.userPreferences.remove(playerUuid);
    }

    public void shutdown() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
    }

    public static class UserPreference {
        private final ListCommand.FilterOption filterOption;
        private final ListCommand.SortOption sortOption;
        private final long timestamp;

        public UserPreference(ListCommand.FilterOption filterOption, ListCommand.SortOption sortOption) {
            this.filterOption = filterOption;
            this.sortOption = sortOption;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 1800000L;
        }

        @Generated
        public ListCommand.FilterOption getFilterOption() {
            return this.filterOption;
        }

        @Generated
        public ListCommand.SortOption getSortOption() {
            return this.sortOption;
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserPreference)) {
                return false;
            }
            UserPreference other = (UserPreference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            ListCommand.FilterOption this$filterOption = this.getFilterOption();
            ListCommand.FilterOption other$filterOption = other.getFilterOption();
            if (this$filterOption == null ? other$filterOption != null : !((Object)((Object)this$filterOption)).equals((Object)other$filterOption)) {
                return false;
            }
            ListCommand.SortOption this$sortOption = this.getSortOption();
            ListCommand.SortOption other$sortOption = other.getSortOption();
            return !(this$sortOption == null ? other$sortOption != null : !((Object)((Object)this$sortOption)).equals((Object)other$sortOption));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserPreference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            ListCommand.FilterOption $filterOption = this.getFilterOption();
            result = result * 59 + ($filterOption == null ? 43 : ((Object)((Object)$filterOption)).hashCode());
            ListCommand.SortOption $sortOption = this.getSortOption();
            result = result * 59 + ($sortOption == null ? 43 : ((Object)((Object)$sortOption)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UserPreferenceCache.UserPreference(filterOption=" + String.valueOf((Object)this.getFilterOption()) + ", sortOption=" + String.valueOf((Object)this.getSortOption()) + ", timestamp=" + this.getTimestamp() + ")";
        }
    }
}

