/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.commands.reload;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.gui.synchronization.ItemUpdater;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ReloadCommand
implements CommandExecutor,
TabCompleter {
    private final SmartSpawner plugin;

    public ReloadCommand(SmartSpawner plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("smartspawner.reload")) {
            this.plugin.getMessageService().sendMessage(sender, "no_permission");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (args.length == 1) {
                this.reloadAll(sender);
            } else {
                this.plugin.getMessageService().sendMessage(sender, "reload_command_usage");
            }
            return true;
        }
        return false;
    }

    private void reloadAll(CommandSender sender) {
        try {
            this.plugin.getMessageService().sendMessage(sender, "reload_command_start");
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.logCacheStats();
            }
            ItemUpdater.clearCache();
            this.plugin.getSpawnerItemFactory().clearAllCaches();
            this.plugin.getMessageService().clearKeyExistsCache();
            this.plugin.reloadConfig();
            this.plugin.refreshTimeCache();
            this.plugin.setUpHopperHandler();
            this.plugin.getEntityLootRegistry().reload();
            this.reloadSpawnerLootConfigs();
            this.plugin.getLanguageManager().reloadLanguages();
            this.plugin.getSpawnerItemFactory().reload();
            this.plugin.getSpawnerManager().reloadAllHolograms();
            this.plugin.getSpawnerMenuAction().updateCooldownSettings();
            this.plugin.getRangeChecker().reload();
            this.plugin.reload();
            this.plugin.reloadStaticUI();
            if (this.plugin.getConfig().getBoolean("debug", false)) {
                this.logCacheStats();
            }
            this.plugin.getMessageService().sendMessage(sender, "reload_command_success");
            this.plugin.getLogger().info("Plugin reloaded successfully by " + sender.getName());
        }
        catch (Exception e) {
            this.plugin.getMessageService().sendMessage(sender, "reload_command_error");
            this.plugin.getLogger().severe("Error reloading plugin: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void logCacheStats() {
        Map<String, Object> stats = this.plugin.getLanguageManager().getCacheStats();
        this.plugin.getLogger().info("Language cache statistics:");
        for (Map.Entry<String, Object> entry : stats.entrySet()) {
            this.plugin.getLogger().info("  " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
    }

    private void reloadSpawnerLootConfigs() {
        List<SpawnerData> allSpawners = this.plugin.getSpawnerManager().getAllSpawners();
        for (SpawnerData spawner : allSpawners) {
            try {
                spawner.reloadLootConfig();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to reload loot config for spawner " + spawner.getSpawnerId() + ": " + e.getMessage());
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("smartspawner.reload")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Collections.singletonList("reload");
        }
        return Collections.emptyList();
    }
}

