/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.economy;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.economy.ItemPriceManager;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.RegisteredServiceProvider;

public class CustomEconomyManager {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final ItemPriceManager priceManager;
    private Economy economy;
    private boolean isVaultAvailable;
    private final Map<String, CacheEntry> transactionCache = new ConcurrentHashMap<String, CacheEntry>();
    private final Map<Material, Double> materialPriceCache = new ConcurrentHashMap<Material, Double>();
    private Scheduler.Task cleanupTask;
    private static final int CACHE_CLEANUP_INTERVAL_MINUTES = 15;
    private static final long CACHE_EXPIRY_MS = 1800000L;

    public CustomEconomyManager(SmartSpawner plugin, ItemPriceManager priceManager) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.priceManager = priceManager;
        this.isVaultAvailable = false;
        String currencyType = plugin.getConfig().getString("custom_sell_prices.currency", "VAULT");
        if (currencyType.equalsIgnoreCase("VAULT")) {
            if (this.setupVaultEconomy()) {
                this.startCleanupTask();
            }
        } else {
            plugin.getLogger().warning("Unsupported currency type: " + currencyType + ". Currently only VAULT is supported.");
        }
    }

    private void startCleanupTask() {
        if (this.cleanupTask != null && !this.cleanupTask.isCancelled()) {
            this.cleanupTask.cancel();
        }
        long ticks = 18000L;
        this.cleanupTask = Scheduler.runTaskTimerAsync(this::cleanTransactionCache, ticks, ticks);
    }

    private void cleanTransactionCache() {
        if (this.transactionCache.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        int beforeSize = this.transactionCache.size();
        this.transactionCache.entrySet().removeIf(entry -> now - ((CacheEntry)entry.getValue()).timestamp > 1800000L);
        int removedCount = beforeSize - this.transactionCache.size();
        if (removedCount > 0) {
            this.plugin.debug("Cleaned up " + removedCount + " expired transaction cache entries");
        }
    }

    private boolean setupVaultEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("Vault not found! Custom sell prices system disabled.");
            return false;
        }
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.isVaultAvailable = false;
            this.plugin.getLogger().warning("No economy provider found for Vault! Custom sell prices system disabled.");
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        this.isVaultAvailable = true;
        this.plugin.getLogger().info("Successfully connected to Vault & Economy provider: " + this.economy.getName());
        return this.isVaultAvailable;
    }

    public boolean sellAllItems(Player player, SpawnerData spawner) {
        if (!this.isEnabled()) {
            return false;
        }
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
        if (items.isEmpty()) {
            this.messageService.sendMessage(player, "shop.no_items");
            return false;
        }
        String playerName = player.getName();
        double totalValue = 0.0;
        HashMap<Material, Long> materialAmounts = new HashMap<Material, Long>();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        long totalItemCount = 0L;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            VirtualInventory.ItemSignature sig = entry.getKey();
            ItemStack template = sig.getTemplate();
            Material material = template.getType();
            long amount = entry.getValue();
            double price = this.getMaterialPrice(material);
            if (price <= 0.0) continue;
            materialAmounts.merge(material, amount, Long::sum);
            totalValue += price * (double)amount;
            totalItemCount += amount;
            this.createItemStacksForRemoval(template, amount, itemsToRemove);
        }
        if (totalValue <= 0.0 || itemsToRemove.isEmpty()) {
            this.messageService.sendMessage(player, "shop.no_items");
            return false;
        }
        if (this.economy.depositPlayer((OfflinePlayer)player, totalValue).transactionSuccess()) {
            virtualInv.removeItems(itemsToRemove);
            spawner.updateHologramData();
            if (spawner.getIsAtCapacity().booleanValue()) {
                spawner.setIsAtCapacity(false);
            }
            this.transactionCache.put(playerName, new CacheEntry(totalValue));
            this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner);
            this.sendSellSuccessMessage(player, totalValue, totalItemCount);
            return true;
        }
        this.plugin.getLogger().log(Level.WARNING, "Failed to deposit money to player: " + player.getName());
        return false;
    }

    private void createItemStacksForRemoval(ItemStack template, long amount, List<ItemStack> itemsList) {
        int maxStackSize = template.getMaxStackSize();
        int fullStacks = (int)(amount / (long)maxStackSize);
        int remainder = (int)(amount % (long)maxStackSize);
        for (int i = 0; i < fullStacks; ++i) {
            ItemStack stack = template.clone();
            stack.setAmount(maxStackSize);
            itemsList.add(stack);
        }
        if (remainder > 0) {
            ItemStack stack = template.clone();
            stack.setAmount(remainder);
            itemsList.add(stack);
        }
    }

    private double getMaterialPrice(Material material) {
        return this.materialPriceCache.computeIfAbsent(material, this.priceManager::getPrice);
    }

    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("custom_sell_prices.enabled", false) && this.isVaultAvailable;
    }

    public double getLatestTransactionAmount(Player player) {
        CacheEntry entry = this.transactionCache.get(player.getName());
        return entry != null ? entry.amount : 0.0;
    }

    private void sendSellSuccessMessage(Player player, double amount, long itemCount) {
        this.messageService.sendMessage(player, "shop.sell_all", Map.of("price", this.languageManager.formatNumber(amount), "amount", this.languageManager.formatNumber(itemCount)));
    }

    public void reload() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        this.isVaultAvailable = false;
        String currencyType = this.plugin.getConfig().getString("custom_sell_prices.currency", "VAULT");
        if (this.plugin.getConfig().getBoolean("custom_sell_prices.enabled", false) && currencyType.equalsIgnoreCase("VAULT")) {
            this.setupVaultEconomy();
            this.startCleanupTask();
        }
        this.transactionCache.clear();
        this.materialPriceCache.clear();
    }

    public void shutdown() {
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
            this.cleanupTask = null;
        }
        this.transactionCache.clear();
        this.materialPriceCache.clear();
    }

    private static class CacheEntry {
        final double amount;
        final long timestamp;

        CacheEntry(double amount) {
            this.amount = amount;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

