/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.economy;

import github.nighter.smartspawner.SmartSpawner;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ItemPriceManager {
    private final SmartSpawner plugin;
    private final Map<String, Double> itemPrices = new ConcurrentHashMap<String, Double>();
    private File priceFile;
    private FileConfiguration priceConfig;
    private double defaultPrice;

    public void init() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.priceFile = new File(this.plugin.getDataFolder(), "item_prices.yml");
        if (!this.priceFile.exists()) {
            this.plugin.saveResource("item_prices.yml", false);
            this.plugin.debug("Created default item_prices.yml from plugin resources");
        }
        this.priceConfig = YamlConfiguration.loadConfiguration((File)this.priceFile);
        this.defaultPrice = this.plugin.getConfig().getDouble("custom_economy.default_price", 1.0);
        this.loadPrices();
    }

    private void loadPrices() {
        this.itemPrices.clear();
        for (String key : this.priceConfig.getKeys(false)) {
            double price = this.priceConfig.getDouble(key, this.defaultPrice);
            this.itemPrices.put(key, price);
        }
    }

    public double getPrice(Material material) {
        if (material == null) {
            return 0.0;
        }
        return this.itemPrices.getOrDefault(material.name(), this.defaultPrice);
    }

    public void setPrice(Material material, double price) {
        if (material == null) {
            return;
        }
        this.itemPrices.put(material.name(), price);
        this.priceConfig.set(material.name(), (Object)price);
        this.saveConfig();
    }

    public void reload() {
        this.priceConfig = YamlConfiguration.loadConfiguration((File)this.priceFile);
        this.defaultPrice = this.plugin.getConfig().getDouble("custom_economy.default_price", 1.0);
        this.loadPrices();
    }

    public boolean hasPriceFor(Material material) {
        if (material == null) {
            return false;
        }
        return this.itemPrices.containsKey(material.name());
    }

    public void removePrice(Material material) {
        if (material == null) {
            return;
        }
        this.itemPrices.remove(material.name());
        this.priceConfig.set(material.name(), null);
        this.saveConfig();
    }

    public Map<String, Double> getAllPrices() {
        return new ConcurrentHashMap<String, Double>(this.itemPrices);
    }

    private void saveConfig() {
        try {
            this.priceConfig.save(this.priceFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save item prices configuration", e);
        }
    }

    @Generated
    public ItemPriceManager(SmartSpawner plugin) {
        this.plugin = plugin;
    }

    @Generated
    public double getDefaultPrice() {
        return this.defaultPrice;
    }
}

