/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.protections;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.protections.api.GriefPrevention;
import github.nighter.smartspawner.hooks.protections.api.Lands;
import github.nighter.smartspawner.hooks.protections.api.SimpleClaimSystem;
import github.nighter.smartspawner.hooks.protections.api.Towny;
import github.nighter.smartspawner.hooks.protections.api.WorldGuard;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CheckBreakBlock {
    public static boolean CanPlayerBreakBlock(@NotNull Player player, @NotNull Location location) {
        if (player.isOp() || player.hasPermission("*")) {
            return true;
        }
        if (SmartSpawner.hasGriefPrevention && !GriefPrevention.canPlayerBreakClaimBlock(player, location)) {
            return false;
        }
        if (SmartSpawner.hasWorldGuard && !WorldGuard.canPlayerBreakBlockInRegion(player, location)) {
            return false;
        }
        if (SmartSpawner.hasLands && !Lands.canPlayerBreakClaimBlock(player, location)) {
            return false;
        }
        if (SmartSpawner.hasTowny && !Towny.canPlayerInteractSpawner(player, location)) {
            return false;
        }
        return !SmartSpawner.hasSimpleClaimSystem || SimpleClaimSystem.canPlayerBreakClaimBlock(player, location);
    }
}

