/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.protections;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.protections.api.BentoBoxAPI;
import github.nighter.smartspawner.hooks.protections.api.GriefPrevention;
import github.nighter.smartspawner.hooks.protections.api.Lands;
import github.nighter.smartspawner.hooks.protections.api.RedProtectAPI;
import github.nighter.smartspawner.hooks.protections.api.SimpleClaimSystem;
import github.nighter.smartspawner.hooks.protections.api.SuperiorSkyblock2;
import github.nighter.smartspawner.hooks.protections.api.Towny;
import github.nighter.smartspawner.hooks.protections.api.WorldGuard;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CheckOpenMenu {
    public static boolean CanPlayerOpenMenu(@NotNull Player player, @NotNull Location location) {
        if (player.isOp() || player.hasPermission("*")) {
            return true;
        }
        if (SmartSpawner.hasGriefPrevention && !GriefPrevention.canPlayerOpenMenuOnClaim(player, location)) {
            return false;
        }
        if (SmartSpawner.hasWorldGuard && !WorldGuard.canPlayerInteractInRegion(player, location)) {
            return false;
        }
        if (SmartSpawner.hasLands && !Lands.CanPlayerInteractContainer(player, location)) {
            return false;
        }
        if (SmartSpawner.hasTowny && !Towny.canPlayerInteractSpawner(player, location)) {
            return false;
        }
        if (SmartSpawner.hasSuperiorSkyblock2 && SuperiorSkyblock2.canPlayerOpenMenu(player, location)) {
            return false;
        }
        if (SmartSpawner.hasBentoBox && !BentoBoxAPI.canPlayerOpenMenu(player, location)) {
            return false;
        }
        if (SmartSpawner.hasSimpleClaimSystem && !SimpleClaimSystem.canPlayerOpenMenuOnClaim(player, location)) {
            return false;
        }
        return !SmartSpawner.hasRedProtect || RedProtectAPI.canPlayerOpenMenuOnClaim(player, location);
    }
}

