/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.language.LanguageManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SaleLogger {
    private static SaleLogger instance;
    private final BlockingQueue<LogEntry> logQueue;
    private final File logFile;
    private final DateTimeFormatter dateFormatter;
    private volatile boolean isRunning;
    private final Thread loggerThread;
    private final ScheduledExecutorService scheduler;
    private static final int QUEUE_CAPACITY = 1000;
    private static final int BATCH_SIZE = 100;
    private static final long FLUSH_INTERVAL = 15000L;

    private SaleLogger() {
        SmartSpawner plugin = SmartSpawner.getInstance();
        this.logQueue = new ArrayBlockingQueue<LogEntry>(1000);
        this.dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.logFile = new File("plugins/SmartSpawner/" + plugin.getConfig().getString("log_transactions.file_path", "logs/shop_transactions.log"));
        this.isRunning = true;
        this.logFile.getParentFile().mkdirs();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "SaleLogger-Scheduler");
            thread.setDaemon(true);
            return thread;
        });
        this.loggerThread = new Thread(this::processLogQueue, "SaleLogger-Thread");
        this.loggerThread.setDaemon(true);
        this.loggerThread.start();
        this.scheduler.scheduleWithFixedDelay(this::scheduleFlush, 15000L, 15000L, TimeUnit.MILLISECONDS);
    }

    public static synchronized SaleLogger getInstance() {
        if (instance == null) {
            instance = new SaleLogger();
        }
        return instance;
    }

    public void logSale(String playerName, String itemName, int amount, double price, String currency) {
        if (!this.isRunning) {
            return;
        }
        LogEntry entry = new LogEntry(playerName, itemName, amount, price, currency);
        if (!this.logQueue.offer(entry)) {
            this.flushLogs();
            this.logQueue.offer(entry);
        }
    }

    private void scheduleFlush() {
        if (!this.logQueue.isEmpty()) {
            this.flushLogs();
        }
    }

    private void processLogQueue() {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>(100);
        while (this.isRunning) {
            try {
                LogEntry entry = this.logQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (entry == null) continue;
                batch.add(entry);
                this.logQueue.drainTo(batch, 100 - batch.size());
                if (batch.isEmpty()) continue;
                this.writeLogsToFile(batch);
                batch.clear();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (!batch.isEmpty()) {
            this.writeLogsToFile(batch);
        }
    }

    private void flushLogs() {
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>(this.logQueue.size());
        this.logQueue.drainTo(batch);
        if (!batch.isEmpty()) {
            this.writeLogsToFile(batch);
        }
    }

    private void writeLogsToFile(List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFile, true));){
            for (LogEntry entry : entries) {
                writer.write(entry.toString());
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.isRunning = false;
        this.scheduler.shutdown();
        this.loggerThread.interrupt();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            this.loggerThread.join(5000L);
            this.flushLogs();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static class LogEntry {
        private final long timestamp = System.currentTimeMillis();
        private final String playerName;
        private final String itemName;
        private final int amount;
        private final double price;
        private final String currency;
        private final LanguageManager languageManager;

        LogEntry(String playerName, String itemName, int amount, double price, String currency) {
            this.playerName = playerName;
            this.itemName = itemName;
            this.amount = amount;
            this.price = price;
            this.currency = currency;
            SmartSpawner plugin = SmartSpawner.getInstance();
            this.languageManager = plugin.getLanguageManager();
        }

        public String toString() {
            return String.format("Time: %s | %s sold %d %s from spawner for %s$ (Currency: %s)%n", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault())), this.playerName, this.amount, this.itemName, this.languageManager.formatNumber((long)this.price), this.currency);
        }
    }
}

