/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.economies.CustomSellPricesIntegration;
import github.nighter.smartspawner.hooks.shops.IShopIntegration;
import github.nighter.smartspawner.hooks.shops.api.economyshopgui.EconomyShopGUI;
import github.nighter.smartspawner.hooks.shops.api.shopguiplus.ShopGuiPlus;
import github.nighter.smartspawner.hooks.shops.api.zshop.ZShop;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ShopIntegrationManager {
    private final SmartSpawner plugin;
    private IShopIntegration shopIntegration;
    private boolean hasShopIntegration = false;
    private boolean isShopGUIPlusEnabled = false;
    private boolean isUsingCustomPrices = false;
    private final Map<String, Function<SmartSpawner, IShopIntegration>> shopIntegrations = new LinkedHashMap<String, Function<SmartSpawner, IShopIntegration>>();

    public ShopIntegrationManager(SmartSpawner plugin) {
        this.plugin = plugin;
        this.registerShopIntegrations();
    }

    private void registerShopIntegrations() {
        this.shopIntegrations.put("economyshopgui-premium", EconomyShopGUI::new);
        this.shopIntegrations.put("economyshopgui", EconomyShopGUI::new);
        this.shopIntegrations.put("shopguiplus", ShopGuiPlus::new);
        this.shopIntegrations.put("zshop", ZShop::new);
        this.shopIntegrations.put("custom_sell_prices", CustomSellPricesIntegration::new);
    }

    public void initialize() {
        if (this.plugin.getConfig().getBoolean("custom_sell_prices.enabled", false)) {
            this.setupCustomSellPricesIntegration();
            return;
        }
        if (!this.plugin.getConfig().getBoolean("shop_integration.enabled", true)) {
            this.plugin.getLogger().info("Shop integration is disabled by configuration");
            return;
        }
        String configuredShopType = this.plugin.getConfig().getString("shop_integration.type", "auto").toLowerCase();
        if ("auto".equals(configuredShopType)) {
            this.autoDetectAndSetupShop();
        } else {
            this.setupSpecificShop(configuredShopType);
        }
    }

    private void setupCustomSellPricesIntegration() {
        Function<SmartSpawner, IShopIntegration> integrationCreator = this.shopIntegrations.get("custom_sell_prices");
        if (integrationCreator != null) {
            try {
                this.shopIntegration = integrationCreator.apply(this.plugin);
                this.hasShopIntegration = this.shopIntegration.isEnabled();
                if (this.hasShopIntegration) {
                    this.isUsingCustomPrices = true;
                    this.plugin.getLogger().info("Custom sell prices enabled successfully!");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to setup custom sell prices: " + e.getMessage());
                this.hasShopIntegration = false;
                this.isUsingCustomPrices = false;
            }
        }
    }

    private void setupSpecificShop(String shopType) {
        Function<SmartSpawner, IShopIntegration> integrationCreator = this.shopIntegrations.get(shopType);
        if (integrationCreator != null) {
            String bukkitPluginName = this.getBukkitPluginName(shopType);
            this.plugin.getLogger().info("Checking for " + bukkitPluginName + "...");
            Plugin shopPlugin = Bukkit.getPluginManager().getPlugin(bukkitPluginName);
            if (shopPlugin != null && shopPlugin.isEnabled()) {
                this.setupShopIntegration(bukkitPluginName, integrationCreator);
            } else {
                this.plugin.getLogger().warning(bukkitPluginName + " not found - integration disabled");
            }
        } else {
            this.plugin.getLogger().warning("No integration found for shop type: " + shopType);
        }
    }

    private String getBukkitPluginName(String shopType) {
        return switch (shopType.toLowerCase()) {
            case "economyshopgui" -> "EconomyShopGUI";
            case "economyshopgui-premium" -> "EconomyShopGUI-Premium";
            case "shopguiplus" -> "ShopGUIPlus";
            case "zshop" -> "zShop";
            default -> shopType;
        };
    }

    private void autoDetectAndSetupShop() {
        String[] pluginNames;
        this.plugin.getLogger().info("Auto-detecting available shop plugins...");
        for (String bukkitPluginName : pluginNames = new String[]{"EconomyShopGUI-Premium", "EconomyShopGUI", "ShopGUIPlus", "zShop"}) {
            Function<SmartSpawner, IShopIntegration> integrationCreator;
            Plugin shopPlugin = Bukkit.getPluginManager().getPlugin(bukkitPluginName);
            if (shopPlugin == null || !shopPlugin.isEnabled()) continue;
            String lowercasePluginName = bukkitPluginName.toLowerCase();
            if (lowercasePluginName.equals("economyshopgui-premium")) {
                lowercasePluginName = "economyshopgui-premium";
            }
            if ((integrationCreator = this.shopIntegrations.get(lowercasePluginName)) == null) continue;
            try {
                this.setupShopIntegration(bukkitPluginName, integrationCreator);
                return;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to setup " + bukkitPluginName + " integration: " + e.getMessage());
            }
        }
        this.plugin.getLogger().warning("No compatible shop plugins were found during auto-detection.");
    }

    private void setupShopIntegration(String pluginName, Function<SmartSpawner, IShopIntegration> integrationCreator) {
        try {
            this.shopIntegration = integrationCreator.apply(this.plugin);
            this.hasShopIntegration = true;
            this.isShopGUIPlusEnabled = pluginName.equals("ShopGUIPlus");
            this.isUsingCustomPrices = false;
            this.plugin.getLogger().info(pluginName + " integration enabled successfully!");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to setup " + pluginName + " integration: " + e.getMessage());
            this.hasShopIntegration = false;
            this.isShopGUIPlusEnabled = false;
            this.isUsingCustomPrices = false;
        }
    }

    public IShopIntegration getShopIntegration() {
        if (this.shopIntegration != null && this.shopIntegration.isEnabled()) {
            return this.shopIntegration;
        }
        return null;
    }

    public boolean hasShopIntegration() {
        return this.hasShopIntegration;
    }

    public void reload() {
        this.hasShopIntegration = false;
        this.isShopGUIPlusEnabled = false;
        this.isUsingCustomPrices = false;
        this.shopIntegration = null;
        this.initialize();
    }

    @Generated
    public boolean isShopGUIPlusEnabled() {
        return this.isShopGUIPlusEnabled;
    }

    @Generated
    public boolean isUsingCustomPrices() {
        return this.isUsingCustomPrices;
    }
}

