/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops.api.economyshopgui;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.shops.IShopIntegration;
import github.nighter.smartspawner.hooks.shops.SaleLogger;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.api.prices.AdvancedSellPrice;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EconomyShopGUI
implements IShopIntegration {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private static final long TRANSACTION_TIMEOUT_MS = 5000L;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<UUID, CompletableFuture<Boolean>> pendingSales = new ConcurrentHashMap<UUID, CompletableFuture<Boolean>>();

    public EconomyShopGUI(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
    }

    @Override
    public boolean sellAllItems(Player player, SpawnerData spawner) {
        if (this.pendingSales.containsKey(player.getUniqueId())) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        ReentrantLock lock = spawner.getLock();
        if (!lock.tryLock()) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        try {
            CompletableFuture<Boolean> saleFuture = CompletableFuture.supplyAsync(() -> this.processSaleAsync(player, spawner), this.executorService);
            this.pendingSales.put(player.getUniqueId(), saleFuture);
            saleFuture.whenComplete((success, error) -> {
                this.pendingSales.remove(player.getUniqueId());
                lock.unlock();
                if (error != null) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error processing sale", (Throwable)error);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.sale_failed"));
                }
            });
            try {
                Boolean result = saleFuture.get(100L, TimeUnit.MILLISECONDS);
                return result != null && result != false;
            }
            catch (TimeoutException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            lock.unlock();
            this.plugin.getLogger().log(Level.SEVERE, "Error initiating sale", e);
            return false;
        }
    }

    private boolean processSaleAsync(Player player, SpawnerData spawner) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
        if (items.isEmpty()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_items"));
            return false;
        }
        SaleCalculationResult calculation = this.calculateSalePrices(player, items);
        if (!calculation.isValid()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_sellable_items"));
            return false;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            virtualInv.removeItems(calculation.getItemsToRemove());
            if (virtualInv.isDirty()) {
                Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
            }
        });
        try {
            CompletableFuture transactionFuture = new CompletableFuture();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                boolean success = this.processTransactions(player, calculation);
                transactionFuture.complete(success);
            });
            boolean success = (Boolean)transactionFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (!success) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    virtualInv.addItems(calculation.getItemsToRemove());
                    this.messageService.sendMessage(player, "shop.sale_failed");
                    Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
                });
                return false;
            }
            this.updateShopStats(calculation.getSoldItems(), player.getUniqueId());
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.sendSuccessMessage(player, calculation));
            return true;
        }
        catch (Exception e) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                virtualInv.addItems(calculation.getItemsToRemove());
                this.messageService.sendMessage(player, "shop.sale_failed");
                Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
            });
            return false;
        }
    }

    private boolean processTransactions(Player player, SaleCalculationResult calculation) {
        Map<EcoType, Double> afterTaxPrices = calculation.getTaxedPrices();
        try {
            for (Map.Entry<EcoType, Double> entry : afterTaxPrices.entrySet()) {
                if (!this.isClaimableCurrency(entry.getKey())) continue;
                EconomyShopGUIHook.getEcon((EcoType)entry.getKey()).depositBalance((OfflinePlayer)player, entry.getValue().doubleValue());
            }
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error processing transaction", e);
            return false;
        }
    }

    private void sendSuccessMessage(Player player, SaleCalculationResult calculation) {
        StringBuilder taxedPriceBuilder = new StringBuilder();
        calculation.getTaxedPrices().forEach((type, value) -> {
            if (!taxedPriceBuilder.isEmpty()) {
                taxedPriceBuilder.append(", ");
            }
            taxedPriceBuilder.append(this.formatMonetaryValue((double)value, (EcoType)type));
        });
        StringBuilder originalPriceBuilder = new StringBuilder();
        if (this.plugin.getConfig().getBoolean("tax.enabled", false)) {
            calculation.getOriginalPrices().forEach((type, value) -> {
                if (!originalPriceBuilder.isEmpty()) {
                    originalPriceBuilder.append(", ");
                }
                originalPriceBuilder.append(this.formatMonetaryValue((double)value, (EcoType)type));
            });
        }
        double taxPercentage = this.plugin.getConfig().getDouble("tax.percentage", 10.0);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(this.languageManager.formatNumber(calculation.getTotalAmount())));
        placeholders.put("price", taxedPriceBuilder.toString());
        if (this.plugin.getConfig().getBoolean("tax.enabled")) {
            placeholders.put("gross", originalPriceBuilder.toString());
            placeholders.put("tax", String.format("%.2f", taxPercentage));
            this.messageService.sendMessage(player, "shop.sell_all_with_tax", placeholders);
        } else {
            this.messageService.sendMessage(player, "shop.sell_all", placeholders);
        }
    }

    private SaleCalculationResult calculateSalePrices(Player player, Map<VirtualInventory.ItemSignature, Long> items) {
        HashMap<EcoType, Double> prices = new HashMap<EcoType, Double>();
        HashMap<ShopItem, Integer> soldItems = new HashMap<ShopItem, Integer>();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        int totalAmount = 0;
        boolean foundSellableItem = false;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            ShopItem shopItem;
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            if (amount <= 0L || (shopItem = EconomyShopGUIHook.getShopItem((Player)player, (ItemStack)template)) == null || !EconomyShopGUIHook.isSellAble((ShopItem)shopItem)) continue;
            foundSellableItem = true;
            int limit = this.getSellLimit(shopItem, player.getUniqueId(), (int)amount);
            if (limit == -1 || (limit = this.getMaxSell(shopItem, limit, soldItems.getOrDefault(shopItem, 0))) == -1) continue;
            ItemStack itemToRemove = template.clone();
            itemToRemove.setAmount(limit);
            itemsToRemove.add(itemToRemove);
            this.calculateSellPrice(prices, shopItem, player, template, limit, totalAmount);
            totalAmount += limit;
            soldItems.put(shopItem, soldItems.getOrDefault(shopItem, 0) + limit);
        }
        HashMap<EcoType, Double> taxedPrices = this.plugin.getConfig().getBoolean("tax.enabled", false) ? this.applyTax(prices) : prices;
        return new SaleCalculationResult(prices, taxedPrices, totalAmount, itemsToRemove, soldItems, foundSellableItem);
    }

    private Map<EcoType, Double> applyTax(Map<EcoType, Double> originalPrices) {
        double taxPercentage = this.plugin.getConfig().getDouble("tax.percentage", 10.0);
        HashMap<EcoType, Double> taxedPrices = new HashMap<EcoType, Double>();
        for (Map.Entry<EcoType, Double> entry : originalPrices.entrySet()) {
            double originalPrice = entry.getValue();
            double taxAmount = originalPrice * (taxPercentage / 100.0);
            double afterTaxPrice = originalPrice - taxAmount;
            taxedPrices.put(entry.getKey(), afterTaxPrice);
        }
        return taxedPrices;
    }

    private int getSellLimit(ShopItem shopItem, UUID playerUUID, int amount) {
        if (shopItem.getLimitedSellMode() != 0) {
            int stock = EconomyShopGUIHook.getSellLimit((ShopItem)shopItem, (UUID)playerUUID);
            if (stock <= 0) {
                return -1;
            }
            if (stock < amount) {
                amount = stock;
            }
        }
        return amount;
    }

    private int getMaxSell(ShopItem shopItem, int qty, int alreadySold) {
        if (shopItem.isMaxSell(alreadySold + qty)) {
            if (alreadySold >= shopItem.getMaxSell()) {
                return -1;
            }
            qty = shopItem.getMaxSell() - alreadySold;
        }
        return qty;
    }

    private void calculateSellPrice(Map<EcoType, Double> prices, ShopItem shopItem, Player player, ItemStack item, int amount, int sold) {
        if (EconomyShopGUIHook.hasMultipleSellPrices((ShopItem)shopItem)) {
            AdvancedSellPrice sellPrice;
            sellPrice.getSellPrices((sellPrice = EconomyShopGUIHook.getMultipleSellPrices((ShopItem)shopItem)).giveAll() ? null : (EcoType)sellPrice.getSellTypes().get(0), player, item, amount, sold).forEach((type, price) -> {
                prices.put((EcoType)type, prices.getOrDefault(type, 0.0) + price);
                if (this.plugin.getConfig().getBoolean("log_transactions.enabled", true)) {
                    SaleLogger.getInstance().logSale(player.getName(), item.getType().name(), amount, (double)price, type.getType().name());
                }
            });
        } else {
            double sellPrice = EconomyShopGUIHook.getItemSellPrice((ShopItem)shopItem, (ItemStack)item, (Player)player, (int)amount, (int)sold);
            prices.put(shopItem.getEcoType(), prices.getOrDefault(shopItem.getEcoType(), 0.0) + sellPrice);
            if (this.plugin.getConfig().getBoolean("log_transactions.enabled", true)) {
                SaleLogger.getInstance().logSale(player.getName(), item.getType().name(), amount, sellPrice, shopItem.getEcoType().getType().name());
            }
        }
    }

    private void updateShopStats(Map<ShopItem, Integer> items, UUID playerUUID) {
        Scheduler.runTaskAsync(() -> {
            for (Map.Entry entry : items.entrySet()) {
                ShopItem item = (ShopItem)entry.getKey();
                int amount = (Integer)entry.getValue();
                if (item.isRefillStock()) {
                    EconomyShopGUIHook.sellItemStock((ShopItem)item, (UUID)playerUUID, (int)amount);
                }
                if (item.getLimitedSellMode() != 0) {
                    EconomyShopGUIHook.sellItemLimit((ShopItem)item, (UUID)playerUUID, (int)amount);
                }
                if (!item.isDynamicPricing()) continue;
                EconomyShopGUIHook.sellItem((ShopItem)item, (int)amount);
            }
        });
    }

    private boolean isClaimableCurrency(EcoType ecoType) {
        return switch (ecoType.getType().name()) {
            case "ITEM", "LEVELS", "EXP", "VAULT", "PLAYER_POINTS", "COINS" -> true;
            default -> false;
        };
    }

    private String formatMonetaryValue(double value, EcoType ecoType) {
        if (ecoType == null) {
            return this.formatPrice(value, false);
        }
        try {
            boolean useLanguageManager = ecoType.getType() == EconomyType.VAULT || ecoType.getType() == EconomyType.PLAYER_POINTS;
            String formattedValue = this.formatPrice(value, useLanguageManager);
            if (ecoType.getType() == EconomyType.EXP || ecoType.getType() == EconomyType.LEVELS || ecoType.getType() == EconomyType.ITEM) {
                return formattedValue + " " + ecoType.getType().name();
            }
            return formattedValue;
        }
        catch (Exception e) {
            return this.formatPrice(value, false);
        }
    }

    @Override
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class SaleCalculationResult {
        private final Map<EcoType, Double> originalPrices;
        private final Map<EcoType, Double> taxedPrices;
        private final int totalAmount;
        private final List<ItemStack> itemsToRemove;
        private final Map<ShopItem, Integer> soldItems;
        private final boolean valid;

        public SaleCalculationResult(Map<EcoType, Double> originalPrices, Map<EcoType, Double> taxedPrices, int totalAmount, List<ItemStack> itemsToRemove, Map<ShopItem, Integer> soldItems, boolean valid) {
            this.originalPrices = originalPrices;
            this.taxedPrices = taxedPrices;
            this.totalAmount = totalAmount;
            this.itemsToRemove = itemsToRemove;
            this.soldItems = soldItems;
            this.valid = valid;
        }

        public Map<EcoType, Double> getOriginalPrices() {
            return this.originalPrices;
        }

        public Map<EcoType, Double> getTaxedPrices() {
            return this.taxedPrices;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public List<ItemStack> getItemsToRemove() {
            return this.itemsToRemove;
        }

        public Map<ShopItem, Integer> getSoldItems() {
            return this.soldItems;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

