/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops.api.shopguiplus;

import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.hooks.shops.IShopIntegration;
import github.nighter.smartspawner.hooks.shops.SaleLogger;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.brcdev.shopgui.ShopGuiPlusApi;
import net.brcdev.shopgui.economy.EconomyManager;
import net.brcdev.shopgui.economy.EconomyType;
import net.brcdev.shopgui.provider.economy.EconomyProvider;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ShopGuiPlus
implements IShopIntegration {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private final boolean isLoggingEnabled;
    private static final long TRANSACTION_TIMEOUT_MS = 5000L;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<UUID, CompletableFuture<Boolean>> pendingSales = new ConcurrentHashMap<UUID, CompletableFuture<Boolean>>();

    public ShopGuiPlus(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.isLoggingEnabled = plugin.getConfig().getBoolean("log_transactions.enabled", true);
    }

    @Override
    public boolean sellAllItems(Player player, SpawnerData spawner) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.pendingSales.containsKey(player.getUniqueId())) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        ReentrantLock lock = spawner.getLock();
        if (!lock.tryLock()) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        try {
            CompletableFuture<Boolean> saleFuture = CompletableFuture.supplyAsync(() -> this.processSaleAsync(player, spawner), this.executorService);
            this.pendingSales.put(player.getUniqueId(), saleFuture);
            saleFuture.whenComplete((success, error) -> {
                this.pendingSales.remove(player.getUniqueId());
                lock.unlock();
                if (error != null) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error processing sale", (Throwable)error);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.sale_failed"));
                }
            });
            try {
                Boolean result = saleFuture.get(100L, TimeUnit.MILLISECONDS);
                return result != null && result != false;
            }
            catch (TimeoutException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            lock.unlock();
            this.plugin.getLogger().log(Level.SEVERE, "Error initiating sale", e);
            return false;
        }
    }

    private boolean processSaleAsync(Player player, SpawnerData spawner) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
        if (items.isEmpty()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_items"));
            return false;
        }
        SaleCalculationResult calculation = this.calculateSalePrices(player, items);
        if (!calculation.isValid()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_sellable_items"));
            return false;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            virtualInv.removeItems(calculation.getItemsToRemove());
            Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
        });
        try {
            CompletableFuture transactionFuture = new CompletableFuture();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                boolean success = this.processTransactions(player, calculation);
                transactionFuture.complete(success);
            });
            boolean success = (Boolean)transactionFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (!success) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    virtualInv.addItems(calculation.getItemsToRemove());
                    this.messageService.sendMessage(player, "shop.sale_failed");
                    Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
                });
                return false;
            }
            if (this.isLoggingEnabled) {
                this.logSalesAsync(calculation, player.getName());
            }
            double taxPercentage = this.plugin.getConfig().getDouble("tax.percentage", 10.0);
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.sendSuccessMessage(player, calculation.getTotalAmount(), calculation.getTotalPrice(), taxPercentage));
            return true;
        }
        catch (Exception e) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                virtualInv.addItems(calculation.getItemsToRemove());
                Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
            });
            return false;
        }
    }

    private boolean processTransactions(Player player, SaleCalculationResult calculation) {
        double taxPercentage = this.plugin.getConfig().getDouble("tax.percentage", 10.0);
        for (Map.Entry<EconomyType, Double> entry : calculation.getPricesByEconomy().entrySet()) {
            EconomyType economyType = entry.getKey();
            double totalPrice = entry.getValue();
            double finalPrice = this.calculateNetAmount(totalPrice, taxPercentage);
            try {
                EconomyProvider economyProvider = ShopGuiPlusApi.getPlugin().getEconomyManager().getEconomyProvider(economyType);
                if (economyProvider == null) {
                    this.plugin.getLogger().severe("No economy provider found for type: " + String.valueOf(economyType));
                    return false;
                }
                economyProvider.deposit(player, finalPrice);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error processing transaction for economy " + String.valueOf(economyType) + ": " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    private double calculateNetAmount(double grossAmount, double taxPercentage) {
        if (this.plugin.getConfig().getBoolean("tax.enabled", false)) {
            return grossAmount * (1.0 - taxPercentage / 100.0);
        }
        return grossAmount;
    }

    private void logSalesAsync(SaleCalculationResult calculation, String playerName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            for (Map.Entry<String, SaleInfo> entry : calculation.getItemSales().entrySet()) {
                SaleInfo saleInfo = entry.getValue();
                SaleLogger.getInstance().logSale(playerName, entry.getKey(), saleInfo.getAmount(), saleInfo.getPrice(), saleInfo.getEconomyType().name());
            }
        });
    }

    private String formatMonetaryValue(double value) {
        return this.formatPrice(value, true);
    }

    private void sendSuccessMessage(Player player, int totalAmount, double totalPrice, double taxPercentage) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(this.languageManager.formatNumber(totalAmount)));
        placeholders.put("price", this.formatMonetaryValue(totalPrice));
        if (this.plugin.getConfig().getBoolean("tax.enabled", false)) {
            double grossPrice = totalPrice / (1.0 - taxPercentage / 100.0);
            placeholders.put("gross", this.formatMonetaryValue(grossPrice));
            placeholders.put("tax", String.format("%.2f", taxPercentage));
            this.messageService.sendMessage(player, "shop.sell_all_with_tax", placeholders);
        } else {
            this.messageService.sendMessage(player, "shop.sell_all", placeholders);
        }
    }

    private SaleCalculationResult calculateSalePrices(Player player, Map<VirtualInventory.ItemSignature, Long> items) {
        HashMap<EconomyType, Double> pricesByEconomy = new HashMap<EconomyType, Double>();
        HashMap<String, SaleInfo> itemSales = new HashMap<String, SaleInfo>();
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        int totalAmount = 0;
        boolean foundSellableItem = false;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            double sellPrice;
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            if (amount <= 0L || (sellPrice = ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)template)) <= 0.0) continue;
            EconomyType economyType = this.getEconomyType(template);
            foundSellableItem = true;
            ItemStack itemToRemove = template.clone();
            int removeAmount = (int)Math.min(amount, Integer.MAX_VALUE);
            itemToRemove.setAmount(removeAmount);
            itemsToRemove.add(itemToRemove);
            double totalItemPrice = sellPrice * (double)amount;
            pricesByEconomy.merge(economyType, totalItemPrice, Double::sum);
            totalAmount += removeAmount;
            String itemName = template.getType().name();
            itemSales.put(itemName, new SaleInfo(removeAmount, totalItemPrice, economyType));
        }
        return new SaleCalculationResult(pricesByEconomy, totalAmount, itemsToRemove, itemSales, foundSellableItem);
    }

    private EconomyType getEconomyType(ItemStack material) {
        EconomyType economyType = ShopGuiPlusApi.getItemStackShop((ItemStack)material).getEconomyType();
        if (economyType != null) {
            return economyType;
        }
        EconomyManager economyManager = ShopGuiPlusApi.getPlugin().getEconomyManager();
        EconomyProvider defaultEconomyProvider = economyManager.getDefaultEconomyProvider();
        if (defaultEconomyProvider != null) {
            String defaultEconomyTypeName = defaultEconomyProvider.getName().toUpperCase(Locale.US);
            try {
                return EconomyType.valueOf((String)defaultEconomyTypeName);
            }
            catch (IllegalArgumentException ex) {
                return EconomyType.CUSTOM;
            }
        }
        return EconomyType.CUSTOM;
    }

    @Override
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Override
    public boolean isEnabled() {
        return ShopGuiPlusApi.getPlugin().getShopManager().areShopsLoaded();
    }

    private static class SaleCalculationResult {
        private final Map<EconomyType, Double> pricesByEconomy;
        private final int totalAmount;
        private final List<ItemStack> itemsToRemove;
        private final Map<String, SaleInfo> itemSales;
        private final boolean valid;

        public SaleCalculationResult(Map<EconomyType, Double> pricesByEconomy, int totalAmount, List<ItemStack> itemsToRemove, Map<String, SaleInfo> itemSales, boolean valid) {
            this.pricesByEconomy = pricesByEconomy;
            this.totalAmount = totalAmount;
            this.itemsToRemove = itemsToRemove;
            this.itemSales = itemSales;
            this.valid = valid;
        }

        public Map<EconomyType, Double> getPricesByEconomy() {
            return this.pricesByEconomy;
        }

        public double getTotalPrice() {
            return this.pricesByEconomy.values().stream().mapToDouble(Double::doubleValue).sum();
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public List<ItemStack> getItemsToRemove() {
            return this.itemsToRemove;
        }

        public Map<String, SaleInfo> getItemSales() {
            return this.itemSales;
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static class SaleInfo {
        private final int amount;
        private final double price;
        private final EconomyType economyType;

        public SaleInfo(int amount, double price, EconomyType economyType) {
            this.amount = amount;
            this.price = price;
            this.economyType = economyType;
        }

        public int getAmount() {
            return this.amount;
        }

        public double getPrice() {
            return this.price;
        }

        public EconomyType getEconomyType() {
            return this.economyType;
        }
    }
}

