/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops.api.shopguiplus;

import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.spawner.item.SpawnerItemFactory;
import net.brcdev.shopgui.spawner.external.provider.ExternalSpawnerProvider;
import org.bukkit.Material;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class SpawnerProvider
implements ExternalSpawnerProvider {
    private final SmartSpawner plugin;
    private final SpawnerItemFactory spawnerItemFactory;

    public SpawnerProvider(SmartSpawner plugin) {
        this.plugin = plugin;
        this.spawnerItemFactory = plugin.getSpawnerItemFactory();
    }

    public String getName() {
        return "SmartSpawner";
    }

    public ItemStack getSpawnerItem(EntityType entityType) {
        return this.spawnerItemFactory.createSpawnerItem(entityType);
    }

    public EntityType getSpawnerEntityType(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() != Material.SPAWNER) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (!(meta instanceof BlockStateMeta)) {
            return null;
        }
        BlockStateMeta blockMeta = (BlockStateMeta)meta;
        CreatureSpawner spawner = (CreatureSpawner)blockMeta.getBlockState();
        EntityType entityType = spawner.getSpawnedType();
        if (entityType == null || entityType == EntityType.UNKNOWN) {
            return null;
        }
        return entityType;
    }
}

