/*
 * Decompiled with CFR 0.152.
 */
package github.nighter.smartspawner.hooks.shops.api.zshop;

import fr.maxlego08.zshop.api.ShopManager;
import fr.maxlego08.zshop.api.buttons.ItemButton;
import github.nighter.smartspawner.Scheduler;
import github.nighter.smartspawner.SmartSpawner;
import github.nighter.smartspawner.holders.StoragePageHolder;
import github.nighter.smartspawner.hooks.shops.IShopIntegration;
import github.nighter.smartspawner.hooks.shops.SaleLogger;
import github.nighter.smartspawner.language.LanguageManager;
import github.nighter.smartspawner.language.MessageService;
import github.nighter.smartspawner.spawner.properties.SpawnerData;
import github.nighter.smartspawner.spawner.properties.VirtualInventory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class ZShop
implements IShopIntegration {
    private final SmartSpawner plugin;
    private final LanguageManager languageManager;
    private final MessageService messageService;
    private ShopManager shopManager;
    private Economy vaultEconomy;
    private static final long TRANSACTION_TIMEOUT_MS = 5000L;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<UUID, CompletableFuture<Boolean>> pendingSales = new ConcurrentHashMap<UUID, CompletableFuture<Boolean>>();

    public ZShop(SmartSpawner plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.messageService = plugin.getMessageService();
        this.setupVaultEconomy();
    }

    private boolean setupVaultEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.vaultEconomy = (Economy)rsp.getProvider();
        return this.vaultEconomy != null;
    }

    private Optional<ItemButton> getItemButton(Player player, ItemStack itemStack) {
        try {
            ShopManager shopManager = this.getShopManager();
            return shopManager.getItemButton(player, itemStack);
        }
        catch (Exception exception) {
            this.plugin.getLogger().log(Level.SEVERE, "Error getting item button", exception);
            return Optional.empty();
        }
    }

    public ShopManager getShopManager() {
        if (this.shopManager != null) {
            return this.shopManager;
        }
        this.shopManager = (ShopManager)this.plugin.getServer().getServicesManager().getRegistration(ShopManager.class).getProvider();
        return this.shopManager;
    }

    private double calculateNetAmount(double grossAmount, double taxPercentage) {
        if (this.plugin.getConfig().getBoolean("tax.enabled", false)) {
            return grossAmount * (1.0 - taxPercentage / 100.0);
        }
        return grossAmount;
    }

    @Override
    public boolean sellAllItems(Player player, SpawnerData spawner) {
        if (!this.isEnabled() || this.vaultEconomy == null) {
            this.plugin.getLogger().warning("Support for zShop requires Vault as a currency provider");
            return false;
        }
        if (this.pendingSales.containsKey(player.getUniqueId())) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        ReentrantLock lock = spawner.getLock();
        if (!lock.tryLock()) {
            this.messageService.sendMessage(player, "shop.transaction_in_progress");
            return false;
        }
        try {
            CompletableFuture<Boolean> saleFuture = CompletableFuture.supplyAsync(() -> this.processSaleAsync(player, spawner), this.executorService);
            this.pendingSales.put(player.getUniqueId(), saleFuture);
            saleFuture.whenComplete((success, error) -> {
                this.pendingSales.remove(player.getUniqueId());
                lock.unlock();
                if (error != null) {
                    this.plugin.getLogger().log(Level.SEVERE, "Error processing sale", (Throwable)error);
                    this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.sale_failed"));
                }
            });
            try {
                Boolean result = saleFuture.get(100L, TimeUnit.MILLISECONDS);
                return result != null && result != false;
            }
            catch (TimeoutException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (Exception e) {
            lock.unlock();
            this.plugin.getLogger().log(Level.SEVERE, "Error initiating sale", e);
            return false;
        }
    }

    private boolean processSaleAsync(Player player, SpawnerData spawner) {
        VirtualInventory virtualInv = spawner.getVirtualInventory();
        Map<VirtualInventory.ItemSignature, Long> items = virtualInv.getConsolidatedItems();
        if (items.isEmpty()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_items"));
            return false;
        }
        SaleCalculationResult calculation = this.calculateSalePrices(player, items);
        if (!calculation.isValid()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.messageService.sendMessage(player, "shop.no_sellable_items"));
            return false;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            virtualInv.removeItems(calculation.getItemsToRemove());
            if (player.getOpenInventory().getTopInventory().getHolder() instanceof StoragePageHolder) {
                Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
            }
        });
        double taxPercentage = this.plugin.getConfig().getDouble("tax.percentage", 10.0);
        double netAmount = this.calculateNetAmount(calculation.getTotalGrossPrice(), taxPercentage);
        try {
            CompletableFuture depositFuture = new CompletableFuture();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                boolean success = this.vaultEconomy.depositPlayer((OfflinePlayer)player, netAmount).transactionSuccess();
                depositFuture.complete(success);
            });
            boolean success = (Boolean)depositFuture.get(5000L, TimeUnit.MILLISECONDS);
            if (!success) {
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    virtualInv.addItems(calculation.getItemsToRemove());
                    this.messageService.sendMessage(player, "shop.sale_failed");
                    if (player.getOpenInventory().getTopInventory().getHolder() instanceof StoragePageHolder) {
                        Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
                    }
                });
                return false;
            }
            if (this.plugin.getConfig().getBoolean("log_transactions.enabled", true)) {
                this.logSalesAsync(calculation, player.getName());
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.sendSuccessMessage(player, calculation.getTotalAmount(), netAmount, calculation.getTotalGrossPrice(), taxPercentage));
            return true;
        }
        catch (Exception e) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                virtualInv.addItems(calculation.getItemsToRemove());
                Scheduler.runTask(() -> this.plugin.getSpawnerGuiViewManager().updateSpawnerMenuViewers(spawner));
                this.messageService.sendMessage(player, "shop.sale_failed");
            });
            return false;
        }
    }

    private void logSalesAsync(SaleCalculationResult calculation, String playerName) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            for (Map.Entry<ItemStack, Double> entry : calculation.getItemPrices().entrySet()) {
                ItemStack item = entry.getKey();
                double price = entry.getValue();
                SaleLogger.getInstance().logSale(playerName, item.getType().name(), item.getAmount(), price, "VAULT");
            }
        });
    }

    private void sendSuccessMessage(Player player, int totalAmount, double netAmount, double grossAmount, double taxPercentage) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("amount", String.valueOf(this.languageManager.formatNumber(totalAmount)));
        placeholders.put("price", this.formatMonetaryValue(netAmount));
        if (this.plugin.getConfig().getBoolean("tax.enabled", false)) {
            placeholders.put("gross", this.formatMonetaryValue(grossAmount));
            placeholders.put("tax", String.format("%.2f", taxPercentage));
            this.messageService.sendMessage(player, "shop.sell_all_with_tax", placeholders);
        } else {
            this.messageService.sendMessage(player, "shop.sell_all", placeholders);
        }
    }

    private String formatMonetaryValue(double value) {
        return this.formatPrice(value, true);
    }

    private SaleCalculationResult calculateSalePrices(Player player, Map<VirtualInventory.ItemSignature, Long> items) {
        double totalGrossPrice = 0.0;
        int totalAmount = 0;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        HashMap<ItemStack, Double> itemPrices = new HashMap<ItemStack, Double>();
        boolean foundSellableItem = false;
        for (Map.Entry<VirtualInventory.ItemSignature, Long> entry : items.entrySet()) {
            ItemButton sellButton;
            double sellPrice;
            Optional<ItemButton> sellButtonOpt;
            ItemStack template = entry.getKey().getTemplate();
            long amount = entry.getValue();
            if (amount <= 0L || (sellButtonOpt = this.getItemButton(player, template)).isEmpty() || (sellPrice = (sellButton = sellButtonOpt.get()).getSellPrice(player, (int)amount)) <= 0.0) continue;
            foundSellableItem = true;
            ItemStack itemToRemove = template.clone();
            int removeAmount = (int)Math.min(amount, Integer.MAX_VALUE);
            itemToRemove.setAmount(removeAmount);
            itemsToRemove.add(itemToRemove);
            totalGrossPrice += sellPrice;
            totalAmount += removeAmount;
            itemPrices.put(itemToRemove, sellPrice);
        }
        return new SaleCalculationResult(totalGrossPrice, totalAmount, itemsToRemove, itemPrices, foundSellableItem);
    }

    @Override
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Override
    public boolean isEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled("zShop");
    }

    private static class SaleCalculationResult {
        private final double totalGrossPrice;
        private final int totalAmount;
        private final List<ItemStack> itemsToRemove;
        private final Map<ItemStack, Double> itemPrices;
        private final boolean valid;

        public SaleCalculationResult(double totalGrossPrice, int totalAmount, List<ItemStack> itemsToRemove, Map<ItemStack, Double> itemPrices, boolean valid) {
            this.totalGrossPrice = totalGrossPrice;
            this.totalAmount = totalAmount;
            this.itemsToRemove = itemsToRemove;
            this.itemPrices = itemPrices;
            this.valid = valid;
        }

        public double getTotalGrossPrice() {
            return this.totalGrossPrice;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public List<ItemStack> getItemsToRemove() {
            return this.itemsToRemove;
        }

        public Map<ItemStack, Double> getItemPrices() {
            return this.itemPrices;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

